/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongLongHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public final class UndirectedSingleShortestLoopCursor
extends UndirectedShortestLoopCursor
implements ShortestPathBFS {
    private final MemoryTracker memoryTracker;
    private final long startNode;
    private final Read read;
    private final NodeCursor nodeCursor;
    private final RelationshipTraversalCursor relCursor;
    private final int[] types;
    private final int maxDepth;
    private final LongPredicate nodeFilter;
    private final Predicate<RelationshipTraversalEntities> relationshipsFilter;
    private PathReference pathReference;

    public UndirectedSingleShortestLoopCursor(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relationshipFilter, MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.startNode = startNode;
        this.types = types;
        this.maxDepth = maxDepth;
        this.read = read;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.nodeFilter = nodeFilter;
        this.relationshipsFilter = relationshipFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        HeapTrackingLongObjectHashMap pathTracing = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.memoryTracker);
        HeapTrackingLongHashSet nextFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)this.memoryTracker);
        HeapTrackingLongHashSet currentFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)this.memoryTracker);
        HeapTrackingLongLongHashMap roots = HeapTrackingCollections.newLongLongMap((MemoryTracker)this.memoryTracker);
        HeapTrackingLongHashSet currentRoots = HeapTrackingCollections.newLongSet((MemoryTracker)this.memoryTracker);
        try {
            currentFrontier.add(this.startNode);
            MutableLongIterator currentFrontierIterator = currentFrontier.longIterator();
            int currentDepth = 0;
            if (this.pathReference != null) {
                this.pathReference = null;
                boolean bl = false;
                return bl;
            }
            while (2 * (currentDepth + 1) <= this.maxDepth) {
                currentRoots.clear();
                while (currentFrontierIterator.hasNext()) {
                    long origin = currentFrontierIterator.next();
                    currentRoots.add(roots.get(origin));
                    this.read.singleNode(origin, this.nodeCursor);
                    if (!this.nodeCursor.next()) {
                        throw EntityNotFoundException.nodeUnexpectedlyDeleted((long)origin);
                    }
                    RelationshipTraversalCursor selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
                    int relCount = 0;
                    while (selectionCursor.next()) {
                        ++relCount;
                        if (!this.relationshipsFilter.test((RelationshipTraversalEntities)selectionCursor)) continue;
                        long foundNode = selectionCursor.otherNodeReference();
                        if (!roots.containsKey(foundNode)) {
                            if (origin == this.startNode) {
                                roots.put(foundNode, selectionCursor.reference());
                            } else {
                                roots.put(foundNode, roots.get(origin));
                            }
                        }
                        currentRoots.add(roots.get(foundNode));
                        UndirectedShortestLoopCursor.Loop loop = this.checkForLoop((HeapTrackingLongObjectHashMap<UndirectedShortestLoopCursor.Trace>)pathTracing, currentFrontier, nextFrontier, foundNode, origin);
                        switch (loop) {
                            case LOOP_IN_CURRENT_FRONTIER: 
                            case LOOP_IN_NEXT_FRONTIER: {
                                if (roots.get(foundNode) == roots.get(origin) && foundNode != origin) {
                                    if (!this.nodeFilter.test(foundNode)) break;
                                    nextFrontier.add(foundNode);
                                    pathTracing.put(foundNode, (Object)new UndirectedShortestLoopCursor.Trace(selectionCursor.reference(), origin));
                                    break;
                                }
                                int pathLength = loop.loopLength(currentDepth);
                                if (pathLength <= this.maxDepth) {
                                    this.pathReference = this.createPath((HeapTrackingLongObjectHashMap<UndirectedShortestLoopCursor.Trace>)pathTracing, foundNode, selectionCursor.relationshipReference(), origin, pathLength, currentDepth);
                                    this.closeInternal();
                                    boolean bl = true;
                                    return bl;
                                }
                                break;
                            }
                            case NO_LOOP: {
                                if (!this.nodeFilter.test(foundNode)) break;
                                nextFrontier.add(foundNode);
                                pathTracing.put(foundNode, (Object)new UndirectedShortestLoopCursor.Trace(selectionCursor.reference(), origin));
                            }
                        }
                    }
                    if (relCount != 1 || this.startNode != origin) continue;
                    boolean bl = false;
                    return bl;
                }
                if (nextFrontier.isEmpty()) {
                    boolean origin = false;
                    return origin;
                }
                if (currentDepth > 1 && currentRoots.size() < 2) {
                    boolean origin = false;
                    return origin;
                }
                HeapTrackingLongHashSet tmp = currentFrontier;
                currentFrontier = nextFrontier;
                currentFrontierIterator = currentFrontier.longIterator();
                nextFrontier = tmp;
                nextFrontier.clear();
                ++currentDepth;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            currentRoots.close();
            pathTracing.close();
            currentFrontier.close();
            nextFrontier.close();
            roots.close();
        }
    }

    private UndirectedShortestLoopCursor.Loop checkForLoop(HeapTrackingLongObjectHashMap<UndirectedShortestLoopCursor.Trace> pathTracing, HeapTrackingLongHashSet currentFrontier, HeapTrackingLongHashSet nextFrontier, long foundNode, long origin) {
        if (foundNode == this.startNode) {
            if (origin == foundNode) {
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_CURRENT_FRONTIER;
            }
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        if (origin == foundNode) {
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        UndirectedShortestLoopCursor.Trace trace = (UndirectedShortestLoopCursor.Trace)pathTracing.get(foundNode);
        if (trace != null) {
            if (origin != this.startNode && trace.prevNode() == origin) {
                return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
            }
            if (currentFrontier.contains(foundNode)) {
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_CURRENT_FRONTIER;
            }
            if (nextFrontier.contains(foundNode)) {
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_NEXT_FRONTIER;
            }
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        return UndirectedShortestLoopCursor.Loop.NO_LOOP;
    }

    private PathReference createPath(HeapTrackingLongObjectHashMap<UndirectedShortestLoopCursor.Trace> pathTracing, long intersectionNode, long intersectionRelationship, long originNode, int pathLength, int currentDepth) {
        UndirectedShortestLoopCursor.Trace trace;
        int i;
        if (intersectionNode == originNode) {
            assert (currentDepth == 0);
            return VirtualValues.pathReference((long[])new long[]{intersectionNode, intersectionNode}, (long[])new long[]{intersectionRelationship});
        }
        long[] relationships = new long[pathLength];
        long[] nodes = new long[pathLength + 1];
        int intersectionIndex = nodes.length / 2;
        nodes[intersectionIndex] = intersectionNode;
        nodes[intersectionIndex - 1] = originNode;
        relationships[intersectionIndex - 1] = intersectionRelationship;
        for (i = intersectionIndex + 1; i < nodes.length; ++i) {
            trace = (UndirectedShortestLoopCursor.Trace)pathTracing.get(nodes[i - 1]);
            nodes[i] = trace.prevNode();
            relationships[i - 1] = trace.relId();
        }
        for (i = intersectionIndex - 1; i > 0; --i) {
            trace = (UndirectedShortestLoopCursor.Trace)pathTracing.get(nodes[i]);
            nodes[i - 1] = trace.prevNode();
            relationships[i - 1] = trace.relId();
        }
        return VirtualValues.pathReference((long[])nodes, (long[])relationships);
    }

    @Override
    public PathReference path() {
        if (this.pathReference == null) {
            throw new NoSuchElementException();
        }
        return this.pathReference;
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        if (this.nodeCursor != null) {
            this.nodeCursor.setTracer(tracer);
        }
        if (this.relCursor != null) {
            this.relCursor.setTracer(tracer);
        }
    }

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        this.next();
        return Iterators.iterator((Object)this.pathReference);
    }
}

