/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayDeque;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongLongHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopCursor;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public final class UndirectedMultiShortestLoopCursor
extends UndirectedShortestLoopCursor
implements ShortestPathBFS {
    private final MemoryTracker memoryTracker;
    private final long startNode;
    private final Read read;
    private final NodeCursor nodeCursor;
    private final RelationshipTraversalCursor relCursor;
    private final int[] types;
    private final int maxDepth;
    private int intersectionDepth;
    private final LongPredicate nodeFilter;
    private final Predicate<RelationshipTraversalEntities> relationshipsFilter;
    private boolean isClosed;
    private HeapTrackingLongHashSet currentFrontier;
    private LongIterator currentFrontierIterator;
    private int currentDepth;
    private HeapTrackingLongHashSet nextFrontier;
    private final PathTracer pathTracer;
    private final HeapTrackingLongHashSet intersections;
    private DFSIterator dfs;
    private PathReference pathReference;
    private boolean intersectionFoundEarly;

    public UndirectedMultiShortestLoopCursor(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relationshipFilter, MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.startNode = startNode;
        this.types = types;
        this.maxDepth = maxDepth;
        this.intersectionDepth = maxDepth;
        this.read = read;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.nodeFilter = nodeFilter;
        this.relationshipsFilter = relationshipFilter;
        this.isClosed = false;
        this.dfs = null;
        this.pathTracer = new PathTracer(memoryTracker, startNode);
        this.pathTracer.depths.put(startNode, 0);
        this.nextFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
        this.currentFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
        this.currentFrontier.add(startNode);
        this.currentFrontierIterator = this.currentFrontier.longIterator();
        this.intersections = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
        this.currentDepth = 0;
        this.intersectionFoundEarly = false;
    }

    @Override
    public boolean next() {
        if (this.dfs != null) {
            if (this.dfs.hasNext()) {
                this.pathReference = (PathReference)this.dfs.next();
                return true;
            }
            this.closeInternal();
            return false;
        }
        if (this.bfs()) {
            this.pathReference = (PathReference)this.dfs.next();
            return true;
        }
        return false;
    }

    private boolean bfs() {
        int pathLength = -1;
        HeapTrackingLongHashSet currentRoots = HeapTrackingCollections.newLongSet((MemoryTracker)this.memoryTracker);
        while (2 * (this.currentDepth + 1) - 1 <= this.maxDepth && this.currentDepth <= this.intersectionDepth) {
            currentRoots.clear();
            while (this.currentFrontierIterator.hasNext()) {
                long origin = this.currentFrontierIterator.next();
                currentRoots.add(this.pathTracer.originRelationship(origin));
                this.read.singleNode(origin, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    throw EntityNotFoundException.nodeUnexpectedlyDeleted((long)origin);
                }
                RelationshipTraversalCursor selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
                int relCount = 0;
                while (selectionCursor.next()) {
                    ++relCount;
                    if (!this.relationshipsFilter.test((RelationshipTraversalEntities)selectionCursor)) continue;
                    long foundNode = selectionCursor.otherNodeReference();
                    UndirectedShortestLoopCursor.Loop loop = this.checkForLoop(this.pathTracer, this.currentFrontier, this.nextFrontier, foundNode, origin);
                    currentRoots.add(this.pathTracer.originRelationship(foundNode));
                    int temp = this.handleLoop(loop, foundNode, this.intersectionFoundEarly, origin, selectionCursor.reference());
                    if (temp == -1) continue;
                    pathLength = temp;
                }
                if (relCount == 1 && this.startNode == origin) {
                    currentRoots.close();
                    return false;
                }
                if (this.currentDepth <= 1 || currentRoots.size() >= 2) continue;
                currentRoots.close();
                return false;
            }
            if (this.nextFrontier.isEmpty()) break;
            HeapTrackingLongHashSet tmp = this.currentFrontier;
            this.currentFrontier = this.nextFrontier;
            this.currentFrontierIterator = this.currentFrontier.longIterator();
            this.nextFrontier = tmp;
            this.nextFrontier.clear();
            ++this.currentDepth;
        }
        currentRoots.close();
        if (this.intersections.isEmpty()) {
            this.closeInternal();
            return false;
        }
        this.dfs = this.intersectionDepth == 1 ? new ShortestLoopLengthOneIterator() : new MultiShortestLoopIterator(this.startNode, pathLength);
        return this.dfs.hasNext();
    }

    private int handleLoop(UndirectedShortestLoopCursor.Loop loop, long foundNode, boolean intersectionFoundEarly, long origin, long relationship) {
        if (!(this.intersectionDepth > this.currentDepth || this.intersections.contains(foundNode) && this.intersections.contains(origin) || this.intersectionDepth == this.currentDepth && !intersectionFoundEarly || this.pathTracer.depth(foundNode) < this.pathTracer.depth(origin))) {
            return -1;
        }
        this.pathTracer.add(foundNode, relationship, origin, this.currentDepth + 1, this.memoryTracker);
        switch (loop) {
            case LOOP_IN_CURRENT_FRONTIER: {
                int pathLength = loop.loopLength(this.currentDepth);
                if (pathLength <= this.maxDepth) {
                    this.intersections.add(foundNode);
                    this.intersections.add(origin);
                    this.intersectionDepth = origin == foundNode ? this.currentDepth : this.currentDepth + 1;
                }
                return pathLength;
            }
            case LOOP_IN_NEXT_FRONTIER: {
                if (this.pathTracer.depth(foundNode) > this.intersectionDepth) {
                    return -1;
                }
                int pathLength = loop.loopLength(this.currentDepth);
                if (this.nodeFilter.test(foundNode)) {
                    this.nextFrontier.add(foundNode);
                    this.intersections.add(foundNode);
                    this.intersectionFoundEarly = true;
                    this.intersectionDepth = this.currentDepth + 1;
                }
                return pathLength;
            }
            case NO_LOOP: {
                if (this.nodeFilter.test(foundNode)) {
                    this.nextFrontier.add(foundNode);
                }
                return -1;
            }
        }
        return -1;
    }

    private UndirectedShortestLoopCursor.Loop checkForLoop(PathTracer pathTracing, HeapTrackingLongHashSet currentFrontier, HeapTrackingLongHashSet nextFrontier, long foundNode, long origin) {
        if (foundNode == this.startNode) {
            if (origin == foundNode) {
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_CURRENT_FRONTIER;
            }
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        if (origin == foundNode) {
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        HeapTrackingArrayList<UndirectedShortestLoopCursor.Trace> traces = pathTracing.get(foundNode);
        if (traces != null) {
            if (origin != this.startNode && traces.stream().anyMatch(trace -> trace.prevNode() == origin)) {
                return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
            }
            if (currentFrontier.contains(foundNode)) {
                if (pathTracing.originRelationship(foundNode) == pathTracing.originRelationship(origin)) {
                    return UndirectedShortestLoopCursor.Loop.NO_LOOP;
                }
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_CURRENT_FRONTIER;
            }
            if (nextFrontier.contains(foundNode)) {
                if (pathTracing.originRelationship(foundNode) == pathTracing.originRelationship(origin)) {
                    return UndirectedShortestLoopCursor.Loop.NO_LOOP;
                }
                return UndirectedShortestLoopCursor.Loop.LOOP_IN_NEXT_FRONTIER;
            }
            return UndirectedShortestLoopCursor.Loop.ALREADY_SEEN;
        }
        return UndirectedShortestLoopCursor.Loop.NO_LOOP;
    }

    @Override
    public PathReference path() {
        if (this.pathReference == null) {
            throw new NoSuchElementException();
        }
        return this.pathReference;
    }

    public void closeInternal() {
        if (!this.isClosed) {
            for (long key : this.pathTracer.pathTracing.keySet().toArray()) {
                ((HeapTrackingArrayList)this.pathTracer.pathTracing.get(key)).close();
            }
            this.pathTracer.close();
            this.currentFrontier.close();
            this.nextFrontier.close();
            this.intersections.close();
            if (this.dfs != null) {
                this.dfs.close();
            }
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        if (this.nodeCursor != null) {
            this.nodeCursor.setTracer(tracer);
        }
        if (this.relCursor != null) {
            this.relCursor.setTracer(tracer);
        }
    }

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        if (this.dfs == null && !this.bfs()) {
            this.dfs = new EmptyIterator();
        }
        return this.dfs;
    }

    private static abstract class DFSIterator
    extends PrefetchingIterator<PathReference>
    implements Closeable {
        private DFSIterator() {
        }

        @Override
        public void close() {
        }
    }

    private static class PathTracer {
        private final long start;
        private final HeapTrackingLongObjectHashMap<HeapTrackingArrayList<UndirectedShortestLoopCursor.Trace>> pathTracing;
        private final HeapTrackingLongIntHashMap depths;
        private final HeapTrackingLongLongHashMap originRelationships;

        public PathTracer(MemoryTracker memoryTracker, long start) {
            this.pathTracing = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
            this.depths = HeapTrackingCollections.newLongIntMap((MemoryTracker)memoryTracker);
            this.originRelationships = HeapTrackingCollections.newLongLongMap((MemoryTracker)memoryTracker);
            this.start = start;
        }

        public int depth(long node) {
            if (!this.depths.containsKey(node)) {
                return Integer.MAX_VALUE;
            }
            return this.depths.get(node);
        }

        public long originRelationship(long node) {
            if (!this.originRelationships.containsKey(node)) {
                return -1L;
            }
            return this.originRelationships.get(node);
        }

        public void add(long node, long relationship, long origin, int depth, MemoryTracker memoryTracker) {
            long originRelationship = origin == this.start ? relationship : this.originRelationships.get(origin);
            if (!this.depths.containsKey(node)) {
                this.depths.put(node, depth);
            }
            if (!this.originRelationships.containsKey(node)) {
                this.originRelationships.put(node, originRelationship);
            }
            if (!this.pathTracing.containsKey(node)) {
                this.pathTracing.put(node, (Object)HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker));
            }
            HeapTrackingArrayList traceList = (HeapTrackingArrayList)this.pathTracing.get(node);
            traceList.add((Object)new UndirectedShortestLoopCursor.Trace(relationship, origin));
            this.pathTracing.put(node, (Object)traceList);
        }

        public HeapTrackingArrayList<UndirectedShortestLoopCursor.Trace> get(long node) {
            return (HeapTrackingArrayList)this.pathTracing.get(node);
        }

        public void close() {
            for (HeapTrackingArrayList traces : this.pathTracing.values()) {
                traces.close();
            }
            this.pathTracing.close();
            this.depths.close();
            this.originRelationships.close();
        }
    }

    private final class ShortestLoopLengthOneIterator
    extends DFSIterator {
        private final HeapTrackingArrayDeque<State> stack;
        private State current;
        private int currentTrace;

        public ShortestLoopLengthOneIterator() {
            this.stack = HeapTrackingCollections.newArrayDeque((MemoryTracker)UndirectedMultiShortestLoopCursor.this.memoryTracker);
            this.current = null;
            this.currentTrace = -1;
            for (UndirectedShortestLoopCursor.Trace trace : UndirectedMultiShortestLoopCursor.this.pathTracer.get(UndirectedMultiShortestLoopCursor.this.startNode)) {
                State state = new State(trace, UndirectedMultiShortestLoopCursor.this.intersections.contains(trace.prevNode()), UndirectedMultiShortestLoopCursor.this.pathTracer.depth(trace.prevNode()));
                this.stack.push((Object)state);
            }
        }

        private PathReference nextFromTraces() {
            while (this.currentTrace >= 0) {
                UndirectedShortestLoopCursor.Trace trace = (UndirectedShortestLoopCursor.Trace)UndirectedMultiShortestLoopCursor.this.pathTracer.get(this.current.currentNode()).get(this.currentTrace);
                --this.currentTrace;
                if (this.current.trace.relId() == trace.relId() || trace.prevNode() != UndirectedMultiShortestLoopCursor.this.startNode) continue;
                return this.createPath(trace.relId());
            }
            return null;
        }

        protected PathReference fetchNextOrNull() {
            if (this.currentTrace != -1) {
                return this.nextFromTraces();
            }
            if (!this.stack.isEmpty()) {
                this.current = (State)this.stack.pop();
                this.currentTrace = UndirectedMultiShortestLoopCursor.this.pathTracer.get(this.current.currentNode()).size() - 1;
                return this.nextFromTraces();
            }
            return null;
        }

        public PathReference createPath(long relation) {
            long[] relationships = new long[2];
            long[] nodes = new long[]{UndirectedMultiShortestLoopCursor.this.startNode, this.current.currentNode(), UndirectedMultiShortestLoopCursor.this.startNode};
            relationships[0] = this.current.trace.relId();
            relationships[1] = relation;
            return VirtualValues.pathReference((long[])nodes, (long[])relationships);
        }

        @Override
        public void close() {
            this.stack.close();
        }
    }

    private final class MultiShortestLoopIterator
    extends DFSIterator {
        private final long start;
        private final long[] currentNodes;
        private final long[] currentRelationships;
        private final HeapTrackingArrayDeque<State> stack;

        public MultiShortestLoopIterator(long start, int pathLength) {
            this.start = start;
            this.stack = HeapTrackingCollections.newArrayDeque((MemoryTracker)UndirectedMultiShortestLoopCursor.this.memoryTracker);
            UndirectedMultiShortestLoopCursor.this.memoryTracker.allocateHeap(HeapEstimator.sizeOfLongArray((int)(2 * pathLength + 1)));
            this.currentNodes = new long[pathLength + 1];
            this.currentNodes[0] = UndirectedMultiShortestLoopCursor.this.startNode;
            this.currentRelationships = new long[pathLength];
            for (UndirectedShortestLoopCursor.Trace trace : UndirectedMultiShortestLoopCursor.this.pathTracer.get(start)) {
                State state = new State(trace, UndirectedMultiShortestLoopCursor.this.intersections.contains(trace.prevNode()), UndirectedMultiShortestLoopCursor.this.pathTracer.depth(trace.prevNode()));
                this.stack.push((Object)state);
            }
        }

        protected PathReference fetchNextOrNull() {
            while (!this.stack.isEmpty()) {
                State current = (State)this.stack.pop();
                this.currentNodes[current.depth + 1] = current.currentNode();
                this.currentRelationships[current.depth] = current.trace.relId();
                if (current.currentNode() == UndirectedMultiShortestLoopCursor.this.startNode && current.direction == State.Direction.REACHED_INTERSECTION) {
                    return VirtualValues.pathReference((long[])((long[])this.currentNodes.clone()), (long[])((long[])this.currentRelationships.clone()));
                }
                HeapTrackingArrayList<UndirectedShortestLoopCursor.Trace> traces = UndirectedMultiShortestLoopCursor.this.pathTracer.get(current.currentNode());
                HeapTrackingArrayDeque stackAddition = HeapTrackingCollections.newArrayDeque((MemoryTracker)UndirectedMultiShortestLoopCursor.this.memoryTracker);
                for (UndirectedShortestLoopCursor.Trace trace : traces) {
                    if (!this.visited(trace, current.depth) && trace.prevNode() == this.start) {
                        this.currentNodes[this.currentNodes.length - 1] = trace.prevNode();
                        this.currentRelationships[this.currentRelationships.length - 1] = trace.relId();
                        return VirtualValues.pathReference((long[])((long[])this.currentNodes.clone()), (long[])((long[])this.currentRelationships.clone()));
                    }
                    if (!current.valid(this.currentRelationships.length, UndirectedMultiShortestLoopCursor.this.pathTracer.depth(trace.prevNode())) || this.visited(trace, current.depth)) continue;
                    State newState = new State(current, trace, UndirectedMultiShortestLoopCursor.this.intersections.contains(trace.prevNode()), UndirectedMultiShortestLoopCursor.this.pathTracer.depth(trace.prevNode()));
                    stackAddition.push((Object)newState);
                }
                for (State newState : stackAddition) {
                    this.stack.push((Object)newState);
                }
            }
            return null;
        }

        private boolean visited(UndirectedShortestLoopCursor.Trace trace, int depth) {
            for (int i = 0; i <= depth; ++i) {
                if (this.currentRelationships[i] != trace.relId()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            this.stack.close();
        }
    }

    private static class EmptyIterator
    extends DFSIterator {
        private EmptyIterator() {
        }

        protected PathReference fetchNextOrNull() {
            return null;
        }
    }

    private static class State {
        private final UndirectedShortestLoopCursor.Trace trace;
        private final int depth;
        private final Direction direction;
        private final int nodeDepth;

        public State(UndirectedShortestLoopCursor.Trace trace, boolean isIntersection, int nodeDepth) {
            this.depth = 0;
            this.trace = trace;
            this.nodeDepth = nodeDepth;
            this.direction = isIntersection ? Direction.REACHED_INTERSECTION : Direction.TOWARDS_INTERSECTION;
        }

        public State(State oldState, UndirectedShortestLoopCursor.Trace trace, boolean isIntersection, int traceDepth) {
            this.depth = oldState.depth + 1;
            this.nodeDepth = traceDepth;
            this.direction = this.depth == 0 ? (isIntersection ? Direction.REACHED_INTERSECTION : Direction.TOWARDS_INTERSECTION) : (oldState.nodeDepth < traceDepth && isIntersection ? Direction.REACHED_INTERSECTION : (oldState.nodeDepth < traceDepth ? Direction.TOWARDS_INTERSECTION : Direction.TOWARDS_SOURCE));
            this.trace = trace;
        }

        public boolean valid(int pathLength, int traceDepth) {
            if (this.direction == Direction.TOWARDS_SOURCE && traceDepth < this.nodeDepth) {
                return true;
            }
            if (this.direction == Direction.TOWARDS_INTERSECTION && traceDepth > this.nodeDepth) {
                return true;
            }
            if (this.direction == Direction.REACHED_INTERSECTION && traceDepth == this.nodeDepth) {
                return true;
            }
            return this.direction == Direction.REACHED_INTERSECTION && pathLength % 2 == 0;
        }

        public long currentNode() {
            return this.trace.prevNode();
        }

        private static enum Direction {
            TOWARDS_INTERSECTION,
            TOWARDS_SOURCE,
            REACHED_INTERSECTION;

        }
    }
}

