/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.MREValidator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostTracking;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public interface TraversalPathModeFactory {
    public SignpostTracking twoWaySignpostTracking();

    public Lengths lengths();

    public MREValidator mreValidator();

    public static TraversalPathModeFactory trailMode(final MemoryTracker memoryTracker, final PPBFSHooks hooks) {
        return new TraversalPathModeFactory(){

            @Override
            public SignpostTracking twoWaySignpostTracking() {
                return SignpostTracking.trailMode(memoryTracker, hooks);
            }

            @Override
            public Lengths lengths() {
                return Lengths.trailMode();
            }

            @Override
            public MREValidator mreValidator() {
                return MREValidator.TRAIL_MODE;
            }
        };
    }

    public static TraversalPathModeFactory walkMode() {
        return new TraversalPathModeFactory(){

            @Override
            public SignpostTracking twoWaySignpostTracking() {
                return SignpostTracking.walkMode();
            }

            @Override
            public Lengths lengths() {
                return Lengths.walkMode();
            }

            @Override
            public MREValidator mreValidator() {
                return MREValidator.WALK_MODE;
            }
        };
    }
}

