/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.cursors.ExpressionCursors;
import org.neo4j.cypher.operations.CypherCoercions;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;

class ListCoercer
implements CypherCoercions.Coercer {
    private final Neo4jTypes.AnyType innerType;
    private final CypherCoercions.Coercer innerCoercer;

    public ListCoercer(Neo4jTypes.AnyType innerType) {
        this.innerType = innerType;
        this.innerCoercer = CypherCoercions.coercerFromType(innerType);
    }

    @Override
    public AnyValue apply(AnyValue value, DbAccess access, ExpressionCursors cursors) {
        if (value instanceof SequenceValue) {
            ListValue list;
            ArrayValue array;
            SequenceValue sequence = (SequenceValue)value;
            if (sequence.isEmpty()) {
                return VirtualValues.EMPTY_LIST;
            }
            if (sequence instanceof ArrayValue && ListCoercer.itemsHaveCorrectType(array = (ArrayValue)sequence, this.innerType)) {
                return VirtualValues.fromArray((ArrayValue)array);
            }
            if (sequence instanceof ListValue && ListCoercer.itemsHaveCorrectType(list = (ListValue)sequence, this.innerType)) {
                return list;
            }
            return this.slowCoersion(sequence, access, cursors);
        }
        if (this.innerType == Neo4jTypes.NTAny && value instanceof VirtualPathValue) {
            VirtualPathValue path = (VirtualPathValue)value;
            return path.asList();
        }
        if (value instanceof MapValue) {
            MapValue map = (MapValue)value;
            return VirtualValues.list((AnyValue[])new AnyValue[]{this.innerCoercer.apply((AnyValue)map, access, cursors)});
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "List");
    }

    private ListValue slowCoersion(SequenceValue sequence, DbAccess access, ExpressionCursors cursors) {
        if (sequence.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
            int length = sequence.intSize();
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)length);
            for (int i = 0; i < length; ++i) {
                builder.add(this.innerCoercer.apply(sequence.value((long)i), access, cursors));
            }
            return builder.build();
        }
        ListValueBuilder builder = ListValueBuilder.newListBuilder();
        for (AnyValue item : sequence) {
            builder.add(this.innerCoercer.apply(item, access, cursors));
        }
        return builder.build();
    }

    private static boolean itemsHaveCorrectType(ArrayValue array, Neo4jTypes.AnyType target) {
        return switch (array.valueRepresentation()) {
            case ValueRepresentation.GEOMETRY_ARRAY -> {
                if (target == Neo4jTypes.NTGeometry) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.ZONED_DATE_TIME_ARRAY -> {
                if (target == Neo4jTypes.NTDateTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.LOCAL_DATE_TIME_ARRAY -> {
                if (target == Neo4jTypes.NTLocalDateTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.DATE_ARRAY -> {
                if (target == Neo4jTypes.NTDate) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.ZONED_TIME_ARRAY -> {
                if (target == Neo4jTypes.NTTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.LOCAL_TIME_ARRAY -> {
                if (target == Neo4jTypes.NTLocalTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.DURATION_ARRAY -> {
                if (target == Neo4jTypes.NTDuration) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.TEXT_ARRAY -> {
                if (target == Neo4jTypes.NTString) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.BOOLEAN_ARRAY -> {
                if (target == Neo4jTypes.NTBoolean) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.INT64_ARRAY -> {
                if (target == Neo4jTypes.NTInteger || target == Neo4jTypes.NTNumber) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.FLOAT64_ARRAY -> {
                if (target == Neo4jTypes.NTFloat || target == Neo4jTypes.NTNumber) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.INT32_ARRAY, ValueRepresentation.INT16_ARRAY, ValueRepresentation.INT8_ARRAY, ValueRepresentation.FLOAT32_ARRAY -> {
                if (target == Neo4jTypes.NTNumber) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean itemsHaveCorrectType(ListValue list, Neo4jTypes.AnyType target) {
        return switch (list.itemValueRepresentation()) {
            case ValueRepresentation.GEOMETRY -> {
                if (target == Neo4jTypes.NTGeometry) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.ZONED_DATE_TIME -> {
                if (target == Neo4jTypes.NTDateTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.LOCAL_DATE_TIME -> {
                if (target == Neo4jTypes.NTLocalDateTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.DATE -> {
                if (target == Neo4jTypes.NTDate) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.ZONED_TIME -> {
                if (target == Neo4jTypes.NTTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.LOCAL_TIME -> {
                if (target == Neo4jTypes.NTLocalTime) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.DURATION -> {
                if (target == Neo4jTypes.NTDuration) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.UTF16_TEXT, ValueRepresentation.UTF8_TEXT -> {
                if (target == Neo4jTypes.NTString) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.BOOLEAN -> {
                if (target == Neo4jTypes.NTBoolean) {
                    yield true;
                }
                yield false;
            }
            case ValueRepresentation.INT64, ValueRepresentation.INT32, ValueRepresentation.INT16, ValueRepresentation.INT8, ValueRepresentation.FLOAT64, ValueRepresentation.FLOAT32 -> {
                if (target == Neo4jTypes.NTNumber) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

