/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.shortestloop;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.shortestloop.UndirectedShortestLoopCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public class UndirectedShortestLoopWalkCursor
extends UndirectedShortestLoopCursor
implements ShortestPathBFS {
    private final long startNode;
    private final Read read;
    private final NodeCursor nodeCursor;
    private final RelationshipTraversalCursor relCursor;
    private final int[] types;
    private final LongPredicate nodeFilter;
    private final Predicate<RelationshipTraversalEntities> relationshipsFilter;
    private final HeapTrackingLongObjectHashMap<HeapTrackingLongArrayList> pathTracing;
    private PathReference path;
    private final MemoryTracker memoryTracker;
    private final int maxDepth;
    private boolean closed;
    private Iterator<PathReference> iterator;

    public UndirectedShortestLoopWalkCursor(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relationshipFilter, MemoryTracker memoryTracker) {
        this.startNode = startNode;
        this.read = read;
        this.types = types;
        this.maxDepth = maxDepth;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.nodeFilter = nodeFilter;
        this.relationshipsFilter = relationshipFilter;
        this.pathTracing = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
        this.path = null;
        this.memoryTracker = memoryTracker;
        this.closed = false;
        this.iterator = null;
    }

    @Override
    public boolean next() {
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                this.path = this.iterator.next();
                return true;
            }
            return false;
        }
        if (this.search()) {
            this.iterator = this.pathTracing.containsKey(this.startNode) ? new MultiShortestLoopLengthOneIterator() : new MultiShortestLoopIterator();
            this.path = this.iterator.next();
            return true;
        }
        return false;
    }

    private boolean search() {
        this.read.singleNode(this.startNode, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw EntityNotFoundException.nodeUnexpectedlyDeleted((long)this.startNode);
        }
        RelationshipTraversalCursor selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
        while (selectionCursor.next()) {
            HeapTrackingLongArrayList traces;
            long foundNode;
            if (!this.relationshipsFilter.test((RelationshipTraversalEntities)selectionCursor) || !this.nodeFilter.test(foundNode = selectionCursor.otherNodeReference()) || this.maxDepth == 1 && foundNode != this.startNode) continue;
            long foundRelationship = selectionCursor.reference();
            if (this.pathTracing.containsKey(foundNode)) {
                traces = (HeapTrackingLongArrayList)this.pathTracing.get(foundNode);
                traces.add(foundRelationship);
                this.pathTracing.put(foundNode, (Object)traces);
                continue;
            }
            traces = HeapTrackingLongArrayList.newLongArrayList((MemoryTracker)this.memoryTracker);
            traces.add(foundRelationship);
            this.pathTracing.put(foundNode, (Object)traces);
        }
        return !this.pathTracing.isEmpty();
    }

    @Override
    public PathReference path() {
        return this.path;
    }

    public void closeInternal() {
        if (!this.closed) {
            for (long key : this.pathTracing.keySet().toArray()) {
                ((HeapTrackingLongArrayList)this.pathTracing.get(key)).close();
            }
            this.pathTracing.close();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Iterator<PathReference> shortestPathIterator() {
        this.search();
        if (this.pathTracing.containsKey(this.startNode)) {
            return new MultiShortestLoopLengthOneIterator();
        }
        return new MultiShortestLoopIterator();
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        if (this.nodeCursor != null) {
            this.nodeCursor.setTracer(tracer);
        }
        if (this.relCursor != null) {
            this.relCursor.setTracer(tracer);
        }
    }

    private class MultiShortestLoopLengthOneIterator
    implements Iterator<PathReference> {
        private int rel = 0;

        @Override
        public boolean hasNext() {
            return !UndirectedShortestLoopWalkCursor.this.pathTracing.isEmpty() && this.rel < ((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(UndirectedShortestLoopWalkCursor.this.startNode)).size();
        }

        @Override
        public PathReference next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return VirtualValues.pathReference((long[])new long[]{UndirectedShortestLoopWalkCursor.this.startNode, UndirectedShortestLoopWalkCursor.this.startNode}, (long[])new long[]{((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(UndirectedShortestLoopWalkCursor.this.startNode)).get(this.rel++)});
        }
    }

    private class MultiShortestLoopIterator
    implements Iterator<PathReference> {
        private int startRel = 0;
        private int endRel = -1;
        private int target = 0;
        private final long[] targets;

        public MultiShortestLoopIterator() {
            this.targets = UndirectedShortestLoopWalkCursor.this.pathTracing.keySet().toArray();
        }

        @Override
        public boolean hasNext() {
            if (UndirectedShortestLoopWalkCursor.this.pathTracing.isEmpty()) {
                return false;
            }
            if (((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).size() - 1 > this.startRel) {
                return true;
            }
            if (((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).size() - 1 > this.endRel) {
                return true;
            }
            return this.targets.length - 1 > this.target;
        }

        @Override
        public PathReference next() {
            if (((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).size() - 1 > this.endRel) {
                ++this.endRel;
            } else if (((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).size() - 1 > this.startRel) {
                this.endRel = 0;
                ++this.startRel;
            } else if (this.targets.length - 1 > this.target) {
                ++this.target;
                this.startRel = 0;
                this.endRel = 0;
            }
            return VirtualValues.pathReference((long[])new long[]{UndirectedShortestLoopWalkCursor.this.startNode, this.targets[this.target], UndirectedShortestLoopWalkCursor.this.startNode}, (long[])new long[]{((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).get(this.startRel), ((HeapTrackingLongArrayList)UndirectedShortestLoopWalkCursor.this.pathTracing.get(this.targets[this.target])).get(this.endRel)});
        }
    }
}

