/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cypher.internal.compiler.planner.logical.CostModelMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SelectorHeuristic;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.CostComparisonListener;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanToPlanBuilderString$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.cypher.internal.util.attribution.Id;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class SystemOutCostLogger$
implements CostComparisonListener {
    public static final SystemOutCostLogger$ MODULE$ = new SystemOutCostLogger$();
    private static final AtomicLong comparisonId = new AtomicLong();
    private static final String prefix = "\t";

    private AtomicLong comparisonId() {
        return comparisonId;
    }

    private String prefix() {
        return prefix;
    }

    private String blue(String str) {
        return "\u001b[34m" + str + "\u001b[0m";
    }

    private String blue_bold(String str) {
        return "\u001b[34m\u001b[1m" + str + "\u001b[0m";
    }

    private String cyan(String str) {
        return "\u001b[36m" + str + "\u001b[0m";
    }

    private String cyan_bold(String str) {
        return "\u001b[36m\u001b[4m\u001b[1m" + str + "\u001b[0m";
    }

    private String cyan_background(String str) {
        return "\u001b[46m" + str + "\u001b[0m";
    }

    private String green(String str) {
        return "\u001b[32m" + str + "\u001b[0m";
    }

    private String magenta(String str) {
        return "\u001b[35m" + str + "\u001b[0m";
    }

    private String magenta_bold(String str) {
        return "\u001b[35m\u001b[4m\u001b[1m" + str + "\u001b[0m";
    }

    private String indent(int level, String str) {
        String ind = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(this.prefix()), level);
        return ind + str.replaceAll(System.lineSeparator(), System.lineSeparator() + ind);
    }

    @Override
    public <X, Score> void report(Function1<X, LogicalPlan> projector, Iterable<X> input, Function1<X, Score> calculateScore, LogicalPlanningContext context, Function0<String> resolved, Function1<LogicalPlan, String> resolvedPerPlan, SelectorHeuristic heuristic, Ordering<Score> evidence$3) {
        Map planCost = (Map)Map$.MODULE$.empty();
        Map planEffectiveCardinality = (Map)Map$.MODULE$.empty();
        CostModelMonitor monitor = new CostModelMonitor(planCost, planEffectiveCardinality){
            private final Map planCost$1;
            private final Map planEffectiveCardinality$1;

            public void reportPlanCost(LogicalPlan rootPlan, LogicalPlan plan, Cost cost) {
                this.planCost$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id()))), (Object)cost));
            }

            public void reportPlanEffectiveCardinality(LogicalPlan rootPlan, LogicalPlan plan, Cardinality cardinality) {
                this.planEffectiveCardinality$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id()))), (Object)cardinality));
            }
            {
                this.planCost$1 = planCost$1;
                this.planEffectiveCardinality$1 = planEffectiveCardinality$1;
            }
        };
        if (input.nonEmpty()) {
            long id = this.comparisonId().getAndIncrement();
            Predef$.MODULE$.println((Object)this.blue_bold(id + ": Resolving " + resolved.apply()));
            Predef$.MODULE$.println((Object)"Get best of:");
            ((LazyList)((LazyList)((SeqOps)input.to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).distinct()).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), calculateScore.apply(x))).sortBy((Function1 & Serializable)x$4 -> x$4._2(), evidence$3)).map((Function1 & Serializable)x$5 -> x$5._1()).map(projector).zipWithIndex().foreach((Function1 & Serializable)x0$1 -> {
                SystemOutCostLogger$.$anonfun$report$4(this, context, monitor, resolvedPerPlan, heuristic, planCost, planEffectiveCardinality, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public <X, Score> Function1<LogicalPlan, String> report$default$6() {
        return (Function1 & Serializable)x$3 -> "";
    }

    private final String costString$1(LogicalPlan rootPlan, LogicalPlan plan, Map planCost$1, LogicalPlanningContext context$1, Map planEffectiveCardinality$1) {
        double cost = ((Cost)planCost$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).gummyBears();
        double cardinality = ((Cardinality)context$1.staticComponents().planningAttributes().cardinalities().get(plan.id())).amount();
        double effectiveCardinality = ((Cardinality)planEffectiveCardinality$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).amount();
        String costStr = this.magenta(" // cost ") + this.magenta_bold(Double.toString(cost));
        String cardStr = this.magenta(", cardinality ") + this.magenta_bold(Double.toString(cardinality));
        String effCardStr = cardinality > effectiveCardinality ? this.cyan(" (effective cardinality ") + this.cyan_bold(Double.toString(effectiveCardinality)) + this.cyan(")") : "";
        return costStr + cardStr + effCardStr;
    }

    private final String planPrefixDotString$1(LogicalPlan rootPlan, LogicalPlan plan, LogicalPlanningContext context$1, Map planEffectiveCardinality$1) {
        double effectiveCardinality;
        double cardinality = ((Cardinality)context$1.staticComponents().planningAttributes().cardinalities().get(plan.id())).amount();
        if (cardinality > (effectiveCardinality = ((Cardinality)planEffectiveCardinality$1.apply((Object)new Tuple2((Object)new Id(rootPlan.id()), (Object)new Id(plan.id())))).amount())) {
            return this.cyan_background(".");
        }
        return ".";
    }

    public static final /* synthetic */ void $anonfun$report$4(SystemOutCostLogger$ $this, LogicalPlanningContext context$1, CostModelMonitor monitor$1, Function1 resolvedPerPlan$1, SelectorHeuristic heuristic$1, Map planCost$1, Map planEffectiveCardinality$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LogicalPlan plan2 = (LogicalPlan)tuple2._1();
            int index = tuple2._2$mcI$sp();
            context$1.cost().costFor(plan2, context$1.plannerState().input(), context$1.semanticTable(), context$1.staticComponents().planningAttributes().cardinalities(), context$1.staticComponents().planningAttributes().providedOrders(), context$1.plannerState().accessedAndAggregatingProperties(), context$1.statistics(), monitor$1);
            String winner = index == 0 ? MODULE$.green(" [winner]") : "";
            String resolvedStr = MODULE$.cyan(" " + resolvedPerPlan$1.apply((Object)plan2));
            String header = MODULE$.blue(index + ": Plan #" + plan2.debugId()) + winner + resolvedStr;
            String planWithCosts = LogicalPlanToPlanBuilderString$.MODULE$.apply(plan2, (Function1 & Serializable)plan -> $this.costString$1(plan2, (LogicalPlan)plan, planCost$1, context$1, planEffectiveCardinality$1), (Function1 & Serializable)plan -> $this.planPrefixDotString$1(plan2, (LogicalPlan)plan, context$1, planEffectiveCardinality$1));
            int hints2 = ((PlannerQuery)context$1.staticComponents().planningAttributes().solveds().get(plan2.id())).numHints();
            int heuristicValue = heuristic$1.tieBreaker(plan2);
            String extra = "(hints: " + hints2 + ", heuristic: " + heuristicValue + ")";
            Predef$.MODULE$.println((Object)MODULE$.indent(1, header));
            Predef$.MODULE$.println((Object)MODULE$.indent(2, planWithCosts));
            Predef$.MODULE$.println((Object)MODULE$.indent(2, extra));
            Predef$.MODULE$.println();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SystemOutCostLogger$() {
    }
}

