/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps.index;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProvider;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexPlanProvider;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.logical.plans.ordering.ProvidedOrderFactory;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class RelationshipIndexLeafPlanner$
implements IndexCompatiblePredicatesProvider,
Serializable {
    public static final RelationshipIndexLeafPlanner$ MODULE$ = new RelationshipIndexLeafPlanner$();

    static {
        IndexCompatiblePredicatesProvider.$init$(MODULE$);
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<LogicalVariable> arguments, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        return IndexCompatiblePredicatesProvider.findIndexCompatiblePredicates$(this, predicates, arguments, semanticTable, planContext, indexPredicateProviderContext);
    }

    public Set<RelationshipIndexLeafPlanner.RelationshipIndexMatch> findIndexMatchesForQueryGraph(QueryGraph qg, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, InterestingOrderConfig interestingOrderConfig, ProvidedOrderFactory providedOrderFactory, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        scala.collection.immutable.Iterable iterable;
        Set predicates = qg.selections().flatPredicatesSet();
        Map patternRelationshipsMap = ((IterableOnceOps)qg.patternRelationships().collect((PartialFunction)new Serializable(qg){
            private static final long serialVersionUID = 0L;
            private final QueryGraph qg$2;

            public final <A1 extends PatternRelationship, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    SeqOps seqOps;
                    LogicalVariable rel = A1.variable();
                    Seq seq = A1.types();
                    PatternLength patternLength = A1.length();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && SimplePatternLength$.MODULE$.equals(patternLength) && !RelationshipIndexLeafPlanner$.org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(A1, this.qg$2)) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rel), A1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PatternRelationship x1) {
                PatternRelationship patternRelationship = x1;
                if (patternRelationship != null) {
                    SeqOps seqOps;
                    Seq seq = patternRelationship.types();
                    PatternLength patternLength = patternRelationship.length();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && SimplePatternLength$.MODULE$.equals(patternLength) && !RelationshipIndexLeafPlanner$.org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(patternRelationship, this.qg$2)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.qg$2 = qg$2;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (patternRelationshipsMap.isEmpty()) {
            iterable = (scala.collection.immutable.Iterable)package$.MODULE$.Seq().empty();
        } else {
            Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> compatiblePropertyPredicates = this.findIndexCompatiblePredicates((Set<Expression>)predicates, (Set<LogicalVariable>)qg.argumentIds(), semanticTable, planContext, indexPredicateProviderContext, (Iterable<PatternRelationship>)patternRelationshipsMap.values());
            iterable = (scala.collection.immutable.Iterable)compatiblePropertyPredicates.groupBy((Function1 & Serializable)x$1 -> x$1.variable()).map((Function1 & Serializable)propertyPredicates -> {
                LogicalVariable variable = (LogicalVariable)propertyPredicates._1();
                return new Tuple2(propertyPredicates, (Object)variable);
            }).flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 != null) {
                    Tuple2 propertyPredicates = (Tuple2)tuple2._1();
                    LogicalVariable variable = (LogicalVariable)tuple2._2();
                    return (Set)Option$.MODULE$.option2Iterable(patternRelationshipsMap.get((Object)variable)).toSet().flatMap((Function1 & Serializable)patternRelationship -> (Set)MODULE$.findIndexMatches(variable, (Set<EntityIndexLeafPlanner.IndexCompatiblePredicate>)((Set)propertyPredicates._2()), (PatternRelationship)patternRelationship, interestingOrderConfig, semanticTable, planContext, providedOrderFactory, findTextIndexes, findRangeIndexes, findPointIndexes).map((Function1 & Serializable)indexMatch -> indexMatch));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        scala.collection.immutable.Iterable indexMatches = iterable;
        return indexMatches.toSet();
    }

    private Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<LogicalVariable> argumentIds, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Iterable<PatternRelationship> patterns) {
        Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> generalCompatiblePredicates = this.findIndexCompatiblePredicates(predicates, argumentIds, semanticTable, planContext, indexPredicateProviderContext);
        return (Set)generalCompatiblePredicates.$plus$plus((IterableOnce)patterns.flatMap((Function1 & Serializable)x0$1 -> {
            PatternRelationship patternRelationship = x0$1;
            if (patternRelationship != null) {
                RelTypeName relTypeName;
                SeqOps seqOps;
                LogicalVariable variable = patternRelationship.variable();
                Seq seq = patternRelationship.types();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (relTypeName = (RelTypeName)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                    String relTypeName2 = relTypeName.name();
                    if (RelationshipIndexLeafPlanner$.valid$1(variable, argumentIds)) {
                        Set constrainedPropNames = indexPredicateProviderContext.outerPlanHasUpdates() || planContext.txStateHasChanges() ? Predef$.MODULE$.Set().empty() : planContext.getRelationshipPropertiesWithExistenceConstraint(relTypeName2);
                        return EntityIndexLeafPlanner$.MODULE$.implicitIsNotNullPredicates(variable, indexPredicateProviderContext.aggregatingProperties(), (Set<String>)constrainedPropNames, generalCompatiblePredicates);
                    }
                }
            }
            return Predef$.MODULE$.Set().empty();
        }));
    }

    private Set<RelationshipIndexLeafPlanner.RelationshipIndexMatch> findIndexMatches(LogicalVariable variable, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> propertyPredicates, PatternRelationship patternRelationship, InterestingOrderConfig interestingOrderConfig, SemanticTable semanticTable, PlanContext planContext, ProvidedOrderFactory providedOrderFactory, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        RelTypeName relTypeName = (RelTypeName)patternRelationship.types().head();
        Set indexMatches = (Set)Option$.MODULE$.option2Iterable(semanticTable.id(relTypeName)).toSet().flatMap((Function1 & Serializable)relTypeId -> MODULE$.indexDescriptorsForRelType((RelTypeId)relTypeId, planContext, findTextIndexes, findRangeIndexes, findPointIndexes).flatMap((Function1 & Serializable)indexDescriptor -> (Set)EntityIndexLeafPlanner$.MODULE$.predicatesForIndex((IndexDescriptor)indexDescriptor, propertyPredicates, interestingOrderConfig, semanticTable, (Map<String, Seq<SchemaValueType>>)planContext.getRelationshipPropertiesWithTypeConstraint(relTypeName.name()), providedOrderFactory).map((Function1 & Serializable)predicatesForIndex -> new RelationshipIndexLeafPlanner.RelationshipIndexMatch(variable, patternRelationship, relTypeName, (RelTypeId)relTypeId, predicatesForIndex.predicatesInOrder(), predicatesForIndex.providedOrder(), predicatesForIndex.indexOrder(), (IndexDescriptor)indexDescriptor))));
        return indexMatches;
    }

    public boolean findIndexMatchesForQueryGraph$default$7() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$8() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$9() {
        return true;
    }

    private Iterator<IndexDescriptor> indexDescriptorsForRelType(RelTypeId relTypeId, PlanContext planContext, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        return (findRangeIndexes ? planContext.rangeIndexesGetForRelType(NameId$.MODULE$.toKernelEncode((NameId)relTypeId)) : package$.MODULE$.Iterator().empty()).$plus$plus((Function0 & Serializable)() -> {
            if (findTextIndexes) {
                return planContext.textIndexesGetForRelType(NameId$.MODULE$.toKernelEncode((NameId)relTypeId));
            }
            return package$.MODULE$.Iterator().empty();
        }).$plus$plus((Function0 & Serializable)() -> {
            if (findPointIndexes) {
                return planContext.pointIndexesGetForRelType(NameId$.MODULE$.toKernelEncode((NameId)relTypeId));
            }
            return package$.MODULE$.Iterator().empty();
        });
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> implicitIndexCompatiblePredicates(PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Set<Expression> predicates, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> explicitCompatiblePredicates, Function2<LogicalVariable, Set<LogicalVariable>, Object> valid) {
        return Predef$.MODULE$.Set().empty();
    }

    public RelationshipIndexLeafPlanner apply(Seq<RelationshipIndexPlanProvider> planProviders, LeafPlanRestrictions restrictions) {
        return new RelationshipIndexLeafPlanner(planProviders, restrictions);
    }

    public Option<Tuple2<Seq<RelationshipIndexPlanProvider>, LeafPlanRestrictions>> unapply(RelationshipIndexLeafPlanner x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.planProviders(), (Object)x$0.restrictions()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RelationshipIndexLeafPlanner$.class);
    }

    public static final boolean org$neo4j$cypher$internal$compiler$planner$logical$steps$index$RelationshipIndexLeafPlanner$$shouldIgnore$1(PatternRelationship pattern, QueryGraph qg$2) {
        return qg$2.argumentIds().contains((Object)pattern.variable());
    }

    private static final boolean valid$1(LogicalVariable variable, Set argumentIds$1) {
        return !argumentIds$1.contains((Object)variable);
    }

    private RelationshipIndexLeafPlanner$() {
    }
}

