/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$SortColumnsWithProjections$2$;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.IsAggregate$;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.UnPositionedVariable$;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.frontend.phases.Namespacer$;
import org.neo4j.cypher.internal.ir.ordering.ColumnOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.Ascending;
import org.neo4j.cypher.internal.logical.plans.ColumnOrder;
import org.neo4j.cypher.internal.logical.plans.Descending;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.ordering.ProvidedOrder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class SortPlanner$ {
    public static final SortPlanner$ MODULE$ = new SortPlanner$();

    public Option<LogicalPlan> maybeSortedPlan(LogicalPlan plan, InterestingOrderConfig interestingOrderConfig, boolean isPushDownSort, LogicalPlanningContext context, boolean updateSolved) {
        if (interestingOrderConfig.orderToSolve().requiredOrderCandidate().nonEmpty()) {
            InterestingOrder.Satisfaction satisfaction = this.orderSatisfaction(interestingOrderConfig, context, plan);
            if (satisfaction != null && InterestingOrder.FullSatisfaction$.MODULE$.unapply(satisfaction)) {
                return new Some((Object)plan);
            }
            if (satisfaction != null && InterestingOrder.NoSatisfaction$.MODULE$.unapply(satisfaction)) {
                return this.planSort(plan, (Seq<org.neo4j.cypher.internal.ir.ordering.ColumnOrder>)((Seq)package$.MODULE$.Seq().empty()), interestingOrderConfig, isPushDownSort, context, updateSolved);
            }
            if (satisfaction != null) {
                Seq satisfiedPrefix = satisfaction.satisfiedPrefix();
                return this.planSort(plan, (Seq<org.neo4j.cypher.internal.ir.ordering.ColumnOrder>)satisfiedPrefix, interestingOrderConfig, isPushDownSort, context, updateSolved);
            }
            throw new MatchError((Object)satisfaction);
        }
        return None$.MODULE$;
    }

    public Option<LogicalPlan> planIfAsSortedAsPossible(LogicalPlan plan, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context) {
        LogicalPlan newPlan = (LogicalPlan)this.maybeSortedPlan(plan, interestingOrderConfig, true, context, true).getOrElse((Function0 & Serializable)() -> plan);
        SortPlanner.SatisfiedForPlan asSortedAsPossible = new SortPlanner.SatisfiedForPlan(plan);
        InterestingOrder.Satisfaction satisfaction = this.orderSatisfaction(interestingOrderConfig, context, newPlan);
        if (satisfaction != null && asSortedAsPossible.unapply(satisfaction)) {
            return new Some((Object)newPlan);
        }
        return None$.MODULE$;
    }

    public LogicalPlan ensureSortedPlanWithSolved(LogicalPlan plan, InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, boolean updateSolved) {
        Option<LogicalPlan> option = this.maybeSortedPlan(plan, interestingOrderConfig, false, context, updateSolved);
        if (option instanceof Some) {
            LogicalPlan sortedPlan;
            Some some = (Some)option;
            LogicalPlan logicalPlan = sortedPlan = (LogicalPlan)some.value();
            LogicalPlan logicalPlan2 = plan;
            if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
                return context.staticComponents().logicalPlanProducer().updateSolvedForSortedItems(sortedPlan, interestingOrderConfig.orderToReport(), context);
            }
            return sortedPlan;
        }
        if (interestingOrderConfig.orderToSolve().requiredOrderCandidate().nonEmpty()) {
            throw new AssertionError((Object)("Expected a sorted plan but got\n" + plan));
        }
        return plan;
    }

    public InterestingOrder.Satisfaction orderSatisfaction(InterestingOrderConfig interestingOrderConfig, LogicalPlanningContext context, LogicalPlan plan) {
        return ((ProvidedOrder)context.staticComponents().planningAttributes().providedOrders().get(plan.id())).satisfies(interestingOrderConfig.orderToSolve());
    }

    private Option<LogicalPlan> planSort(LogicalPlan plan, Seq<org.neo4j.cypher.internal.ir.ordering.ColumnOrder> satisfiedPrefix, InterestingOrderConfig interestingOrderConfig, boolean isPushDownSort, LogicalPlanningContext context, boolean updateSolved) {
        LazyRef SortColumnsWithProjections$module = new LazyRef();
        Seq sortItems = (Seq)interestingOrderConfig.orderToSolve().requiredOrderCandidate().order().map((Function1 & Serializable)x0$1 -> {
            public class Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1
            implements Product,
            Serializable {
                private final ColumnOrder columnOrder;
                private final org.neo4j.cypher.internal.ir.ordering.ColumnOrder providedOrderColumn;
                private final Option<Tuple2<LogicalVariable, Expression>> unaliasedProjections;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public ColumnOrder columnOrder() {
                    return this.columnOrder;
                }

                public org.neo4j.cypher.internal.ir.ordering.ColumnOrder providedOrderColumn() {
                    return this.providedOrderColumn;
                }

                public Option<Tuple2<LogicalVariable, Expression>> unaliasedProjections() {
                    return this.unaliasedProjections;
                }

                public Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1 copy(ColumnOrder columnOrder, org.neo4j.cypher.internal.ir.ordering.ColumnOrder providedOrderColumn, Option<Tuple2<LogicalVariable, Expression>> unaliasedProjections) {
                    return new Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1(columnOrder, providedOrderColumn, unaliasedProjections);
                }

                public ColumnOrder copy$default$1() {
                    return this.columnOrder();
                }

                public org.neo4j.cypher.internal.ir.ordering.ColumnOrder copy$default$2() {
                    return this.providedOrderColumn();
                }

                public Option<Tuple2<LogicalVariable, Expression>> copy$default$3() {
                    return this.unaliasedProjections();
                }

                public String productPrefix() {
                    return "SortColumnsWithProjections";
                }

                public int productArity() {
                    return 3;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.columnOrder();
                        }
                        case 1: {
                            return this.providedOrderColumn();
                        }
                        case 2: {
                            return this.unaliasedProjections();
                        }
                    }
                    return Statics.ioobe((int)x$1);
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1;
                }

                public String productElementName(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return "columnOrder";
                        }
                        case 1: {
                            return "providedOrderColumn";
                        }
                        case 2: {
                            return "unaliasedProjections";
                        }
                    }
                    return (String)Statics.ioobe((int)x$1);
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1 var4_3 = (Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1)x$1;
                    ColumnOrder columnOrder = this.columnOrder();
                    ColumnOrder columnOrder2 = var4_3.columnOrder();
                    if (columnOrder == null) {
                        if (columnOrder2 != null) {
                            return false;
                        }
                    } else if (!columnOrder.equals(columnOrder2)) return false;
                    org.neo4j.cypher.internal.ir.ordering.ColumnOrder columnOrder3 = this.providedOrderColumn();
                    org.neo4j.cypher.internal.ir.ordering.ColumnOrder columnOrder4 = var4_3.providedOrderColumn();
                    if (columnOrder3 == null) {
                        if (columnOrder4 != null) {
                            return false;
                        }
                    } else if (!columnOrder3.equals(columnOrder4)) return false;
                    Option<Tuple2<LogicalVariable, Expression>> option = this.unaliasedProjections();
                    Option<Tuple2<LogicalVariable, Expression>> option2 = var4_3.unaliasedProjections();
                    if (option == null) {
                        if (option2 != null) {
                            return false;
                        }
                    } else if (!option.equals(option2)) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public Org_neo4j_cypher_internal_compiler_planner_logical_SortPlanner$SortColumnsWithProjections$1(ColumnOrder columnOrder, org.neo4j.cypher.internal.ir.ordering.ColumnOrder providedOrderColumn, Option<Tuple2<LogicalVariable, Expression>> unaliasedProjections) {
                    this.columnOrder = columnOrder;
                    this.providedOrderColumn = providedOrderColumn;
                    this.unaliasedProjections = unaliasedProjections;
                    Product.$init$((Product)this);
                }
            }
            boolean bl = false;
            ColumnOrder.Asc asc = null;
            boolean bl2 = false;
            ColumnOrder.Desc desc = null;
            org.neo4j.cypher.internal.ir.ordering.ColumnOrder columnOrder = x0$1;
            if (columnOrder instanceof ColumnOrder.Asc) {
                bl = true;
                asc = (ColumnOrder.Asc)columnOrder;
                Expression v = asc.expression();
                if (v instanceof Variable) {
                    Variable variable = (Variable)v;
                    return this.SortColumnsWithProjections$3(SortColumnsWithProjections$module).apply((ColumnOrder)new Ascending((LogicalVariable)variable), (org.neo4j.cypher.internal.ir.ordering.ColumnOrder)asc, (Option<Tuple2<LogicalVariable, Expression>>)None$.MODULE$);
                }
            }
            if (columnOrder instanceof ColumnOrder.Desc) {
                bl2 = true;
                desc = (ColumnOrder.Desc)columnOrder;
                Expression v = desc.expression();
                if (v instanceof Variable) {
                    Variable variable = (Variable)v;
                    return this.SortColumnsWithProjections$3(SortColumnsWithProjections$module).apply((ColumnOrder)new Descending((LogicalVariable)variable), (org.neo4j.cypher.internal.ir.ordering.ColumnOrder)desc, (Option<Tuple2<LogicalVariable, Expression>>)None$.MODULE$);
                }
            }
            if (bl) {
                Expression expression = asc.expression();
                Map projections = asc.projections();
                LogicalVariable columnId = SortPlanner$.idFrom$1(expression, projections, context);
                return this.SortColumnsWithProjections$3(SortColumnsWithProjections$module).apply((ColumnOrder)new Ascending(columnId), (org.neo4j.cypher.internal.ir.ordering.ColumnOrder)asc, (Option<Tuple2<LogicalVariable, Expression>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnId), (Object)expression)));
            }
            if (bl2) {
                Expression expression = desc.expression();
                Map projections = desc.projections();
                LogicalVariable columnId = SortPlanner$.idFrom$1(expression, projections, context);
                return this.SortColumnsWithProjections$3(SortColumnsWithProjections$module).apply((ColumnOrder)new Descending(columnId), (org.neo4j.cypher.internal.ir.ordering.ColumnOrder)desc, (Option<Tuple2<LogicalVariable, Expression>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnId), (Object)expression)));
            }
            throw new MatchError((Object)columnOrder);
        });
        Map projections = (Map)sortItems.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(acc, i) -> (Map)acc.$plus$plus((IterableOnce)i.providedOrderColumn().projections()));
        LogicalPlan projected1 = SortPlanner$.projected$1(plan, projections, updateSolved, context);
        Map unaliasedProjections = (Map)sortItems.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(acc, i) -> (Map)acc.$plus$plus(i.unaliasedProjections()));
        LogicalPlan projected2 = SortPlanner$.projected$1(projected1, unaliasedProjections, false, context);
        Seq sortColumns = (Seq)sortItems.map((Function1 & Serializable)x$3 -> x$3.columnOrder());
        Seq providedOrderColumns = (Seq)sortItems.map((Function1 & Serializable)x$4 -> x$4.providedOrderColumn());
        boolean sortSymbolsAvailable = sortColumns.forall((Function1 & Serializable)column -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$11(projected2, column)));
        if (sortSymbolsAvailable && SortPlanner$.okToSortNow$1(isPushDownSort, providedOrderColumns)) {
            if (satisfiedPrefix.isEmpty() || !context.settings().executionModel().providedOrderPreserving()) {
                return new Some((Object)context.staticComponents().logicalPlanProducer().planSort(projected2, (Seq<ColumnOrder>)sortColumns, (Seq<org.neo4j.cypher.internal.ir.ordering.ColumnOrder>)providedOrderColumns, interestingOrderConfig.orderToReport(), context));
            }
            Tuple2 tuple2 = sortColumns.splitAt(satisfiedPrefix.length());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq prefixColumnOrders = (Seq)tuple2._1();
            Seq suffixColumnOrders = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)prefixColumnOrders, (Object)suffixColumnOrders);
            Seq prefixColumnOrders2 = (Seq)tuple22._1();
            Seq suffixColumnOrders2 = (Seq)tuple22._2();
            return new Some((Object)context.staticComponents().logicalPlanProducer().planPartialSort(projected2, (Seq<ColumnOrder>)prefixColumnOrders2, (Seq<ColumnOrder>)suffixColumnOrders2, (Seq<org.neo4j.cypher.internal.ir.ordering.ColumnOrder>)providedOrderColumns, interestingOrderConfig.orderToReport(), context));
        }
        return None$.MODULE$;
    }

    private static final LogicalVariable idFrom$1(Expression expression, Map projection2, LogicalPlanningContext context$1) {
        return (LogicalVariable)projection2.collectFirst((PartialFunction)new Serializable(expression){
            private static final long serialVersionUID = 0L;
            private final Expression expression$1;

            public final <A1 extends Tuple2<LogicalVariable, Expression>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e;
                    LogicalVariable key = (LogicalVariable)A1._1();
                    Expression expression = e = (Expression)A1._2();
                    Expression expression2 = this.expression$1;
                    if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
                        return (B1)key;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<LogicalVariable, Expression> x1) {
                Tuple2<LogicalVariable, Expression> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e;
                    Expression expression = e = (Expression)tuple2._2();
                    Expression expression2 = this.expression$1;
                    if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.expression$1 = expression$1;
            }
        }).getOrElse((Function0 & Serializable)() -> UnPositionedVariable$.MODULE$.varFor(Namespacer$.MODULE$.genName(context$1.staticComponents().anonymousVariableNameGenerator(), ExpressionStringifier$.MODULE$.pretty((Function1 & Serializable)x$1 -> context$1.staticComponents().anonymousVariableNameGenerator().nextName()).apply(expression))));
    }

    public static final /* synthetic */ boolean $anonfun$planSort$4(Tuple2 x$2) {
        Option option;
        Expression expression = (Expression)x$2._2();
        return expression == null || (option = IsAggregate$.MODULE$.unapply((Object)expression)).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$planSort$5(LogicalPlan plan$2, LogicalVariable e) {
        return plan$2.availableSymbols().contains((Object)e);
    }

    private static final LogicalPlan projected$1(LogicalPlan plan, Map projections, boolean updateSolved, LogicalPlanningContext context$1) {
        Iterable projectionDeps = (Iterable)projections.flatMap((Function1 & Serializable)e -> ((Expression)e._2()).dependencies());
        Map projectionsToPlan = (Map)projections.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$4(x$2)));
        if (projectionsToPlan.nonEmpty() && projectionDeps.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$5(plan, e)))) {
            None$ projectionsToMarkSolved = updateSolved ? new Some((Object)projectionsToPlan) : None$.MODULE$;
            return projection$.MODULE$.apply(plan, (Map<LogicalVariable, Expression>)projectionsToPlan, (Option<Map<LogicalVariable, Expression>>)projectionsToMarkSolved, context$1);
        }
        return plan;
    }

    private static final /* synthetic */ SortPlanner$SortColumnsWithProjections$2$ SortColumnsWithProjections$lzycompute$1(LazyRef SortColumnsWithProjections$module$1) {
        SortPlanner$SortColumnsWithProjections$2$ sortPlanner$SortColumnsWithProjections$2$;
        LazyRef lazyRef = SortColumnsWithProjections$module$1;
        synchronized (lazyRef) {
            sortPlanner$SortColumnsWithProjections$2$ = SortColumnsWithProjections$module$1.initialized() ? (SortPlanner$SortColumnsWithProjections$2$)SortColumnsWithProjections$module$1.value() : (SortPlanner$SortColumnsWithProjections$2$)SortColumnsWithProjections$module$1.initialize((Object)new SortPlanner$SortColumnsWithProjections$2$());
        }
        return sortPlanner$SortColumnsWithProjections$2$;
    }

    private final SortPlanner$SortColumnsWithProjections$2$ SortColumnsWithProjections$3(LazyRef SortColumnsWithProjections$module$1) {
        if (SortColumnsWithProjections$module$1.initialized()) {
            return (SortPlanner$SortColumnsWithProjections$2$)SortColumnsWithProjections$module$1.value();
        }
        return SortPlanner$.SortColumnsWithProjections$lzycompute$1(SortColumnsWithProjections$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$planSort$11(LogicalPlan projected2$1, ColumnOrder column) {
        return projected2$1.availableSymbols().contains((Object)column.id());
    }

    public static final /* synthetic */ boolean $anonfun$planSort$12(org.neo4j.cypher.internal.ir.ordering.ColumnOrder x$5) {
        return x$5.expression().isDeterministic();
    }

    private static final boolean deterministicSortExpressionsOnly$1(Seq providedOrderColumns$1) {
        return providedOrderColumns$1.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$12(x$5)));
    }

    private static final boolean okToSortNow$1(boolean isPushDownSort$1, Seq providedOrderColumns$1) {
        return !isPushDownSort$1 || SortPlanner$.deterministicSortExpressionsOnly$1(providedOrderColumns$1);
    }

    private SortPlanner$() {
    }
}

