/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.Create;
import org.neo4j.cypher.internal.ast.ProjectingUnion;
import org.neo4j.cypher.internal.ast.ProjectingUnionAll;
import org.neo4j.cypher.internal.ast.ProjectingUnionDistinct;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.QueryPart;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Start;
import org.neo4j.cypher.internal.ast.UnaliasedReturnItem;
import org.neo4j.cypher.internal.ast.UnionAll;
import org.neo4j.cypher.internal.ast.UnionDistinct;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder$;
import org.neo4j.cypher.internal.expressions.And;
import org.neo4j.cypher.internal.expressions.Or;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.expressions.PatternComprehension;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternExpression;
import org.neo4j.cypher.internal.ir.PeriodicCommit$;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.exceptions.InternalException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

public final class StatementConverters$ {
    public static StatementConverters$ MODULE$;
    private final Set<Class<? extends ASTNode>> org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST;

    static {
        new StatementConverters$();
    }

    private SinglePlannerQuery toPlannerQuery(SingleQuery q, SemanticTable semanticTable, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, boolean nonTerminating) {
        Set importedVariables = (Set)q.importWith().map((Function1 & Serializable & scala.Serializable)wth -> ((TraversableOnce)wth.returnItems().items().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        PlannerQueryBuilder builder = PlannerQueryBuilder$.MODULE$.apply(semanticTable, (Set<String>)importedVariables);
        return this.addClausesToPlannerQueryBuilder((Seq<Clause>)q.clauses(), builder, anonymousVariableNameGenerator, cancellationChecker, nonTerminating).build();
    }

    public PlannerQueryBuilder addClausesToPlannerQueryBuilder(Seq<Clause> clauses, PlannerQueryBuilder builder, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, boolean nonTerminating) {
        Seq<Clause> flattenedClauses = this.flattenCreates(clauses);
        Iterator slidingClauses = ((IterableLike)flattenedClauses.$colon$plus(null, Seq$.MODULE$.canBuildFrom())).sliding(2);
        return (PlannerQueryBuilder)slidingClauses.foldLeft((Object)builder, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder acc = (PlannerQueryBuilder)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Clause clause = (Clause)((SeqLike)some.get()).apply(0);
                    Clause nextClause = (Clause)((SeqLike)some.get()).apply(1);
                    if (nextClause != null) {
                        cancellationChecker.throwIfCancelled();
                        return ClauseConverters$.MODULE$.addToLogicalPlanInput(acc, clause, (Option<Clause>)new Some((Object)nextClause), anonymousVariableNameGenerator, cancellationChecker, nonTerminating);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            PlannerQueryBuilder acc = (PlannerQueryBuilder)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty()) throw new MatchError((Object)tuple2);
            if (some.get() == null) throw new MatchError((Object)tuple2);
            if (((SeqLike)some.get()).lengthCompare(1) < 0) throw new MatchError((Object)tuple2);
            Clause clause = (Clause)((SeqLike)some.get()).apply(0);
            cancellationChecker.throwIfCancelled();
            return ClauseConverters$.MODULE$.addToLogicalPlanInput(acc, clause, (Option<Clause>)None$.MODULE$, anonymousVariableNameGenerator, cancellationChecker, nonTerminating);
        });
    }

    public Set<Class<? extends ASTNode>> org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST() {
        return this.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST;
    }

    private Seq<ASTNode> findBlacklistedNodes(QueryPart queryPart) {
        return (Seq)queryPart.folder().treeFold((Object)Nil$.MODULE$, (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof ASTNode) {
                    ASTNode aSTNode = (ASTNode)A1;
                    if (StatementConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST().contains(aSTNode.getClass())) {
                        intersect = (Function1 & Serializable & scala.Serializable)acc -> new Foldable.TraverseChildren(acc.$colon$plus((Object)aSTNode, Seq$.MODULE$.canBuildFrom()));
                        return (B1)intersect;
                    }
                }
                intersect = function1.apply(x1);
                return (B1)intersect;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (!(object instanceof ASTNode)) return false;
                ASTNode aSTNode = (ASTNode)object;
                if (!StatementConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST().contains(aSTNode.getClass())) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.util.ASTNode scala.collection.Seq )}, serializedLambda);
            }
        });
    }

    public PlannerQuery toPlannerQuery(Query query, SemanticTable semanticTable, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, boolean nonTerminating) {
        PlannerQueryPart plannerQueryPart = this.toPlannerQueryPart(query.part(), semanticTable, anonymousVariableNameGenerator, cancellationChecker, this.toPlannerQueryPart$default$5());
        return new PlannerQuery(plannerQueryPart, PeriodicCommit$.MODULE$.apply(query.periodicCommitHint()));
    }

    public PlannerQueryPart toPlannerQueryPart(QueryPart queryPart, SemanticTable semanticTable, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, boolean nonTerminating) {
        SinglePlannerQuery singlePlannerQuery;
        Seq<ASTNode> nodes = this.findBlacklistedNodes(queryPart);
        Predef$.MODULE$.require(nodes.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Found a blacklisted AST node: ").append(nodes.head().toString()).toString());
        QueryPart queryPart2 = queryPart;
        if (queryPart2 instanceof SingleQuery) {
            SingleQuery singleQuery = (SingleQuery)queryPart2;
            singlePlannerQuery = this.toPlannerQuery(singleQuery, semanticTable, anonymousVariableNameGenerator, cancellationChecker, nonTerminating);
        } else if (queryPart2 instanceof ProjectingUnion) {
            boolean bl;
            ProjectingUnion projectingUnion = (ProjectingUnion)queryPart2;
            PlannerQueryPart part = this.toPlannerQueryPart(projectingUnion.part(), semanticTable, anonymousVariableNameGenerator, cancellationChecker, true);
            SinglePlannerQuery query = this.toPlannerQuery(projectingUnion.query(), semanticTable, anonymousVariableNameGenerator, cancellationChecker, true);
            ProjectingUnion projectingUnion2 = projectingUnion;
            if (projectingUnion2 instanceof ProjectingUnionAll) {
                bl = false;
            } else if (projectingUnion2 instanceof ProjectingUnionDistinct) {
                bl = true;
            } else {
                throw new MatchError((Object)projectingUnion2);
            }
            boolean distinct2 = bl;
            singlePlannerQuery = new UnionQuery(part, query, distinct2, projectingUnion.unionMappings());
        } else {
            throw new InternalException(new StringBuilder(58).append("Received an AST-clause that has no representation the QG: ").append(queryPart).toString());
        }
        return singlePlannerQuery;
    }

    public boolean toPlannerQueryPart$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Clause> flattenCreates(Seq<Clause> clauses) {
        void var2_2;
        ArrayBuffer builder = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ObjectRef prevCreate = ObjectRef.create((Object)None$.MODULE$);
        clauses.foreach((Function1 & Serializable & scala.Serializable)clause -> {
            Tuple2 tuple2 = new Tuple2(clause, (Object)((Option)prevCreate$1.elem));
            if (tuple2 != null) {
                Clause c = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (c instanceof Create) {
                    Create create = (Create)c;
                    if (None$.MODULE$.equals(option) && MODULE$.containsPatternExpression(create)) {
                        builder.$plus$eq((Object)create);
                        prevCreate$1.elem = None$.MODULE$;
                        return BoxedUnit.UNIT;
                    }
                }
            }
            if (tuple2 != null) {
                Clause c = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (c instanceof Create) {
                    Create create = (Create)c;
                    if (None$.MODULE$.equals(option)) {
                        prevCreate$1.elem = new Some((Object)new Tuple2((Object)create.pattern().patternParts(), (Object)create.position()));
                        return BoxedUnit.UNIT;
                    }
                }
            }
            if (tuple2 != null) {
                Clause c = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (c instanceof Create) {
                    Some some;
                    Tuple2 tuple22;
                    Create create = (Create)c;
                    if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).value()) != null) {
                        Seq prevParts = (Seq)tuple22._1();
                        InputPosition pos = (InputPosition)tuple22._2();
                        if (!MODULE$.containsPatternExpression(create)) {
                            prevCreate$1.elem = new Some((Object)new Tuple2(prevParts.$plus$plus((GenTraversableOnce)create.pattern().patternParts(), Seq$.MODULE$.canBuildFrom()), (Object)pos));
                            return BoxedUnit.UNIT;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple23;
                Clause nonMixingClause = (Clause)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some && (tuple23 = (Tuple2)(some = (Some)option).value()) != null) {
                    Seq prevParts = (Seq)tuple23._1();
                    InputPosition pos = (InputPosition)tuple23._2();
                    builder.$plus$eq((Object)new Create(new Pattern(prevParts, pos), pos));
                    builder.$plus$eq((Object)nonMixingClause);
                    prevCreate$1.elem = None$.MODULE$;
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Clause nonCreate = (Clause)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            return builder.$plus$eq((Object)nonCreate);
        });
        ((Option)prevCreate.elem).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StatementConverters$.$anonfun$flattenCreates$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq prevParts = (Seq)tuple2._1();
            InputPosition pos = (InputPosition)tuple2._2();
            ArrayBuffer arrayBuffer = builder.$plus$eq((Object)new Create(new Pattern(prevParts, pos), pos));
            return arrayBuffer;
        });
        return var2_2;
    }

    private boolean containsPatternExpression(Create c) {
        return c.pattern().patternParts().exists((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)StatementConverters$.MODULE$.containsPatternExpression(part.element())));
    }

    private boolean containsPatternExpression(PatternElement element) {
        return element.folder().treeExists((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                boolean bl = A1 instanceof PatternComprehension ? true : A1 instanceof PatternExpression;
                Object object = bl ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof PatternComprehension ? true : object instanceof PatternExpression;
                boolean bl2 = bl;
                return bl2;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$flattenCreates$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private StatementConverters$() {
        MODULE$ = this;
        this.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$StatementConverters$$NODE_BLACKLIST = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{And.class, Or.class, UnaliasedReturnItem.class, Start.class, UnionAll.class, UnionDistinct.class}));
    }
}

