/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ExecutionModel;
import org.neo4j.cypher.internal.compiler.helpers.PropertyAccessHelper;
import org.neo4j.cypher.internal.compiler.phases.AttributeFullyAssigned;
import org.neo4j.cypher.internal.compiler.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanUpdater;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext$;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerConfiguration;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerConfiguration$;
import org.neo4j.cypher.internal.compiler.planner.logical.UnnecessaryOptionalMatchesRemoved$;
import org.neo4j.cypher.internal.compiler.planner.logical.VarLengthQuantifierMerged$;
import org.neo4j.cypher.internal.compiler.planner.logical.plannerQueryPartPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.CostComparisonListener;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.LogicalPlanProducer;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.SystemOutCostLogger$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.VerifyBestPlan$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.devNullListener$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.frontend.PlannerName;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.TokensResolved$;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.ir.PeriodicCommit;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.options.CypherDebugOptions;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.cypher.internal.util.attribution.IdGen;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class QueryPlanner$
implements Phase<PlannerContext, LogicalPlanState, LogicalPlanState>,
StepSequencer.Step,
PlanPipelineTransformerFactory,
Product,
scala.Serializable {
    public static QueryPlanner$ MODULE$;

    static {
        new QueryPlanner$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends PlannerContext, TO2> Transformer<D, LogicalPlanState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public LogicalPlanState process(LogicalPlanState from, PlannerContext context) {
        LogicalPlanningContext logicalPlanningContext = this.getLogicalPlanningContext(from, context);
        List produceResultColumns = (List)from.statement().returnColumns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom());
        LogicalPlan logicalPlan = this.plan(from.query(), logicalPlanningContext, (Seq<String>)produceResultColumns);
        Some x$12 = new Some((Object)from.query().periodicCommit());
        Some x$2 = new Some((Object)logicalPlan);
        Some x$3 = new Some((Object)logicalPlanningContext.semanticTable());
        String x$4 = from.copy$default$1();
        Option<InputPosition> x$5 = from.copy$default$2();
        PlannerName x$6 = from.copy$default$3();
        PlanningAttributes x$7 = from.copy$default$4();
        AnonymousVariableNameGenerator x$8 = from.copy$default$5();
        Option<Statement> x$9 = from.copy$default$6();
        Option<SemanticState> x$10 = from.copy$default$7();
        Option<Map<String, Object>> x$11 = from.copy$default$8();
        Option<PlannerQuery> x$122 = from.copy$default$10();
        Set<StepSequencer.Condition> x$13 = from.copy$default$13();
        boolean x$14 = from.copy$default$14();
        Option<Seq<String>> x$15 = from.copy$default$15();
        Option<ObfuscationMetadata> x$16 = from.copy$default$16();
        return from.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<SemanticTable>)x$3, x$122, (Option<LogicalPlan>)x$2, (Option<Option<PeriodicCommit>>)x$12, x$13, x$14, x$15, x$16);
    }

    public LogicalPlanningContext getLogicalPlanningContext(LogicalPlanState from, PlannerContext context) {
        boolean printCostComparisons = context.debugOptions().printCostComparisonsEnabled() || Boolean.getBoolean("pickBestPlan.VERBOSE");
        CostComparisonListener costComparisonListener = printCostComparisons ? SystemOutCostLogger$.MODULE$ : devNullListener$.MODULE$;
        PlanningAttributes planningAttributes = from.planningAttributes();
        LogicalPlanProducer logicalPlanProducer = new LogicalPlanProducer(context.metrics().cardinality(), planningAttributes, context.logicalPlanIdGen());
        PlanContext x$1 = context.planContext();
        LogicalPlanProducer x$2 = logicalPlanProducer;
        Metrics x$3 = this.getMetricsFrom(context);
        SemanticTable x$4 = from.semanticTable();
        QueryGraphSolver x$5 = context.queryGraphSolver();
        InternalNotificationLogger x$6 = context.notificationLogger();
        boolean x$7 = context.config().useErrorsOverWarnings();
        boolean x$8 = context.config().errorIfShortestPathFallbackUsedAtRuntime();
        boolean x$9 = context.config().errorIfShortestPathHasCommonNodesAtRuntime();
        QueryPlannerConfiguration x$10 = QueryPlannerConfiguration$.MODULE$.default().withUpdateStrategy(context.updateStrategy());
        boolean x$11 = context.config().legacyCsvQuoteEscaping();
        int x$12 = context.config().csvBufferSize();
        CostComparisonListener x$13 = costComparisonListener;
        PlanningAttributes x$14 = planningAttributes;
        IdGen x$15 = context.logicalPlanIdGen();
        ExecutionModel x$16 = context.executionModel();
        CypherDebugOptions x$17 = context.debugOptions();
        AnonymousVariableNameGenerator x$18 = from.anonymousVariableNameGenerator();
        CancellationChecker x$19 = context.cancellationChecker();
        boolean x$20 = context.config().planningTextIndexesEnabled();
        int x$21 = context.config().predicatesAsUnionMaxSize();
        Metrics.QueryGraphSolverInput x$22 = LogicalPlanningContext$.MODULE$.apply$default$7();
        Option<LogicalPlan> x$23 = LogicalPlanningContext$.MODULE$.apply$default$8();
        boolean x$24 = LogicalPlanningContext$.MODULE$.apply$default$9();
        LeafPlanUpdater x$25 = LogicalPlanningContext$.MODULE$.apply$default$17();
        IndexCompatiblePredicatesProviderContext x$26 = LogicalPlanningContext$.MODULE$.apply$default$20();
        Set<PropertyAccessHelper.PropertyAccess> x$27 = LogicalPlanningContext$.MODULE$.apply$default$21();
        return new LogicalPlanningContext(x$1, x$2, x$3, x$4, x$5, x$21, x$22, x$23, x$24, x$6, x$7, x$8, x$9, x$11, x$12, x$10, x$25, x$13, x$14, x$26, x$27, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private Metrics getMetricsFrom(PlannerContext context) {
        return context.debugOptions().inverseCostEnabled() ? context.metrics().copy((v1, v2, v3, v4, v5, monitor) -> context.metrics().cost().costFor(v1, v2, v3, v4, v5, monitor).unary_$minus(), context.metrics().copy$default$2()) : context.metrics();
    }

    public LogicalPlan plan(PlannerQuery query, LogicalPlanningContext context, Seq<String> produceResultColumns) {
        None$ none$;
        LogicalPlan plan = plannerQueryPartPlanner$.MODULE$.plan(query.query(), context, plannerQueryPartPlanner$.MODULE$.plan$default$3());
        PlannerQueryPart plannerQueryPart = query.query();
        if (plannerQueryPart instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQueryPart;
            none$ = new Some((Object)singlePlannerQuery.last().interestingOrder());
        } else {
            none$ = None$.MODULE$;
        }
        None$ lastInterestingOrder = none$;
        LogicalPlan planWithProduceResults = context.logicalPlanProducer().planProduceResult(plan, produceResultColumns, (Option<InterestingOrder>)lastInterestingOrder);
        VerifyBestPlan$.MODULE$.apply(planWithProduceResults, query.query(), context);
        return planWithProduceResults;
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(UnionQuery.class)), UnnecessaryOptionalMatchesRemoved$.MODULE$, TokensResolved$.MODULE$, VarLengthQuantifierMerged$.MODULE$}));
    }

    public Set<StepSequencer.Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(LogicalPlan.class)), new AttributeFullyAssigned(ClassTag$.MODULE$.apply(PlanningAttributes.Solveds.class)), new AttributeFullyAssigned(ClassTag$.MODULE$.apply(PlanningAttributes.Cardinalities.class)), new AttributeFullyAssigned(ClassTag$.MODULE$.apply(PlanningAttributes.ProvidedOrders.class))}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public Transformer<PlannerContext, LogicalPlanState, LogicalPlanState> getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    public String productPrefix() {
        return "QueryPlanner";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof QueryPlanner$;
    }

    public int hashCode() {
        return 1113900042;
    }

    public String toString() {
        return "QueryPlanner";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private QueryPlanner$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        Product.$init$((Product)this);
    }
}

