/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler;

import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceExponentialDecayCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceInverseDecayCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceNoDecayCalculator;
import org.neo4j.cypher.internal.config.StatsDivergenceCalculatorConfig;
import scala.MatchError;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public final class StatsDivergenceCalculator$ {
    public static StatsDivergenceCalculator$ MODULE$;
    private final String inverse;
    private final String exponential;
    private final String none;
    private final double similarityTolerance;

    static {
        new StatsDivergenceCalculator$();
    }

    public String inverse() {
        return this.inverse;
    }

    public String exponential() {
        return this.exponential;
    }

    public String none() {
        return this.none;
    }

    public double similarityTolerance() {
        return this.similarityTolerance;
    }

    public StatsDivergenceCalculator divergenceCalculatorFor(StatsDivergenceCalculatorConfig config) {
        StatsDivergenceCalculatorConfig statsDivergenceCalculatorConfig = config;
        if (statsDivergenceCalculatorConfig == null) {
            throw new MatchError((Object)statsDivergenceCalculatorConfig);
        }
        String name = statsDivergenceCalculatorConfig.name();
        double initialThreshold = statsDivergenceCalculatorConfig.initialThreshold();
        double targetThreshold = statsDivergenceCalculatorConfig.targetThreshold();
        long initialMillis = statsDivergenceCalculatorConfig.initialMillis();
        long targetMillis = statsDivergenceCalculatorConfig.targetMillis();
        Tuple5 tuple5 = new Tuple5((Object)name, (Object)BoxesRunTime.boxToDouble((double)initialThreshold), (Object)BoxesRunTime.boxToDouble((double)targetThreshold), (Object)BoxesRunTime.boxToLong((long)initialMillis), (Object)BoxesRunTime.boxToLong((long)targetMillis));
        Tuple5 tuple52 = tuple5;
        String name2 = (String)tuple52._1();
        double initialThreshold2 = BoxesRunTime.unboxToDouble((Object)tuple52._2());
        double targetThreshold2 = BoxesRunTime.unboxToDouble((Object)tuple52._3());
        long initialMillis2 = BoxesRunTime.unboxToLong((Object)tuple52._4());
        long targetMillis2 = BoxesRunTime.unboxToLong((Object)tuple52._5());
        return this.divergenceCalculatorFor(name2, initialThreshold2, targetThreshold2, initialMillis2, targetMillis2);
    }

    public StatsDivergenceCalculator divergenceCalculatorFor(String name, double initialThreshold, double targetThreshold, long initialMillis, long targetMillis) {
        StatsDivergenceNoDecayCalculator statsDivergenceNoDecayCalculator;
        if (targetThreshold <= this.similarityTolerance() || initialThreshold - targetThreshold <= this.similarityTolerance() || targetMillis <= initialMillis) {
            statsDivergenceNoDecayCalculator = new StatsDivergenceNoDecayCalculator(initialThreshold, initialMillis);
        } else {
            String string = name.toLowerCase();
            StatsDivergenceCalculator statsDivergenceCalculator = "none".equals(string) ? new StatsDivergenceNoDecayCalculator(initialThreshold, initialMillis) : ("exponential".equals(string) ? new StatsDivergenceExponentialDecayCalculator(initialThreshold, targetThreshold, initialMillis, targetMillis) : new StatsDivergenceInverseDecayCalculator(initialThreshold, targetThreshold, initialMillis, targetMillis));
            statsDivergenceNoDecayCalculator = statsDivergenceCalculator;
        }
        return statsDivergenceNoDecayCalculator;
    }

    public StatsDivergenceNoDecayCalculator divergenceNoDecayCalculator(double threshold, long ttl) {
        return new StatsDivergenceNoDecayCalculator(threshold, ttl);
    }

    private StatsDivergenceCalculator$() {
        MODULE$ = this;
        this.inverse = "inverse";
        this.exponential = "exponential";
        this.none = "none";
        this.similarityTolerance = 1.0E-4;
    }
}

