/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.CostComparisonListener;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanToPlanBuilderString$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cost;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SystemOutCostLogger$
implements CostComparisonListener {
    public static SystemOutCostLogger$ MODULE$;
    private final AtomicLong comparisonId;
    private final String prefix;

    static {
        new SystemOutCostLogger$();
    }

    private AtomicLong comparisonId() {
        return this.comparisonId;
    }

    private String prefix() {
        return this.prefix;
    }

    private String blue(String str) {
        return new StringBuilder(9).append("\u001b[34m").append(str).append("\u001b[0m").toString();
    }

    private String green(String str) {
        return new StringBuilder(9).append("\u001b[32m").append(str).append("\u001b[0m").toString();
    }

    private String magenta(String str) {
        return new StringBuilder(9).append("\u001b[35m").append(str).append("\u001b[0m").toString();
    }

    private String magenta_bold(String str) {
        return new StringBuilder(17).append("\u001b[35m\u001b[1m\u001b[4m").append(str).append("\u001b[0m").toString();
    }

    private String indent(int level, String str) {
        String ind = new StringOps(Predef$.MODULE$.augmentString(this.prefix())).$times(level);
        return new StringBuilder(0).append(ind).append(str.replaceAll(System.lineSeparator(), new StringBuilder(0).append(System.lineSeparator()).append(ind).toString())).toString();
    }

    @Override
    public <X> void report(Function1<X, LogicalPlan> projector, Iterable<X> input, Ordering<X> inputOrdering, LogicalPlanningContext context) {
        block0: {
            IndexedSeq plansInOrder = (IndexedSeq)((TraversableLike)input.toIndexedSeq().sorted(inputOrdering)).map(projector, IndexedSeq$.MODULE$.canBuildFrom());
            if (plansInOrder.size() <= 1) break block0;
            long id = this.comparisonId().getAndIncrement();
            Predef$.MODULE$.println((Object)new StringBuilder(14).append(id).append(": Get best of:").toString());
            ((TraversableLike)plansInOrder.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SystemOutCostLogger$.$anonfun$report$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                SystemOutCostLogger$.$anonfun$report$2(this, context, x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private final String costString$1(LogicalPlan plan, LogicalPlanningContext context$1) {
        double cost = ((Cost)context$1.cost().apply((Object)plan, (Object)context$1.input(), (Object)context$1.planningAttributes().cardinalities())).gummyBears();
        double cardinality = ((Cardinality)context$1.planningAttributes().cardinalities().get(plan.id())).amount();
        return new StringBuilder(0).append(this.magenta(" // cost ")).append(this.magenta_bold(((Object)BoxesRunTime.boxToDouble((double)cost)).toString())).append(this.magenta(" cardinality ")).append(this.magenta_bold(((Object)BoxesRunTime.boxToDouble((double)cardinality)).toString())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$report$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$report$2(SystemOutCostLogger$ $this, LogicalPlanningContext context$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan plan2 = (LogicalPlan)tuple2._1();
        int index = tuple2._2$mcI$sp();
        String winner = index == 0 ? MODULE$.green(" [winner]") : "";
        String header = new StringBuilder(0).append(MODULE$.blue(new StringBuilder(8).append(index).append(": Plan #").append(plan2.debugId()).toString())).append(winner).toString();
        String planWithCosts = LogicalPlanToPlanBuilderString$.MODULE$.apply(plan2, (Function1 & Serializable & scala.Serializable)plan -> $this.costString$1((LogicalPlan)plan, context$1));
        String hints = new StringBuilder(9).append("(hints: ").append(((PlannerQueryPart)context$1.planningAttributes().solveds().get(plan2.id())).numHints()).append(")").toString();
        Predef$.MODULE$.println((Object)MODULE$.indent(1, header));
        Predef$.MODULE$.println((Object)MODULE$.indent(2, planWithCosts));
        Predef$.MODULE$.println((Object)MODULE$.indent(2, hints));
        Predef$.MODULE$.println();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SystemOutCostLogger$() {
        MODULE$ = this;
        this.comparisonId = new AtomicLong();
        this.prefix = "\t";
    }
}

