/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import java.util.List;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.neo4j.Neo4jASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.neo4j.Neo4jASTFactory;
import org.neo4j.cypher.internal.frontend.phases.BaseContains;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.Parsing$;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.parser.javacc.CharStream;
import org.neo4j.cypher.internal.parser.javacc.Cypher;
import org.neo4j.cypher.internal.parser.javacc.CypherCharStream;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.exceptions.SyntaxException;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class JavaccParsing$
implements Phase<BaseContext, BaseState, BaseState>,
Product,
scala.Serializable {
    public static JavaccParsing$ MODULE$;
    private final Seq<String> FALLBACK_TRIGGERS;
    private final CompilationPhaseTracer.CompilationPhase phase;
    private final String description;

    static {
        new JavaccParsing$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    private Seq<String> FALLBACK_TRIGGERS() {
        return this.FALLBACK_TRIGGERS;
    }

    private boolean shouldFallBack(String errorMsg) {
        String upper = errorMsg.toUpperCase();
        return this.FALLBACK_TRIGGERS().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)upper.contains(x$1)));
    }

    public BaseState process(BaseState in, BaseContext context) {
        BaseState baseState;
        CypherCharStream charStream = new CypherCharStream(in.queryText());
        Neo4jASTFactory astFactory = new Neo4jASTFactory(in.queryText());
        Neo4jASTExceptionFactory astExceptionFactory = new Neo4jASTExceptionFactory(context.cypherExceptionFactory());
        try {
            List statements = new Cypher((ASTFactory)astFactory, (ASTExceptionFactory)astExceptionFactory, (CharStream)charStream).Statements();
            if (statements.size() != 1) {
                throw context.cypherExceptionFactory().syntaxException(new StringBuilder(50).append("Expected exactly one statement per query but got: ").append(statements.size()).toString(), InputPosition$.MODULE$.NONE());
            }
            baseState = in.withStatement((Statement)statements.get(0));
        }
        catch (Throwable throwable) {
            SyntaxException syntaxException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof SyntaxException) || !this.shouldFallBack((syntaxException = (SyntaxException)throwable2).getMessage())) {
                throw throwable;
            }
            BaseState baseState2 = Parsing$.MODULE$.process(in, context);
            baseState = baseState2;
        }
        return baseState;
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return this.phase;
    }

    public String description() {
        return this.description;
    }

    public Set<Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{new BaseContains(ClassTag$.MODULE$.apply(Statement.class), ManifestFactory$.MODULE$.classType(Statement.class))}));
    }

    public String productPrefix() {
        return "JavaccParsing";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JavaccParsing$;
    }

    public int hashCode() {
        return -1007812050;
    }

    public String toString() {
        return "JavaccParsing";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JavaccParsing$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        Product.$init$((Product)this);
        this.FALLBACK_TRIGGERS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INDEX", "CONSTRAINT", "DROP", "DATABASE", "ROLE", "SHOW", "GRANT", "DENY", "ALTER", "USER", "REVOKE", "CONSTRUCT", "CATALOG", "~"}));
        this.phase = CompilationPhaseTracer.CompilationPhase.PARSING;
        this.description = "parse text into an AST object";
    }
}

