/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import java.util.List;
import org.neo4j.cypher.internal.ast.Hint;
import org.neo4j.cypher.internal.ast.UsingIndexHint;
import org.neo4j.cypher.internal.ast.UsingJoinHint;
import org.neo4j.cypher.internal.compiler.IndexHintUnfulfillableNotification;
import org.neo4j.cypher.internal.compiler.JoinHintUnfulfillableNotification;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.HintException;
import org.neo4j.exceptions.IndexHintException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.JoinHintException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class verifyBestPlan$ {
    public static verifyBestPlan$ MODULE$;

    static {
        new verifyBestPlan$();
    }

    public void apply(LogicalPlan plan, PlannerQueryPart expected, LogicalPlanningContext context) {
        block4: {
            PlannerQueryPart expectedWithoutHints;
            PlannerQueryPart constructed = (PlannerQueryPart)context.planningAttributes().solveds().get(plan.id());
            PlannerQueryPart plannerQueryPart = expected;
            PlannerQueryPart plannerQueryPart2 = constructed;
            if (!(plannerQueryPart == null ? plannerQueryPart2 != null : !plannerQueryPart.equals(plannerQueryPart2))) break block4;
            Set<UsingIndexHint> unfulfillableIndexHints = this.findUnfulfillableIndexHints(expected, context.planContext());
            Set<UsingJoinHint> unfulfillableJoinHints = this.findUnfulfillableJoinHints(expected, context.planContext());
            PlannerQueryPart plannerQueryPart3 = expectedWithoutHints = expected.withoutHints((Set)unfulfillableIndexHints.$plus$plus(unfulfillableJoinHints, Set$.MODULE$.canBuildFrom()));
            PlannerQueryPart plannerQueryPart4 = constructed;
            if (plannerQueryPart3 == null ? plannerQueryPart4 != null : !plannerQueryPart3.equals(plannerQueryPart4)) {
                PlannerQueryPart a = expected.withoutHints(expected.allHints());
                PlannerQueryPart b = constructed.withoutHints(constructed.allHints());
                PlannerQueryPart plannerQueryPart5 = a;
                PlannerQueryPart plannerQueryPart6 = b;
                if (plannerQueryPart5 == null ? plannerQueryPart6 != null : !plannerQueryPart5.equals(plannerQueryPart6)) {
                    throw new InternalException(new StringBuilder(36).append("Expected \n").append(expected).append(" \n\n\nInstead, got: \n").append(constructed).append("\nPlan: ").append(plan).toString());
                }
                Set expectedHints = expected.allHints();
                Set actualHints = constructed.allHints();
                Set missing = (Set)expectedHints.diff((GenSet)actualHints);
                Set solvedInAddition = (Set)actualHints.diff((GenSet)expectedHints);
                boolean inventedHintsAndThenSolvedThem = solvedInAddition.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)verifyBestPlan$.$anonfun$apply$1(expectedHints, x$1)));
                if (missing.nonEmpty() || inventedHintsAndThenSolvedThem) {
                    String details = missing.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Expected:\n                 |").append(verifyBestPlan$.out$1(expectedHints)).append("\n                 |\n                 |Instead, got:\n                 |").append(verifyBestPlan$.out$1(actualHints)).toString())).stripMargin() : new StringBuilder(29).append("Could not solve these hints: ").append(verifyBestPlan$.out$1(missing)).toString();
                    String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Failed to fulfil the hints of the query.\n                 |").append(details).append("\n                 |\n                 |Plan ").append(plan).toString())).stripMargin();
                    throw new HintException(message);
                }
            } else {
                this.processUnfulfilledIndexHints(context, unfulfillableIndexHints);
                this.processUnfulfilledJoinHints(plan, context, unfulfillableJoinHints);
            }
        }
    }

    private void processUnfulfilledIndexHints(LogicalPlanningContext context, Set<UsingIndexHint> hints) {
        block1: {
            if (!hints.nonEmpty()) break block1;
            if (context.useErrorsOverWarnings()) {
                UsingIndexHint firstIndexHint = (UsingIndexHint)hints.head();
                throw new IndexHintException(firstIndexHint.label().name(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)firstIndexHint.properties().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).asJava(), "No such index");
            }
            hints.foreach((Function1 & Serializable & scala.Serializable)hint -> {
                verifyBestPlan$.$anonfun$processUnfulfilledIndexHints$2(context, hint);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void processUnfulfilledJoinHints(LogicalPlan plan, LogicalPlanningContext context, Set<UsingJoinHint> hints) {
        block1: {
            if (!hints.nonEmpty()) break block1;
            if (context.useErrorsOverWarnings()) {
                throw new JoinHintException(new StringBuilder(47).append("Unable to plan hash join. Instead, constructed\n").append(plan).toString());
            }
            hints.foreach((Function1 & Serializable & scala.Serializable)hint -> {
                verifyBestPlan$.$anonfun$processUnfulfilledJoinHints$1(context, hint);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Set<UsingIndexHint> findUnfulfillableIndexHints(PlannerQueryPart query, PlanContext planContext) {
        return (Set)query.allHints().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            UsingIndexHint usingIndexHint = null;
            Hint hint = x0$1;
            if (hint instanceof UsingIndexHint) {
                String label;
                bl = true;
                usingIndexHint = (UsingIndexHint)hint;
                LabelName labelName = usingIndexHint.label();
                Seq properties = usingIndexHint.properties();
                if (labelName != null && planContext.indexExistsForLabelAndProperties(label = labelName.name(), (Seq)properties.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom()))) {
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            if (!bl) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)usingIndexHint));
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<UsingJoinHint> findUnfulfillableJoinHints(PlannerQueryPart query, PlanContext planContext) {
        return (Set)query.allHints().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Hint, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                UsingJoinHint usingJoinHint;
                A1 A1 = x1;
                Object object = A1 instanceof UsingJoinHint ? (usingJoinHint = (UsingJoinHint)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Hint x1) {
                Hint hint = x1;
                boolean bl = hint instanceof UsingJoinHint;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(Set expectedHints$1, Hint x$1) {
        return !expectedHints$1.contains((Object)x$1);
    }

    private static final String out$1(Set h) {
        return h.mkString("`", ", ", "`");
    }

    public static final /* synthetic */ void $anonfun$processUnfulfilledIndexHints$2(LogicalPlanningContext context$1, UsingIndexHint hint) {
        context$1.notificationLogger().log((InternalNotification)new IndexHintUnfulfillableNotification(hint.label().name(), (Seq<String>)((Seq)hint.properties().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom()))));
    }

    public static final /* synthetic */ void $anonfun$processUnfulfilledJoinHints$1(LogicalPlanningContext context$2, UsingJoinHint hint) {
        context$2.notificationLogger().log((InternalNotification)new JoinHintUnfulfillableNotification((Seq<String>)hint.variables().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name()).toIndexedSeq()));
    }

    private verifyBestPlan$() {
        MODULE$ = this;
    }
}

