/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SortColumnsWithProjections;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.ir.InterestingOrder;
import org.neo4j.cypher.internal.ir.ProvidedOrder;
import org.neo4j.cypher.internal.logical.plans.Ascending;
import org.neo4j.cypher.internal.logical.plans.ColumnOrder;
import org.neo4j.cypher.internal.logical.plans.Descending;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v4_0.expressions.Expression;
import org.neo4j.cypher.internal.v4_0.expressions.LogicalVariable;
import org.neo4j.cypher.internal.v4_0.expressions.Variable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class SortPlanner$ {
    public static SortPlanner$ MODULE$;

    static {
        new SortPlanner$();
    }

    public Option<LogicalPlan> maybeSortedPlan(LogicalPlan plan, InterestingOrder interestingOrder, LogicalPlanningContext context) {
        None$ none$;
        if (interestingOrder.requiredOrderCandidate().nonEmpty()) {
            Option<LogicalPlan> option;
            InterestingOrder.Satisfaction satisfaction = this.orderSatisfaction(interestingOrder, context, plan);
            if (InterestingOrder.FullSatisfaction$.MODULE$.unapply(satisfaction)) {
                option = None$.MODULE$;
            } else if (InterestingOrder.NoSatisfaction$.MODULE$.unapply(satisfaction)) {
                option = this.planSort(plan, (Seq<InterestingOrder.ColumnOrder>)((Seq)Seq$.MODULE$.empty()), interestingOrder, context);
            } else if (satisfaction != null) {
                Seq satisfiedPrefix = satisfaction.satisfiedPrefix();
                option = this.planSort(plan, (Seq<InterestingOrder.ColumnOrder>)satisfiedPrefix, interestingOrder, context);
            } else {
                throw new MatchError((Object)satisfaction);
            }
            none$ = option;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public LogicalPlan ensureSortedPlanWithSolved(LogicalPlan plan, InterestingOrder interestingOrder, LogicalPlanningContext context) {
        LogicalPlan logicalPlan;
        Option<LogicalPlan> option = this.maybeSortedPlan(plan, interestingOrder, context);
        if (option instanceof Some) {
            LogicalPlan sortedPlan;
            Some some = (Some)option;
            logicalPlan = sortedPlan = (LogicalPlan)some.value();
        } else if (interestingOrder.requiredOrderCandidate().nonEmpty()) {
            InterestingOrder.Satisfaction satisfaction = this.orderSatisfaction(interestingOrder, context, plan);
            if (!InterestingOrder.FullSatisfaction$.MODULE$.unapply(satisfaction)) {
                throw new AssertionError((Object)"Expected a sorted plan");
            }
            LogicalPlan logicalPlan2 = context.logicalPlanProducer().updateSolvedForSortedItems(plan, interestingOrder, context);
            logicalPlan = logicalPlan2;
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    public InterestingOrder.Satisfaction orderSatisfaction(InterestingOrder interestingOrder, LogicalPlanningContext context, LogicalPlan plan) {
        return interestingOrder.satisfiedBy((ProvidedOrder)context.planningAttributes().providedOrders().get(plan.id()));
    }

    private Option<LogicalPlan> planSort(LogicalPlan plan, Seq<InterestingOrder.ColumnOrder> satisfiedPrefix, InterestingOrder interestingOrder, LogicalPlanningContext context) {
        None$ none$;
        Seq sortItems = (Seq)interestingOrder.requiredOrderCandidate().order().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            InterestingOrder.Asc asc = null;
            boolean bl2 = false;
            InterestingOrder.Desc desc = null;
            InterestingOrder.ColumnOrder columnOrder = x0$1;
            if (columnOrder instanceof InterestingOrder.Asc) {
                bl = true;
                asc = (InterestingOrder.Asc)columnOrder;
                Expression v = asc.expression();
                Map projection2 = asc.projections();
                if (v instanceof Variable) {
                    Variable variable = (Variable)v;
                    String key = variable.name();
                    return new SortColumnsWithProjections((ColumnOrder)new Ascending(key), (ProvidedOrder.Column)new ProvidedOrder.Asc((Expression)variable), (Map<String, Expression>)projection2, (Option<Tuple2<String, Expression>>)None$.MODULE$);
                }
            }
            if (columnOrder instanceof InterestingOrder.Desc) {
                bl2 = true;
                desc = (InterestingOrder.Desc)columnOrder;
                Expression v = desc.expression();
                Map projection3 = desc.projections();
                if (v instanceof Variable) {
                    Variable variable = (Variable)v;
                    String key = variable.name();
                    return new SortColumnsWithProjections((ColumnOrder)new Descending(key), (ProvidedOrder.Column)new ProvidedOrder.Desc((Expression)variable), (Map<String, Expression>)projection3, (Option<Tuple2<String, Expression>>)None$.MODULE$);
                }
            }
            if (bl) {
                Expression expression = asc.expression();
                Map projection4 = asc.projections();
                String columnId = SortPlanner$.idFrom$1(expression, projection4);
                return new SortColumnsWithProjections((ColumnOrder)new Ascending(columnId), (ProvidedOrder.Column)new ProvidedOrder.Asc(expression), (Map<String, Expression>)projection4, (Option<Tuple2<String, Expression>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnId), (Object)expression)));
            }
            if (!bl2) throw new MatchError((Object)columnOrder);
            Expression expression = desc.expression();
            Map projection5 = desc.projections();
            String columnId = SortPlanner$.idFrom$1(expression, projection5);
            return new SortColumnsWithProjections((ColumnOrder)new Descending(columnId), (ProvidedOrder.Column)new ProvidedOrder.Desc(expression), (Map<String, Expression>)projection5, (Option<Tuple2<String, Expression>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnId), (Object)expression)));
        }, Seq$.MODULE$.canBuildFrom());
        Map projections = (Map)sortItems.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(acc, i) -> acc.$plus$plus(i.projections()));
        LogicalPlan projected1 = SortPlanner$.projected$1(plan, projections, SortPlanner$.projected$default$3$1(), interestingOrder, context);
        Map unaliasedProjections = (Map)sortItems.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(acc, i) -> acc.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(i.unaliasedProjections())));
        LogicalPlan projected2 = SortPlanner$.projected$1(projected1, unaliasedProjections, false, interestingOrder, context);
        Seq sortColumns = (Seq)sortItems.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.columnOrder(), Seq$.MODULE$.canBuildFrom());
        Seq providedOrderColumns = (Seq)sortItems.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.providedOrderColumn(), Seq$.MODULE$.canBuildFrom());
        if (sortColumns.forall((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$11(projected2, column)))) {
            if (satisfiedPrefix.isEmpty()) {
                none$ = new Some((Object)context.logicalPlanProducer().planSort(projected2, (Seq<ColumnOrder>)sortColumns, new ProvidedOrder(providedOrderColumns), interestingOrder, context));
            } else {
                Tuple2 tuple2 = sortColumns.splitAt(satisfiedPrefix.length());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq prefixColumnOrders = (Seq)tuple2._1();
                Seq suffixColumnOrders = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)prefixColumnOrders, (Object)suffixColumnOrders);
                Tuple2 tuple23 = tuple22;
                Seq prefixColumnOrders2 = (Seq)tuple23._1();
                Seq suffixColumnOrders2 = (Seq)tuple23._2();
                none$ = new Some((Object)context.logicalPlanProducer().planPartialSort(projected2, (Seq<ColumnOrder>)prefixColumnOrders2, (Seq<ColumnOrder>)suffixColumnOrders2, new ProvidedOrder(providedOrderColumns), interestingOrder, context));
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$planSort$1(Expression expression$1, Tuple2 x$1) {
        Object object = x$1._2();
        Expression expression = expression$1;
        return !(object != null ? !object.equals(expression) : expression != null);
    }

    private static final String idFrom$1(Expression expression, Map projection2) {
        return (String)projection2.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$1(expression, x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> expression.asCanonicalStringVal());
    }

    public static final /* synthetic */ boolean $anonfun$planSort$5(LogicalPlan plan$1, LogicalVariable e) {
        return plan$1.availableSymbols().contains((Object)e.name());
    }

    private static final LogicalPlan projected$1(LogicalPlan plan, Map projections, boolean updateSolved, InterestingOrder interestingOrder$1, LogicalPlanningContext context$1) {
        Iterable projectionDeps = (Iterable)projections.flatMap((Function1 & Serializable & scala.Serializable)e -> ((Expression)e._2()).dependencies(), Iterable$.MODULE$.canBuildFrom());
        return projections.nonEmpty() && projectionDeps.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SortPlanner$.$anonfun$planSort$5(plan, e))) ? projection$.MODULE$.apply(plan, (Map<String, Expression>)projections, (Map<String, Expression>)(updateSolved ? projections : Predef$.MODULE$.Map().empty()), interestingOrder$1, context$1) : plan;
    }

    private static final boolean projected$default$3$1() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$planSort$11(LogicalPlan projected2$1, ColumnOrder column) {
        return projected2$1.availableSymbols().contains((Object)column.id());
    }

    private SortPlanner$() {
        MODULE$ = this;
    }
}

