/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState$;
import org.neo4j.cypher.internal.ir.PeriodicCommit;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.v4_0.ast.MultiDatabaseAdministrationCommand;
import org.neo4j.cypher.internal.v4_0.ast.Query;
import org.neo4j.cypher.internal.v4_0.ast.Statement;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.v4_0.frontend.PlannerName;
import org.neo4j.cypher.internal.v4_0.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.v4_0.frontend.phases.BaseState;
import org.neo4j.cypher.internal.v4_0.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Condition;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Phase;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Transformer;
import org.neo4j.cypher.internal.v4_0.util.InputPosition;
import org.neo4j.cypher.internal.v4_0.util.symbols.CypherType;
import org.neo4j.exceptions.DatabaseAdministrationException;
import org.neo4j.exceptions.InternalException;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;

public final class CreatePlannerQuery$
implements Phase<BaseContext, BaseState, LogicalPlanState> {
    public static CreatePlannerQuery$ MODULE$;

    static {
        new CreatePlannerQuery$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<BaseContext, BaseState, LogicalPlanState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public String description() {
        return "from the normalized ast, create the corresponding PlannerQuery";
    }

    public Set<Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(UnionQuery.class), ManifestFactory$.MODULE$.classType(UnionQuery.class))}));
    }

    public LogicalPlanState process(BaseState from, BaseContext context) {
        Statement statement = from.statement();
        if (!(statement instanceof Query)) {
            if (statement instanceof MultiDatabaseAdministrationCommand) {
                MultiDatabaseAdministrationCommand multiDatabaseAdministrationCommand = (MultiDatabaseAdministrationCommand)statement;
                throw new DatabaseAdministrationException(new StringBuilder(89).append("This is an administration command and it should be executed against the system database: ").append(multiDatabaseAdministrationCommand.name()).toString());
            }
            throw new InternalException(new StringBuilder(27).append("Expected a Query and not `").append(statement).append("`").toString());
        }
        Query query = (Query)statement;
        PlannerQuery plannerQuery = StatementConverters$.MODULE$.toPlannerQuery(query, from.semanticTable());
        LogicalPlanState qual$1 = LogicalPlanState$.MODULE$.apply(from);
        Some x$1 = new Some((Object)plannerQuery);
        String x$2 = qual$1.copy$default$1();
        Option<InputPosition> x$3 = qual$1.copy$default$2();
        PlannerName x$4 = qual$1.copy$default$3();
        PlanningAttributes x$5 = qual$1.copy$default$4();
        Option<Statement> x$6 = qual$1.copy$default$5();
        Option<SemanticState> x$7 = qual$1.copy$default$6();
        Option<Map<String, Object>> x$8 = qual$1.copy$default$7();
        Option<SemanticTable> x$9 = qual$1.copy$default$8();
        Option<LogicalPlan> x$10 = qual$1.copy$default$10();
        Option<Option<PeriodicCommit>> x$11 = qual$1.copy$default$11();
        Set<Condition> x$12 = qual$1.copy$default$12();
        Map<String, CypherType> x$13 = qual$1.copy$default$13();
        boolean x$14 = qual$1.copy$default$14();
        Option<Seq<String>> x$15 = qual$1.copy$default$15();
        LogicalPlanState logicalPlanState = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<PlannerQuery>)x$1, x$10, x$11, x$12, x$13, x$14, x$15);
        return logicalPlanState;
    }

    private CreatePlannerQuery$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
    }
}

