/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.helpers.MapSupport$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.compiler.planner.logical.ExpressionEvaluator;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics$QueryGraphSolverInput$;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.StrictnessMode;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.v4_0.expressions.Expression;
import org.neo4j.cypher.internal.v4_0.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.v4_0.expressions.LabelName;
import org.neo4j.cypher.internal.v4_0.util.Cardinality;
import org.neo4j.cypher.internal.v4_0.util.Cardinality$;
import org.neo4j.cypher.internal.v4_0.util.Multiplier;
import org.neo4j.cypher.internal.v4_0.util.Selectivity;
import org.neo4j.values.storable.NumberValue;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001E\u0011\u0001e\u0015;bi&\u001cH/[2t\u0005\u0006\u001c7.\u001a3DCJ$\u0017N\\1mSRLXj\u001c3fY*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r.\u001d\tQ2F\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002-\u0005\u00059Q*\u001a;sS\u000e\u001c\u0018B\u0001\u00180\u0005A\u0019\u0015M\u001d3j]\u0006d\u0017\u000e^=N_\u0012,GN\u0003\u0002-\u0005!A\u0011\u0007\u0001B\u0001B\u0003%!'\u0001\u000erk\u0016\u0014\u0018p\u0012:ba\"\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=N_\u0012,G\u000e\u0005\u0002\u001ag%\u0011Ag\f\u0002\u001b#V,'/_$sCBD7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005I2/[7qY\u0016,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s!\tA\u0014(D\u0001\u0003\u0013\tQ$AA\nFqB\u0014Xm]:j_:,e/\u00197vCR|'\u000fC\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0004}}\u0002\u0005C\u0001\u001d\u0001\u0011\u0015\t4\b1\u00013\u0011\u001514\b1\u00018\u0011\u001d\u0011\u0005A1A\u0005\n\r\u000bq$\u001a=qe\u0016\u001c8/[8o'\u0016dWm\u0019;jm&$\u0018pQ1mGVd\u0017\r^8s+\u0005!\u0005CA#I\u001b\u00051%BA$\u0003\u0003-\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=\n\u0005%3%aH#yaJ,7o]5p]N+G.Z2uSZLG/_\"bY\u000e,H.\u0019;pe\"11\n\u0001Q\u0001\n\u0011\u000b\u0001%\u001a=qe\u0016\u001c8/[8o'\u0016dWm\u0019;jm&$\u0018pQ1mGVd\u0017\r^8sA!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001C2p[\nLg.\u001a:\u0016\u0003=\u0003\"!\u0012)\n\u0005E3%aE*fY\u0016\u001cG/\u001b<jif\u001cu.\u001c2j]\u0016\u0014\bBB*\u0001A\u0003%q*A\u0005d_6\u0014\u0017N\\3sA!)Q\u000b\u0001C\u0001-\u0006)\u0011\r\u001d9msR!qkX4m!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003vi&d'B\u0001/\t\u0003\u00111Hg\u0018\u0019\n\u0005yK&aC\"be\u0012Lg.\u00197jifDQ\u0001\u0019+A\u0002\u0005\f\u0011\"];fef\u0004\u0016M\u001d;\u0011\u0005\t,W\"A2\u000b\u0005\u0011D\u0011AA5s\u0013\t17M\u0001\tQY\u0006tg.\u001a:Rk\u0016\u0014\u0018\u0010U1si\")\u0001\u000e\u0016a\u0001S\u00061\u0011N\u001c9viB\u0002\"!\u00076\n\u0005-|#!F)vKJLxI]1qQN{GN^3s\u0013:\u0004X\u000f\u001e\u0005\u0006[R\u0003\rA\\\u0001\u000eg\u0016l\u0017M\u001c;jGR\u000b'\r\\3\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018!C:f[\u0006tG/[2t\u0015\t\u00198,A\u0002bgRL!!\u001e9\u0003\u001bM+W.\u00198uS\u000e$\u0016M\u00197f\u0011\u00159\b\u0001\"\u0003y\u0003\r\u001a\u0017\r\\2vY\u0006$XmQ1sI&t\u0017\r\\5us\u001a{'/U;fefDuN]5{_:$RaV=|\u0003\u0003AQA\u001f<A\u0002]\u000b!!\u001b8\t\u000bq4\b\u0019A?\u0002\u000f!|'/\u001b>p]B\u0011!M`\u0005\u0003\u007f\u000e\u0014A\"U;fefDuN]5{_:DQ!\u001c<A\u00029Dq!!\u0002\u0001\t\u0013\t9!\u0001\u0011i_JL'p\u001c8DCJ$\u0017N\\1mSRLx+\u001b;i'\u0016dWm\u0019;j_:\u001cHcB,\u0002\n\u00055\u0011q\u0003\u0005\b\u0003\u0017\t\u0019\u00011\u0001X\u0003i\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=CK\u001a|'/Z*fY\u0016\u001cG/[8o\u0011!\ty!a\u0001A\u0002\u0005E\u0011!B<iKJ,\u0007c\u00012\u0002\u0014%\u0019\u0011QC2\u0003\u0015M+G.Z2uS>t7\u000f\u0003\u0004n\u0003\u0007\u0001\rA\u001c\u0005\b\u00037\u0001A\u0011BA\u000f\u0003\u0005\u001a\u0017\r\\2vY\u0006$XmQ1sI&t\u0017\r\\5us\u001a{'/U;fef<%/\u00199i)\u001dI\u0017qDA\u0015\u0003[A\u0001\"!\t\u0002\u001a\u0001\u0007\u00111E\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0004E\u0006\u0015\u0012bAA\u0014G\nQ\u0011+^3ss\u001e\u0013\u0018\r\u001d5\t\u000f\u0005-\u0012\u0011\u0004a\u0001S\u0006)\u0011N\u001c9vi\"1Q.!\u0007A\u00029\u0004")
public class StatisticsBackedCardinalityModel
implements Metrics.CardinalityModel {
    private final Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel;
    private final ExpressionEvaluator simpleExpressionEvaluator;
    private final ExpressionSelectivityCalculator expressionSelectivityCalculator;
    private final SelectivityCombiner combiner;

    private ExpressionSelectivityCalculator expressionSelectivityCalculator() {
        return this.expressionSelectivityCalculator;
    }

    private SelectivityCombiner combiner() {
        return this.combiner;
    }

    @Override
    public Cardinality apply(PlannerQueryPart queryPart, Metrics.QueryGraphSolverInput input0, SemanticTable semanticTable) {
        Cardinality cardinality;
        PlannerQueryPart plannerQueryPart = queryPart;
        if (plannerQueryPart instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQueryPart;
            Metrics.QueryGraphSolverInput output = (Metrics.QueryGraphSolverInput)singlePlannerQuery.fold((Object)input0, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Metrics.QueryGraphSolverInput input = (Metrics.QueryGraphSolverInput)tuple2._1();
                SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)tuple2._2();
                if (!(singlePlannerQuery instanceof RegularSinglePlannerQuery)) throw new MatchError((Object)tuple2);
                RegularSinglePlannerQuery regularSinglePlannerQuery = (RegularSinglePlannerQuery)singlePlannerQuery;
                QueryGraph graph = regularSinglePlannerQuery.queryGraph();
                QueryHorizon horizon = regularSinglePlannerQuery.horizon();
                Metrics.QueryGraphSolverInput queryGraphSolverInput = this.calculateCardinalityForQueryGraph(graph, input, semanticTable);
                if (queryGraphSolverInput == null) throw new MatchError((Object)queryGraphSolverInput);
                Map<String, Set<LabelName>> newLabels = queryGraphSolverInput.labelInfo();
                Cardinality graphCardinality = queryGraphSolverInput.inboundCardinality();
                Option<StrictnessMode> laziness = queryGraphSolverInput.strictness();
                Tuple3 tuple3 = new Tuple3(newLabels, (Object)graphCardinality, laziness);
                Tuple3 tuple32 = tuple3;
                Map newLabels2 = (Map)tuple32._1();
                Cardinality graphCardinality2 = (Cardinality)tuple32._2();
                Option laziness2 = (Option)tuple32._3();
                Cardinality horizonCardinality = this.calculateCardinalityForQueryHorizon(graphCardinality2, horizon, semanticTable);
                return new Metrics.QueryGraphSolverInput((Map<String, Set<LabelName>>)newLabels2, horizonCardinality, (Option<StrictnessMode>)laziness2);
            });
            cardinality = output.inboundCardinality();
        } else if (plannerQueryPart instanceof UnionQuery) {
            UnionQuery unionQuery = (UnionQuery)plannerQueryPart;
            PlannerQueryPart part = unionQuery.part();
            SinglePlannerQuery query = unionQuery.query();
            boolean distinct2 = unionQuery.distinct();
            Cardinality unionCardinality = this.apply(part, input0, semanticTable).$plus(this.apply((PlannerQueryPart)query, input0, semanticTable));
            cardinality = distinct2 ? unionCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY()) : unionCardinality;
        } else {
            throw new MatchError((Object)plannerQueryPart);
        }
        return cardinality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cardinality calculateCardinalityForQueryHorizon(Cardinality in, QueryHorizon horizon, SemanticTable semanticTable) {
        boolean bl = false;
        RegularQueryProjection regularQueryProjection = null;
        boolean bl2 = false;
        AggregatingQueryProjection aggregatingQueryProjection = null;
        QueryHorizon queryHorizon = horizon;
        if (queryHorizon instanceof RegularQueryProjection) {
            Some some;
            Expression limit;
            Option option;
            bl = true;
            regularQueryProjection = (RegularQueryProjection)queryHorizon;
            QueryPagination queryPagination = regularQueryProjection.queryPagination();
            Selections where = regularQueryProjection.selections();
            if (queryPagination != null && (option = queryPagination.limit()) instanceof Some && (limit = (Expression)(some = (Some)option).value()) instanceof IntegerLiteral) {
                IntegerLiteral integerLiteral = (IntegerLiteral)limit;
                Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, Cardinality$.MODULE$.lift((double)Predef$.MODULE$.Long2long(integerLiteral.value())));
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, where, semanticTable);
            }
        }
        if (bl) {
            Option option;
            QueryPagination queryPagination = regularQueryProjection.queryPagination();
            Selections where = regularQueryProjection.selections();
            if (queryPagination != null && (option = queryPagination.limit()) instanceof Some) {
                Option<Object> evaluatedValue;
                boolean cannotEvaluateStableValue;
                Some some = (Some)option;
                Expression limit = (Expression)some.value();
                boolean bl3 = cannotEvaluateStableValue = this.simpleExpressionEvaluator.hasParameters(limit) || !this.simpleExpressionEvaluator.isDeterministic(limit);
                Cardinality limitCardinality = cannotEvaluateStableValue ? PlannerDefaults$.MODULE$.DEFAULT_LIMIT_CARDINALITY() : ((evaluatedValue = this.simpleExpressionEvaluator.evaluateExpression(limit)).isDefined() && evaluatedValue.get() instanceof NumberValue ? new Cardinality(((NumberValue)evaluatedValue.get()).doubleValue()) : PlannerDefaults$.MODULE$.DEFAULT_LIMIT_CARDINALITY());
                Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, limitCardinality);
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, where, semanticTable);
            }
        }
        if (bl) {
            return this.horizonCardinalityWithSelections(in, regularQueryProjection.selections(), semanticTable);
        }
        if (queryHorizon instanceof AggregatingQueryProjection) {
            bl2 = true;
            aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            if (aggregatingQueryProjection.aggregationExpressions().isEmpty()) {
                Cardinality cardinalityBeforeSelection = in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
                return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, aggregatingQueryProjection.selections(), semanticTable);
            }
        }
        if (queryHorizon instanceof DistinctQueryProjection) {
            DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
            Cardinality cardinalityBeforeSelection = in.$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
            return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, distinctQueryProjection.selections(), semanticTable);
        }
        if (bl2 && aggregatingQueryProjection.groupingExpressions().isEmpty()) {
            Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, Cardinality$.MODULE$.SINGLE());
            return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, aggregatingQueryProjection.selections(), semanticTable);
        }
        if (bl2) {
            Cardinality cardinalityBeforeSelection = Cardinality$.MODULE$.min(in, Cardinality$.MODULE$.sqrt(in));
            return this.horizonCardinalityWithSelections(cardinalityBeforeSelection, aggregatingQueryProjection.selections(), semanticTable);
        }
        if (queryHorizon instanceof UnwindProjection) {
            return in.$times(new Multiplier(10.0));
        }
        if (queryHorizon instanceof ProcedureCallProjection) {
            return in.$times(new Multiplier(10.0)).min(Cardinality$.MODULE$.lift(1.0)).max(Cardinality$.MODULE$.lift(10000.0));
        }
        if (queryHorizon instanceof LoadCSVProjection) {
            return in;
        }
        if (queryHorizon instanceof PassthroughAllHorizon) {
            return in;
        }
        if (!(queryHorizon instanceof CallSubqueryHorizon)) throw new MatchError((Object)queryHorizon);
        CallSubqueryHorizon callSubqueryHorizon = (CallSubqueryHorizon)queryHorizon;
        PlannerQueryPart subquery = callSubqueryHorizon.callSubquery();
        Cardinality subQueryCardinality = this.apply(subquery, Metrics$QueryGraphSolverInput$.MODULE$.empty(), semanticTable);
        return in.$times(subQueryCardinality);
    }

    private Cardinality horizonCardinalityWithSelections(Cardinality cardinalityBeforeSelection, Selections where, SemanticTable semanticTable) {
        Cardinality cardinality;
        Selections selections = where;
        SemanticTable implicitSemanticTable = semanticTable;
        Seq expressionSelectivities = (Seq)selections.flatPredicates().map((Function1 & Serializable & scala.Serializable)x$2 -> this.expressionSelectivityCalculator().apply((Expression)x$2, implicitSemanticTable, selections), Seq$.MODULE$.canBuildFrom());
        Option<Selectivity> maybeWhereSelectivity = this.combiner().andTogetherSelectivities((Seq<Selectivity>)expressionSelectivities);
        Option<Selectivity> option = maybeWhereSelectivity;
        if (option instanceof Some) {
            Some some = (Some)option;
            Selectivity whereSelectivity = (Selectivity)some.value();
            cardinality = cardinalityBeforeSelection.$times(whereSelectivity);
        } else if (None$.MODULE$.equals(option)) {
            cardinality = cardinalityBeforeSelection;
        } else {
            throw new MatchError(option);
        }
        return cardinality;
    }

    private Metrics.QueryGraphSolverInput calculateCardinalityForQueryGraph(QueryGraph graph, Metrics.QueryGraphSolverInput input, SemanticTable semanticTable) {
        Map<String, Set<LabelName>> newLabels = MapSupport$.MODULE$.PowerMap(input.labelInfo()).fuse((Map<String, Set<LabelName>>)graph.patternNodeLabels(), (Function2<Set<LabelName>, Set<LabelName>, Set<LabelName>>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (Set)x$3.$plus$plus((GenTraversableOnce)x$4));
        Cardinality newCardinality = this.queryGraphCardinalityModel.apply(graph, input, semanticTable);
        return new Metrics.QueryGraphSolverInput(newLabels, newCardinality, input.strictness());
    }

    public StatisticsBackedCardinalityModel(Metrics.QueryGraphCardinalityModel queryGraphCardinalityModel, ExpressionEvaluator simpleExpressionEvaluator2) {
        this.queryGraphCardinalityModel = queryGraphCardinalityModel;
        this.simpleExpressionEvaluator = simpleExpressionEvaluator2;
        this.expressionSelectivityCalculator = queryGraphCardinalityModel.expressionSelectivityCalculator();
        this.combiner = IndependenceCombiner$.MODULE$;
    }
}

