/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.ir.CreatesPropertyKeys;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeLogicalLeafPlan;
import org.neo4j.cypher.internal.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;

public final class Eagerness$ {
    public static Eagerness$ MODULE$;

    static {
        new Eagerness$();
    }

    public boolean readWriteConflictInHead(LogicalPlan plan, SinglePlannerQuery plannerQuery) {
        Seq unstableLeaves = (Seq)plan.leaves().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof NodeLogicalLeafPlan) {
                    NodeLogicalLeafPlan nodeLogicalLeafPlan = (NodeLogicalLeafPlan)A1;
                    object = nodeLogicalLeafPlan.idName();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof NodeLogicalLeafPlan;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return unstableLeaves.isEmpty() ? false : this.headConflicts(plannerQuery, plannerQuery, (Seq<String>)((Seq)unstableLeaves.tail()));
    }

    private boolean headConflicts(SinglePlannerQuery head, SinglePlannerQuery tail, Seq<String> unstableLeaves) {
        boolean bl;
        while (true) {
            boolean conflict;
            boolean mergeReadWrite;
            SinglePlannerQuery singlePlannerQuery = head;
            SinglePlannerQuery singlePlannerQuery2 = tail;
            boolean bl2 = !(singlePlannerQuery != null ? !singlePlannerQuery.equals(singlePlannerQuery2) : singlePlannerQuery2 != null) && head.queryGraph().containsMergeRecursive() ? true : (mergeReadWrite = false);
            boolean bl3 = tail.queryGraph().readOnly() || mergeReadWrite ? false : (conflict = this.hasUnsafeRelationships(head.queryGraph()) && (tail.queryGraph().createRelationshipOverlap(head.queryGraph()) || tail.queryGraph().deleteOverlap(head.queryGraph()) || tail.queryGraph().setPropertyOverlap(head.queryGraph())) || unstableLeaves.exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$headConflicts$1(head, tail, x$1))));
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    public LogicalPlan headReadWriteEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflictInHead(inputPlan, query) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeNonRecursive(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || this.readWriteConflict(query, query) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailReadWriteEagerizeRecursive(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        return alwaysEager || query.tail().isDefined() && this.readWriteConflictInTail(query, (SinglePlannerQuery)query.tail().get()) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan headWriteReadEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInHead(query, (SinglePlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    public LogicalPlan tailWriteReadEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        boolean conflictInHorizon = query.queryGraph().overlapsHorizon(query.horizon(), context.semanticTable());
        return alwaysEager || conflictInHorizon || query.tail().isDefined() && this.writeReadConflictInTail(query, (SinglePlannerQuery)query.tail().get(), context) ? context.logicalPlanProducer().planEager(inputPlan, context) : inputPlan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan horizonReadWriteEagerize(LogicalPlan inputPlan, SinglePlannerQuery query, LogicalPlanningContext context) {
        boolean alwaysEager = context.config().updateStrategy().alwaysEager();
        LogicalPlan logicalPlan = inputPlan;
        if (logicalPlan instanceof ProcedureCall) {
            ProcedureCall procedureCall = (ProcedureCall)logicalPlan;
            LogicalPlan left = procedureCall.source();
            ResolvedCall call = procedureCall.call();
            if (call.signature().eager()) {
                return context.logicalPlanProducer().planCallProcedure(context.logicalPlanProducer().planEager(left, context), call, query.interestingOrder(), context);
            }
        }
        if (alwaysEager) return context.logicalPlanProducer().planEager(inputPlan, context);
        if (!query.tail().nonEmpty()) return inputPlan;
        if (!this.horizonReadWriteConflict(query, (SinglePlannerQuery)query.tail().get(), context)) return inputPlan;
        return context.logicalPlanProducer().planEager(inputPlan, context);
    }

    public boolean readWriteConflictInTail(SinglePlannerQuery head, SinglePlannerQuery tail) {
        boolean bl;
        while (true) {
            boolean conflict;
            if (conflict = this.readWriteConflict(head, tail)) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    public boolean readWriteConflict(SinglePlannerQuery readQuery, SinglePlannerQuery writeQuery) {
        SinglePlannerQuery singlePlannerQuery = readQuery;
        SinglePlannerQuery singlePlannerQuery2 = writeQuery;
        boolean mergeReadWrite = !(singlePlannerQuery != null ? !singlePlannerQuery.equals(singlePlannerQuery2) : singlePlannerQuery2 != null) && readQuery.queryGraph().containsMergeRecursive();
        boolean conflict = writeQuery.queryGraph().readOnly() || mergeReadWrite ? false : writeQuery.queryGraph().overlaps(readQuery.queryGraph());
        return conflict;
    }

    public boolean writeReadConflictInTail(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        boolean bl;
        while (true) {
            boolean conflict;
            boolean bl2 = tail.queryGraph().writeOnly() ? false : (conflict = head.queryGraph().overlaps(tail.queryGraph()) || head.queryGraph().overlapsHorizon(tail.horizon(), context.semanticTable()) || this.deleteReadOverlap(head.queryGraph(), tail.queryGraph(), context));
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    public boolean horizonReadWriteConflict(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        boolean bl;
        while (true) {
            boolean conflict;
            if (conflict = tail.queryGraph().overlapsHorizon(head.horizon(), context.semanticTable())) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    private boolean deleteReadOverlap(QueryGraph from, QueryGraph to, LogicalPlanningContext context) {
        Set deleted = from.identifiersToDelete();
        return this.deletedRelationshipsOverlap((Set<String>)deleted, to, context) || this.deletedNodesOverlap((Set<String>)deleted, to, context);
    }

    private boolean deletedRelationshipsOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set relsToRead = to.allPatternRelationshipsRead();
        Set relsDeleted = (Set)deleted.filter((Function1 & java.io.Serializable & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$deletedRelationshipsOverlap$1(context, id)));
        return relsToRead.nonEmpty() && relsDeleted.nonEmpty();
    }

    private boolean deletedNodesOverlap(Set<String> deleted, QueryGraph to, LogicalPlanningContext context) {
        Set nodesToRead = to.allPatternNodesRead();
        Set nodesDeleted = (Set)deleted.filter((Function1 & java.io.Serializable & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$deletedNodesOverlap$1(context, id)));
        return nodesToRead.nonEmpty() && nodesDeleted.nonEmpty();
    }

    public boolean writeReadConflictInHead(SinglePlannerQuery head, SinglePlannerQuery tail, LogicalPlanningContext context) {
        return head.queryGraph().writeOnly() ? this.writeReadConflictInHeadRecursive(head, tail) : this.writeReadConflictInTail(head, tail, context);
    }

    public boolean writeReadConflictInHeadRecursive(SinglePlannerQuery head, SinglePlannerQuery tail) {
        boolean bl;
        while (true) {
            boolean conflict;
            boolean bl2 = conflict = tail.queryGraph().writeOnly() ? false : head.queryGraph().writeOnlyHeadOverlaps(tail.queryGraph());
            if (conflict) {
                bl = true;
                break;
            }
            if (tail.tail().isEmpty()) {
                bl = false;
                break;
            }
            tail = (SinglePlannerQuery)tail.tail().get();
        }
        return bl;
    }

    private boolean nodeOverlap(String currentNode, QueryGraph headQueryGraph, SinglePlannerQuery tail) {
        Set labelsOnCurrentNode = headQueryGraph.allKnownLabelsOnNode(currentNode);
        Set propertiesOnCurrentNode = (Set)headQueryGraph.allKnownPropertiesOnIdentifier(currentNode).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.propertyKey(), Set$.MODULE$.canBuildFrom());
        Set labelsToCreate = tail.queryGraph().createLabels();
        CreatesPropertyKeys propertiesToCreate = tail.queryGraph().createNodeProperties();
        Set labelsToRemove = tail.queryGraph().labelsToRemoveFromOtherNodes(currentNode);
        boolean tailCreatesNodes = tail.exists((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Eagerness$.$anonfun$nodeOverlap$2(x$3)));
        return tail.queryGraph().updatesNodes() && (labelsOnCurrentNode.isEmpty() && propertiesOnCurrentNode.isEmpty() && tailCreatesNodes || ((TraversableOnce)labelsOnCurrentNode.intersect((GenSet)labelsToCreate)).nonEmpty() || propertiesOnCurrentNode.exists((Function1 & java.io.Serializable & Serializable)propertyKeyName -> BoxesRunTime.boxToBoolean((boolean)propertiesToCreate.overlaps(propertyKeyName))) || ((TraversableOnce)labelsToRemove.intersect((GenSet)labelsOnCurrentNode)).nonEmpty());
    }

    private boolean hasUnsafeRelationships(QueryGraph queryGraph) {
        return this.hasRelationships(queryGraph);
    }

    private boolean hasRelationships(QueryGraph queryGraph) {
        return queryGraph.allPatternRelationships().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$headConflicts$1(SinglePlannerQuery head$1, SinglePlannerQuery tail$1, String x$1) {
        return MODULE$.nodeOverlap(x$1, head$1.queryGraph(), tail$1) || tail$1.queryGraph().createRelationshipOverlap(head$1.queryGraph()) || tail$1.queryGraph().setLabelOverlap(head$1.queryGraph()) || tail$1.queryGraph().setPropertyOverlap(head$1.queryGraph()) || tail$1.queryGraph().deleteOverlap(head$1.queryGraph()) || tail$1.queryGraph().foreachOverlap(head$1.queryGraph());
    }

    public static final /* synthetic */ boolean $anonfun$deletedRelationshipsOverlap$1(LogicalPlanningContext context$1, String id) {
        return context$1.semanticTable().isRelationship(id);
    }

    public static final /* synthetic */ boolean $anonfun$deletedNodesOverlap$1(LogicalPlanningContext context$2, String id) {
        return context$2.semanticTable().isNode(id);
    }

    public static final /* synthetic */ boolean $anonfun$nodeOverlap$2(SinglePlannerQuery x$3) {
        return x$3.queryGraph().createsNodes();
    }

    private Eagerness$() {
        MODULE$ = this;
    }
}

