/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.v4_0.expressions.LabelName;
import org.neo4j.cypher.internal.v4_0.expressions.Property;
import org.neo4j.cypher.internal.v4_0.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.v4_0.expressions.RelTypeName;
import org.neo4j.cypher.internal.v4_0.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.v4_0.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Condition;
import org.neo4j.cypher.internal.v4_0.frontend.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Phase;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Transformer;
import org.neo4j.cypher.internal.v4_0.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.v4_0.util.Foldable;
import org.neo4j.cypher.internal.v4_0.util.Foldable$;
import org.neo4j.values.storable.DurationFields;
import org.neo4j.values.storable.PointFields;
import org.neo4j.values.storable.TemporalValue;
import scala.Array$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class CheckForUnresolvedTokens$
implements VisitorPhase<BaseContext, LogicalPlanState> {
    public static CheckForUnresolvedTokens$ MODULE$;
    private final Set<String> org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey;

    static {
        new CheckForUnresolvedTokens$();
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.postConditions$((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, LogicalPlanState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<BaseContext, LogicalPlanState, LogicalPlanState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public Set<String> org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey() {
        return this.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey;
    }

    public void visit(LogicalPlanState value, BaseContext context) {
        SemanticTable table = value.semanticTable();
        Seq notifications = (Seq)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)value.statement()), (Object)Seq$.MODULE$.empty(), (PartialFunction)new scala.Serializable(table){
            public static final long serialVersionUID = 0L;
            private final SemanticTable table$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Property property;
                PropertyKeyName prop;
                RelTypeName relTypeName;
                String name;
                Function1 & Serializable & scala.Serializable intersect;
                LabelName labelName;
                String name2;
                A1 A1 = x1;
                if (A1 instanceof LabelName && CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyLabel$1(name2 = (labelName = (LabelName)A1).name(), this.table$1)) {
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Tuple2(acc.$colon$plus((Object)new MissingLabelNotification(labelName.position(), name2), Seq$.MODULE$.canBuildFrom()), (Object)new Some((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x)));
                    return (B1)intersect;
                }
                if (A1 instanceof RelTypeName && CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyRelType$1(name = (relTypeName = (RelTypeName)A1).name(), this.table$1)) {
                    intersect = (Function1 & Serializable & scala.Serializable)acc -> new Tuple2(acc.$colon$plus((Object)new MissingRelTypeNotification(relTypeName.position(), name), Seq$.MODULE$.canBuildFrom()), (Object)new Some((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x)));
                    return (B1)intersect;
                }
                if (A1 instanceof Property && (prop = (property = (Property)A1).propertyKey()) != null) {
                    String name3 = prop.name();
                    if (!CheckForUnresolvedTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey().apply((Object)name3.toLowerCase()) && CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyPropertyName$1(name3, this.table$1)) {
                        intersect = (Function1 & Serializable & scala.Serializable)acc -> new Tuple2(acc.$colon$plus((Object)new MissingPropertyNameNotification(prop.position(), name3), Seq$.MODULE$.canBuildFrom()), (Object)new Some((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x)));
                        return (B1)intersect;
                    }
                }
                intersect = function1.apply(x1);
                return (B1)intersect;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                RelTypeName relTypeName;
                String name;
                LabelName labelName;
                String name2;
                Object object = x1;
                if (object instanceof LabelName && CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyLabel$1(name2 = (labelName = (LabelName)object).name(), this.table$1)) {
                    return true;
                }
                if (object instanceof RelTypeName && CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyRelType$1(name = (relTypeName = (RelTypeName)object).name(), this.table$1)) {
                    return true;
                }
                if (!(object instanceof Property)) return false;
                Property property = (Property)object;
                PropertyKeyName prop = property.propertyKey();
                if (prop == null) return false;
                String name3 = prop.name();
                if (CheckForUnresolvedTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey().apply((Object)name3.toLowerCase())) return false;
                if (!CheckForUnresolvedTokens$.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyPropertyName$1(name3, this.table$1)) return false;
                return true;
            }
            {
                this.table$1 = table$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String org.neo4j.cypher.internal.v4_0.expressions.LabelName scala.collection.Seq ), $anonfun$applyOrElse$3(java.lang.String org.neo4j.cypher.internal.v4_0.expressions.RelTypeName scala.collection.Seq ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.v4_0.expressions.PropertyKeyName java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$2(scala.collection.Seq ), $anonfun$applyOrElse$4(scala.collection.Seq ), $anonfun$applyOrElse$6(scala.collection.Seq )}, serializedLambda);
            }
        });
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        notifications.foreach((Function1 & Serializable & scala.Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public String description() {
        return "find labels, relationships types and property keys that do not exist in the db and issue warnings";
    }

    public static final boolean org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyLabel$1(String label, SemanticTable table$1) {
        return !table$1.resolvedLabelNames().contains((Object)label);
    }

    public static final boolean org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyRelType$1(String relType, SemanticTable table$1) {
        return !table$1.resolvedRelTypeNames().contains((Object)relType);
    }

    public static final boolean org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$isEmptyPropertyName$1(String name, SemanticTable table$1) {
        return !table$1.resolvedPropertyKeyNames().contains((Object)name);
    }

    private CheckForUnresolvedTokens$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        VisitorPhase.$init$((VisitorPhase)this);
        this.org$neo4j$cypher$internal$compiler$planner$CheckForUnresolvedTokens$$specialPropertyKey = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(TemporalValue.TemporalFields.allFields()).asScala()).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DurationFields.values())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.propertyKey, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PointFields.values())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.propertyKey, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(), Set$.MODULE$.canBuildFrom())).toSet();
    }
}

