/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps.index;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.ast.semantics.TokenTable;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.schema.GraphSchemaOptimizations;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProvider;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.NodeIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.NodeIndexPlanProvider;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.HasLabelsExpression;
import org.neo4j.cypher.internal.expressions.ImpliedLabel;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.logical.plans.ordering.ProvidedOrderFactory;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.constraints.ConstrainableType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class NodeIndexLeafPlanner$
implements IndexCompatiblePredicatesProvider,
Serializable {
    public static final NodeIndexLeafPlanner$ MODULE$ = new NodeIndexLeafPlanner$();

    static {
        IndexCompatiblePredicatesProvider.$init$(MODULE$);
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<LogicalVariable> arguments, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        return IndexCompatiblePredicatesProvider.findIndexCompatiblePredicates$(this, predicates, arguments, semanticTable, planContext, indexPredicateProviderContext);
    }

    public Set<NodeIndexLeafPlanner.NodeIndexMatch> findIndexMatchesForQueryGraph(QueryGraph qg, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, InterestingOrderConfig interestingOrderConfig, ProvidedOrderFactory providedOrderFactory, GraphSchemaOptimizations graphSchemaOptimizations, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        Set predicates = qg.selections().flatPredicates().toSet();
        Map allLabelPredicatesMap = qg.selections().labelPredicates();
        Map impliedEndpointLabelsMap = ((IterableOnceOps)((IterableOps)qg.patternRelationships().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NodeIndexLeafPlanner$.$anonfun$findIndexMatchesForQueryGraph$4(x$4)))).flatMap((Function1 & Serializable)patRel -> (Seq)((IterableOps)patRel.types().flatMap((Function1 & Serializable)typ -> planContext.getRelationshipEndpointLabelConstraints(typ.name()))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LogicalVariable logicalVariable;
                EndpointType endPointType = (EndpointType)tuple2._1();
                String impliedLabel = (String)tuple2._2();
                EndpointType endpointType = endPointType;
                if (EndpointType.START.equals(endpointType)) {
                    logicalVariable = (LogicalVariable)patRel.inOrder()._1();
                } else if (EndpointType.END.equals(endpointType)) {
                    logicalVariable = (LogicalVariable)patRel.inOrder()._2();
                } else {
                    throw new MatchError((Object)endpointType);
                }
                LogicalVariable variable = logicalVariable;
                if (NodeIndexLeafPlanner$.labelIsAlreadyExplicitOnNode$1(impliedLabel, variable, allLabelPredicatesMap)) {
                    return None$.MODULE$;
                }
                return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)variable), (Object)new ImpliedLabel(new HasLabels((Expression)variable, (Seq)new .colon.colon((Object)new LabelName(impliedLabel, variable.position()), (List)Nil$.MODULE$), variable.position()), variable.position())));
            }
            throw new MatchError((Object)tuple2);
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (allLabelPredicatesMap.isEmpty() && impliedEndpointLabelsMap.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> compatiblePropertyPredicates = this.findIndexCompatiblePredicates((Set<Expression>)predicates, (Set<LogicalVariable>)qg.argumentIds(), semanticTable, planContext, indexPredicateProviderContext);
        Iterable matches = (Iterable)((IterableOps)compatiblePropertyPredicates.groupBy((Function1 & Serializable)x$5 -> x$5.variable()).map((Function1 & Serializable)propertyPredicates -> {
            LogicalVariable variable = (LogicalVariable)propertyPredicates._1();
            Seq labelPredicates = (Seq)Option$.MODULE$.option2Iterable(impliedEndpointLabelsMap.get((Object)variable)).toSeq().$plus$plus((IterableOnce)allLabelPredicatesMap.getOrElse((Object)variable, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()));
            return new Tuple3(propertyPredicates, (Object)variable, (Object)labelPredicates);
        })).flatMap((Function1 & Serializable)x$6 -> {
            Tuple3 tuple3 = x$6;
            if (tuple3 != null) {
                Tuple2 propertyPredicates = (Tuple2)tuple3._1();
                LogicalVariable variable = (LogicalVariable)tuple3._2();
                Seq labelPredicates = (Seq)tuple3._3();
                return (Set)MODULE$.findIndexMatches(variable, (Set<EntityIndexLeafPlanner.IndexCompatiblePredicate>)((Set)propertyPredicates._2()), (Set<HasLabelsExpression>)labelPredicates.toSet(), interestingOrderConfig, (TokenTable)semanticTable, planContext, providedOrderFactory, findTextIndexes, findRangeIndexes, findPointIndexes, graphSchemaOptimizations).map((Function1 & Serializable)indexMatch -> indexMatch);
            }
            throw new MatchError((Object)tuple3);
        });
        return matches.toSet();
    }

    private Set<NodeIndexLeafPlanner.NodeIndexMatch> findIndexMatches(LogicalVariable variable, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> indexCompatiblePredicates, Set<HasLabelsExpression> labelPredicates, InterestingOrderConfig interestingOrderConfig, TokenTable tokenTable, PlanContext planContext, ProvidedOrderFactory providedOrderFactory, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes, GraphSchemaOptimizations graphSchemaOptimizations) {
        return (Set)labelPredicates.flatMap((Function1 & Serializable)labelPredicate -> (Set)graphSchemaOptimizations.addImpliedLabels((Set<LabelName>)labelPredicate.hasLabels().labels().toSet()).flatMap((Function1 & Serializable)labelName -> (Set)Option$.MODULE$.option2Iterable(tokenTable.id(labelName)).toSet().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NodeIndexLeafPlanner$.$anonfun$findIndexMatches$3(check$ifrefutable$1))).flatMap((Function1 & Serializable)labelId -> MODULE$.indexDescriptorsForLabel((LabelId)labelId, planContext, findTextIndexes, findRangeIndexes, findPointIndexes).flatMap((Function1 & Serializable)indexDescriptor -> (Set)((IterableOps)EntityIndexLeafPlanner$.MODULE$.predicatesForIndex((IndexDescriptor)indexDescriptor, indexCompatiblePredicates, interestingOrderConfig, tokenTable, (Map<String, Seq<ConstrainableType>>)planContext.getNodePropertiesWithTypeConstraint(labelName.name()), providedOrderFactory).map((Function1 & Serializable)predicatesForIndex -> {
            NodeIndexLeafPlanner.NodeIndexMatch indexMatch = new NodeIndexLeafPlanner.NodeIndexMatch(variable, (HasLabelsExpression)labelPredicate, (LabelName)labelName, (LabelId)labelId, predicatesForIndex.predicatesInOrder(), predicatesForIndex.providedOrder(), predicatesForIndex.indexOrder(), (IndexDescriptor)indexDescriptor);
            return new Tuple2(predicatesForIndex, (Object)indexMatch);
        })).map((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                NodeIndexLeafPlanner.NodeIndexMatch indexMatch = (NodeIndexLeafPlanner.NodeIndexMatch)tuple2._2();
                return indexMatch;
            }
            throw new MatchError((Object)tuple2);
        })))));
    }

    public boolean findIndexMatchesForQueryGraph$default$8() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$9() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$10() {
        return true;
    }

    private Iterator<IndexDescriptor> indexDescriptorsForLabel(LabelId labelId, PlanContext planContext, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        return (findRangeIndexes ? planContext.rangeIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId)) : package$.MODULE$.Iterator().empty()).$plus$plus((Function0 & Serializable)() -> {
            if (findTextIndexes) {
                return planContext.textIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId));
            }
            return package$.MODULE$.Iterator().empty();
        }).$plus$plus((Function0 & Serializable)() -> {
            if (findPointIndexes) {
                return planContext.pointIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId));
            }
            return package$.MODULE$.Iterator().empty();
        });
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> implicitIndexCompatiblePredicates(PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Set<Expression> predicates, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> explicitCompatiblePredicates, Function2<LogicalVariable, Set<LogicalVariable>, Object> valid) {
        return (Set)predicates.flatMap((Function1 & Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof HasLabels) {
                Variable variable;
                HasLabels hasLabels = (HasLabels)expression;
                Expression variable2 = hasLabels.expression();
                Seq labels = hasLabels.labels();
                if (variable2 instanceof Variable && BoxesRunTime.unboxToBoolean((Object)valid.apply((Object)(variable = (Variable)variable2), (Object)Predef$.MODULE$.Set().empty()))) {
                    Set constrainedPropNames = indexPredicateProviderContext.outerPlanHasUpdates() || planContext.txStateHasChanges() ? Predef$.MODULE$.Set().empty() : planContext.getNodePropertiesWithExistenceConstraint(((LabelName)labels.head()).name());
                    return EntityIndexLeafPlanner$.MODULE$.implicitIsNotNullPredicates((LogicalVariable)variable, indexPredicateProviderContext.aggregatingProperties(), (Set<String>)constrainedPropNames, explicitCompatiblePredicates);
                }
            }
            return Predef$.MODULE$.Set().empty();
        });
    }

    public NodeIndexLeafPlanner apply(Seq<NodeIndexPlanProvider> planProviders, LeafPlanRestrictions restrictions) {
        return new NodeIndexLeafPlanner(planProviders, restrictions);
    }

    public Option<Tuple2<Seq<NodeIndexPlanProvider>, LeafPlanRestrictions>> unapply(NodeIndexLeafPlanner x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.planProviders(), (Object)x$0.restrictions()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NodeIndexLeafPlanner$.class);
    }

    public static final /* synthetic */ boolean $anonfun$findIndexMatchesForQueryGraph$3(String label$1, LabelName x$3) {
        String string = x$3.name();
        String string2 = label$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findIndexMatchesForQueryGraph$2(String label$1, HasLabels x$2) {
        return x$2.labels().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)NodeIndexLeafPlanner$.$anonfun$findIndexMatchesForQueryGraph$3(label$1, x$3)));
    }

    private static final boolean labelIsAlreadyExplicitOnNode$1(String label, LogicalVariable variable, Map allLabelPredicatesMap$1) {
        return allLabelPredicatesMap$1.get((Object)variable).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)NodeIndexLeafPlanner$.$anonfun$findIndexMatchesForQueryGraph$2(label$1, x$2)))));
    }

    public static final /* synthetic */ boolean $anonfun$findIndexMatchesForQueryGraph$4(PatternRelationship x$4) {
        SemanticDirection semanticDirection = x$4.dir();
        SemanticDirection.BOTH$ bOTH$ = SemanticDirection.BOTH$.MODULE$;
        return semanticDirection == null ? bOTH$ != null : !semanticDirection.equals(bOTH$);
    }

    public static final /* synthetic */ boolean $anonfun$findIndexMatches$3(LabelId check$ifrefutable$1) {
        LabelId labelId = check$ifrefutable$1;
        return labelId != null;
    }

    private NodeIndexLeafPlanner$() {
    }
}

