/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.frontend.phases.BaseContains;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.LabelId$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.RelTypeId$;
import org.neo4j.cypher.internal.util.StepSequencer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.ChainingOps$;
import scala.util.package;

public final class ResolveTokens$
implements Phase<PlannerContext, BaseState, BaseState>,
StepSequencer.Step,
StepSequencer.DefaultPostCondition,
PlanPipelineTransformerFactory,
Product,
Serializable {
    public static final ResolveTokens$ MODULE$ = new ResolveTokens$();
    private static volatile StepSequencer.DefaultPostCondition.completed$ completed$module;

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        StepSequencer.DefaultPostCondition.$init$((StepSequencer.DefaultPostCondition)MODULE$);
        PlanPipelineTransformerFactory.$init$((PlanPipelineTransformerFactory)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Transformer<? extends BaseContext, ? extends BaseState, BaseState> getCheckedTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return PlanPipelineTransformerFactory.getCheckedTransformer$((PlanPipelineTransformerFactory)this, (boolean)pushdownPropertyReads, semanticFeatures);
    }

    public Set<StepSequencer.Condition> postConditions() {
        return StepSequencer.DefaultPostCondition.postConditions$((StepSequencer.DefaultPostCondition)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public void phaseValidation(Object from, Object to) {
        Phase.phaseValidation$((Phase)this, (Object)from, (Object)to);
    }

    public <D extends PlannerContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final void checkConditions(Object state, Set<StepSequencer.Condition> conditions, CancellationChecker cancellationChecker) {
        Transformer.checkConditions$((Transformer)this, (Object)state, conditions, (CancellationChecker)cancellationChecker);
    }

    public final void printDebugInfo(Object fromState, Object toState) {
        Transformer.printDebugInfo$((Transformer)this, (Object)fromState, (Object)toState);
    }

    public StepSequencer.DefaultPostCondition.completed$ completed() {
        if (completed$module == null) {
            this.completed$lzycompute$1();
        }
        return completed$module;
    }

    public SemanticTable resolve(Query ast, SemanticTable semanticTable, PlanContext planContext) {
        return (SemanticTable)ast.folder().fold((Object)semanticTable, (PartialFunction)new Serializable(planContext){
            private static final long serialVersionUID = 0L;
            private final PlanContext planContext$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PropertyKeyName) {
                    PropertyKeyName propertyKeyName = (PropertyKeyName)A1;
                    return (B1)(Function1 & Serializable)acc -> ResolveTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolvePropertyKeyName(propertyKeyName.name(), (SemanticTable)acc, (ReadTokenContext)$this.planContext$1);
                }
                if (A1 instanceof LabelName) {
                    LabelName labelName = (LabelName)A1;
                    return (B1)(Function1 & Serializable)acc -> (SemanticTable)ChainingOps$.MODULE$.pipe$extension(package.chaining$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(package.chaining$.MODULE$.scalaUtilChainingOps(acc), (Function1 & Serializable)x$1 -> ResolveTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveLabelName(labelName.name(), (SemanticTable)x$1, (ReadTokenContext)$this.planContext$1))), (Function1 & Serializable)x$2 -> ResolveTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveImpliedLabelNames(labelName.name(), (SemanticTable)x$2, $this.planContext$1));
                }
                if (A1 instanceof RelTypeName) {
                    RelTypeName relTypeName = (RelTypeName)A1;
                    return (B1)(Function1 & Serializable)acc -> ResolveTokens$.MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveRelTypeName(relTypeName.name(), (SemanticTable)acc, (ReadTokenContext)$this.planContext$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof PropertyKeyName) {
                    return true;
                }
                if (object instanceof LabelName) {
                    return true;
                }
                return object instanceof RelTypeName;
            }
            {
                this.planContext$1 = planContext$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.compiler.planner.ResolveTokens$$anonfun$resolve$1 org.neo4j.cypher.internal.expressions.PropertyKeyName org.neo4j.cypher.internal.ast.semantics.SemanticTable ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.compiler.planner.ResolveTokens$$anonfun$resolve$1 org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.ast.semantics.SemanticTable ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.compiler.planner.ResolveTokens$$anonfun$resolve$1 org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.ast.semantics.SemanticTable ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.compiler.planner.ResolveTokens$$anonfun$resolve$1 org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.ast.semantics.SemanticTable ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.compiler.planner.ResolveTokens$$anonfun$resolve$1 org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.ast.semantics.SemanticTable )}, serializedLambda);
            }
        });
    }

    public SemanticTable org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolvePropertyKeyName(String name, SemanticTable semanticTable, ReadTokenContext tokenContext) {
        Option option = tokenContext.getOptPropertyKeyId(name).map((Function1)PropertyKeyId$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            PropertyKeyId id = (PropertyKeyId)some.value();
            return semanticTable.addResolvedPropertyKeyName(name, id);
        }
        if (None$.MODULE$.equals(option)) {
            return semanticTable;
        }
        throw new MatchError((Object)option);
    }

    public SemanticTable org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveLabelName(String name, SemanticTable semanticTable, ReadTokenContext tokenContext) {
        Option option = tokenContext.getOptLabelId(name).map((Function1)LabelId$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            LabelId id = (LabelId)some.value();
            return semanticTable.addResolvedLabelName(name, id);
        }
        if (None$.MODULE$.equals(option)) {
            return semanticTable;
        }
        throw new MatchError((Object)option);
    }

    public SemanticTable org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveImpliedLabelNames(String constrainedLabel, SemanticTable semanticTable, PlanContext planContext) {
        Set impliedLabels = planContext.getNodeLabelConstraints(constrainedLabel);
        return (SemanticTable)impliedLabels.foldLeft((Object)semanticTable, (Function2 & Serializable)(acc, l) -> MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveLabelName((String)l, (SemanticTable)acc, (ReadTokenContext)planContext));
    }

    public SemanticTable org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolveRelTypeName(String name, SemanticTable semanticTable, ReadTokenContext tokenContext) {
        Option option = tokenContext.getOptRelTypeId(name).map((Function1)RelTypeId$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            RelTypeId id = (RelTypeId)some.value();
            return semanticTable.addResolvedRelTypeName(name, id);
        }
        if (None$.MODULE$.equals(option)) {
            return semanticTable;
        }
        throw new MatchError((Object)option);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.AST_REWRITE;
    }

    public BaseState process(BaseState from, PlannerContext context) {
        SemanticTable semanticTable;
        Statement statement = from.statement();
        if (statement instanceof Query) {
            Query query = (Query)statement;
            semanticTable = this.resolve(query, from.semanticTable(), context.planContext());
        } else {
            semanticTable = from.semanticTable();
        }
        SemanticTable semTab1 = semanticTable;
        SemanticTable result = (SemanticTable)context.planContext().getPropertiesWithExistenceConstraint().foldLeft((Object)semTab1, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                SemanticTable acc = (SemanticTable)tuple2._1();
                String name = (String)tuple2._2();
                return MODULE$.org$neo4j$cypher$internal$compiler$planner$ResolveTokens$$resolvePropertyKeyName(name, acc, (ReadTokenContext)context.planContext());
            }
            throw new MatchError((Object)tuple2);
        });
        return from.withSemanticTable(result);
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new BaseContains(ClassTag$.MODULE$.apply(SemanticTable.class)), new BaseContains(ClassTag$.MODULE$.apply(Statement.class))}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public ResolveTokens$ getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    public String productPrefix() {
        return "ResolveTokens";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ResolveTokens$;
    }

    public int hashCode() {
        return 549913222;
    }

    public String toString() {
        return "ResolveTokens";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResolveTokens$.class);
    }

    private final void completed$lzycompute$1() {
        ResolveTokens$ resolveTokens$ = this;
        synchronized (resolveTokens$) {
            if (completed$module == null) {
                completed$module = new StepSequencer.DefaultPostCondition.completed$((StepSequencer.DefaultPostCondition)this);
            }
        }
    }

    private ResolveTokens$() {
    }
}

