/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.expressions.Ands;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.FunctionName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LabelToken;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.LogicalProperty;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.ir.CreateNode;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.ShortestPathPattern;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.VarPatternLength;
import org.neo4j.cypher.internal.logical.plans.Aggregation;
import org.neo4j.cypher.internal.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.logical.plans.AntiConditionalApply;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.Bound;
import org.neo4j.cypher.internal.logical.plans.CacheProperties;
import org.neo4j.cypher.internal.logical.plans.ColumnOrder;
import org.neo4j.cypher.internal.logical.plans.CompositeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.ConditionalApply;
import org.neo4j.cypher.internal.logical.plans.Create;
import org.neo4j.cypher.internal.logical.plans.DeleteNode;
import org.neo4j.cypher.internal.logical.plans.DeleteRelationship;
import org.neo4j.cypher.internal.logical.plans.DetachDeleteNode;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.Distinct;
import org.neo4j.cypher.internal.logical.plans.ErrorPlan;
import org.neo4j.cypher.internal.logical.plans.ExclusiveBound;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.ExpandAll$;
import org.neo4j.cypher.internal.logical.plans.ExpansionMode;
import org.neo4j.cypher.internal.logical.plans.FindShortestPaths;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.logical.plans.InclusiveBound;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexSeekLeafPlan;
import org.neo4j.cypher.internal.logical.plans.IndexedProperty;
import org.neo4j.cypher.internal.logical.plans.InequalitySeekRange;
import org.neo4j.cypher.internal.logical.plans.InequalitySeekRangeWrapper;
import org.neo4j.cypher.internal.logical.plans.Input;
import org.neo4j.cypher.internal.logical.plans.LeftOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.LetAntiSemiApply;
import org.neo4j.cypher.internal.logical.plans.LetSelectOrAntiSemiApply;
import org.neo4j.cypher.internal.logical.plans.LetSelectOrSemiApply;
import org.neo4j.cypher.internal.logical.plans.LetSemiApply;
import org.neo4j.cypher.internal.logical.plans.Limit;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanToPlanBuilderString;
import org.neo4j.cypher.internal.logical.plans.ManyQueryExpression;
import org.neo4j.cypher.internal.logical.plans.ManySeekableArgs;
import org.neo4j.cypher.internal.logical.plans.MultiNodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeByIdSeek;
import org.neo4j.cypher.internal.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.logical.plans.NodeCountFromCountStore;
import org.neo4j.cypher.internal.logical.plans.NodeHashJoin;
import org.neo4j.cypher.internal.logical.plans.NodeIndexContainsScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexEndsWithScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueIndexSeek;
import org.neo4j.cypher.internal.logical.plans.Optional;
import org.neo4j.cypher.internal.logical.plans.OptionalExpand;
import org.neo4j.cypher.internal.logical.plans.OrderedAggregation;
import org.neo4j.cypher.internal.logical.plans.OrderedDistinct;
import org.neo4j.cypher.internal.logical.plans.PartialSort;
import org.neo4j.cypher.internal.logical.plans.PartialTop;
import org.neo4j.cypher.internal.logical.plans.PointDistanceRange;
import org.neo4j.cypher.internal.logical.plans.PointDistanceSeekRangeWrapper;
import org.neo4j.cypher.internal.logical.plans.PrefixRange;
import org.neo4j.cypher.internal.logical.plans.PrefixSeekRangeWrapper;
import org.neo4j.cypher.internal.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.logical.plans.ProduceResult;
import org.neo4j.cypher.internal.logical.plans.ProjectEndpoints;
import org.neo4j.cypher.internal.logical.plans.Projection;
import org.neo4j.cypher.internal.logical.plans.PruningVarExpand;
import org.neo4j.cypher.internal.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.logical.plans.RangeBetween;
import org.neo4j.cypher.internal.logical.plans.RangeGreaterThan;
import org.neo4j.cypher.internal.logical.plans.RangeLessThan;
import org.neo4j.cypher.internal.logical.plans.RangeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.RelationshipCountFromCountStore;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.logical.plans.RightOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.RollUpApply;
import org.neo4j.cypher.internal.logical.plans.SeekableArgs;
import org.neo4j.cypher.internal.logical.plans.SelectOrAntiSemiApply;
import org.neo4j.cypher.internal.logical.plans.SelectOrSemiApply;
import org.neo4j.cypher.internal.logical.plans.Selection;
import org.neo4j.cypher.internal.logical.plans.SetLabels;
import org.neo4j.cypher.internal.logical.plans.SetNodePropertiesFromMap;
import org.neo4j.cypher.internal.logical.plans.SetNodeProperty;
import org.neo4j.cypher.internal.logical.plans.SetProperty;
import org.neo4j.cypher.internal.logical.plans.SetRelationshipPropertiesFromMap;
import org.neo4j.cypher.internal.logical.plans.SetRelationshipProperty;
import org.neo4j.cypher.internal.logical.plans.SingleQueryExpression;
import org.neo4j.cypher.internal.logical.plans.SingleSeekableArg;
import org.neo4j.cypher.internal.logical.plans.Skip;
import org.neo4j.cypher.internal.logical.plans.Sort;
import org.neo4j.cypher.internal.logical.plans.Top;
import org.neo4j.cypher.internal.logical.plans.TriadicBuild;
import org.neo4j.cypher.internal.logical.plans.TriadicFilter;
import org.neo4j.cypher.internal.logical.plans.TriadicSelection;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.UnwindCollection;
import org.neo4j.cypher.internal.logical.plans.ValueHashJoin;
import org.neo4j.cypher.internal.logical.plans.VarExpand;
import org.neo4j.cypher.internal.logical.plans.VariablePredicate;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import org.neo4j.cypher.internal.util.attribution.Id;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

public final class LogicalPlanToPlanBuilderString$ {
    public static LogicalPlanToPlanBuilderString$ MODULE$;
    private final ExpressionStringifier org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier;

    static {
        new LogicalPlanToPlanBuilderString$();
    }

    public ExpressionStringifier org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier() {
        return this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier;
    }

    public String apply(LogicalPlan logicalPlan) {
        return this.render(logicalPlan, (Option<Function1<LogicalPlan, String>>)None$.MODULE$);
    }

    public String apply(LogicalPlan logicalPlan, Function1<LogicalPlan, String> extra) {
        return this.render(logicalPlan, (Option<Function1<LogicalPlan, String>>)new Some(extra));
    }

    private String render(LogicalPlan logicalPlan, Option<Function1<LogicalPlan, String>> extra) {
        BoxedUnit boxedUnit;
        LogicalPlanToPlanBuilderString.LevelPlanItem levelPlanItem = new LogicalPlanToPlanBuilderString.LevelPlanItem(0, logicalPlan);
        ObjectRef childrenStack = ObjectRef.create((Object)Nil$.MODULE$.$colon$colon((Object)levelPlanItem));
        StringBuilder sb = new StringBuilder();
        while (((List)childrenStack.elem).nonEmpty()) {
            LogicalPlanToPlanBuilderString.LevelPlanItem levelPlanItem2 = (LogicalPlanToPlanBuilderString.LevelPlanItem)((List)childrenStack.elem).head();
            if (levelPlanItem2 == null) {
                throw new MatchError((Object)levelPlanItem2);
            }
            int level = levelPlanItem2.level();
            LogicalPlan plan = levelPlanItem2.plan();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)level), (Object)plan);
            Tuple2 tuple22 = tuple2;
            int level2 = tuple22._1$mcI$sp();
            LogicalPlan plan2 = (LogicalPlan)tuple22._2();
            childrenStack.elem = (List)((List)childrenStack.elem).tail();
            sb.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString(".|")).$times(level2));
            sb.$plus$eq('.');
            sb.$plus$plus$eq(this.pre(plan2));
            sb.$plus$eq('(');
            sb.$plus$plus$eq(this.par(plan2));
            sb.$plus$eq(')');
            extra.foreach((Function1 & Serializable & scala.Serializable)e -> sb.$plus$plus$eq((String)e.apply((Object)plan2)));
            plan2.lhs().foreach((Function1 & Serializable & scala.Serializable)lhs -> {
                childrenStack.elem = ((List)childrenStack.elem).$colon$colon((Object)new LogicalPlanToPlanBuilderString.LevelPlanItem(level2, lhs));
                return BoxedUnit.UNIT;
            });
            plan2.rhs().foreach((Function1 & Serializable & scala.Serializable)rhs -> {
                childrenStack.elem = ((List)childrenStack.elem).$colon$colon((Object)new LogicalPlanToPlanBuilderString.LevelPlanItem(level2 + 1, rhs));
                return BoxedUnit.UNIT;
            });
            Object object = ((List)childrenStack.elem).nonEmpty() ? sb.$plus$plus$eq(System.lineSeparator()) : BoxedUnit.UNIT;
        }
        if (extra.isEmpty()) {
            sb.$plus$plus$eq(System.lineSeparator());
            boxedUnit = sb.$plus$plus$eq(".build()");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private String pre(LogicalPlan logicalPlan2) {
        scala.Serializable specialCases = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                NodeIndexSeek nodeIndexSeek = null;
                A1 A1 = x1;
                if (A1 instanceof ProduceResult) {
                    object = "produceResults";
                    return (B1)object;
                }
                if (A1 instanceof AllNodesScan) {
                    object = "allNodeScan";
                    return (B1)object;
                }
                if (A1 instanceof Expand) {
                    Expand expand = (Expand)A1;
                    ExpansionMode expansionMode = expand.mode();
                    ExpandAll$ expandAll$ = ExpandAll$.MODULE$;
                    object = !(expansionMode != null ? !expansionMode.equals(expandAll$) : expandAll$ != null) ? "expandAll" : "expandInto";
                    return (B1)object;
                }
                if (A1 instanceof VarExpand) {
                    object = "expand";
                    return (B1)object;
                }
                if (A1 instanceof OptionalExpand) {
                    OptionalExpand optionalExpand = (OptionalExpand)A1;
                    ExpansionMode expansionMode = optionalExpand.mode();
                    ExpandAll$ expandAll$ = ExpandAll$.MODULE$;
                    object = !(expansionMode != null ? !expansionMode.equals(expandAll$) : expandAll$ != null) ? "optionalExpandAll" : "optionalExpandInto";
                    return (B1)object;
                }
                if (A1 instanceof Selection) {
                    object = "filter";
                    return (B1)object;
                }
                if (A1 instanceof UnwindCollection) {
                    object = "unwind";
                    return (B1)object;
                }
                if (A1 instanceof FindShortestPaths) {
                    object = "shortestPath";
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexScan) {
                    object = "nodeIndexOperator";
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexSeek) {
                    RangeQueryExpression rangeQueryExpression;
                    Expression expression;
                    bl = true;
                    nodeIndexSeek = (NodeIndexSeek)A1;
                    QueryExpression<Expression> queryExpression = nodeIndexSeek.valueExpr();
                    if (queryExpression instanceof RangeQueryExpression && (expression = (Expression)(rangeQueryExpression = (RangeQueryExpression)queryExpression).expression()) instanceof PointDistanceSeekRangeWrapper) {
                        object = "pointDistanceIndexSeek";
                        return (B1)object;
                    }
                }
                if (bl) {
                    object = "nodeIndexOperator";
                    return (B1)object;
                }
                if (A1 instanceof NodeUniqueIndexSeek) {
                    object = "nodeIndexOperator";
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexContainsScan) {
                    object = "nodeIndexOperator";
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexEndsWithScan) {
                    object = "nodeIndexOperator";
                    return (B1)object;
                }
                if (A1 instanceof MultiNodeIndexSeek) {
                    object = "multiNodeIndexSeekOperator";
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                boolean bl = false;
                NodeIndexSeek nodeIndexSeek = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof ProduceResult) {
                    return true;
                }
                if (logicalPlan instanceof AllNodesScan) {
                    return true;
                }
                if (logicalPlan instanceof Expand) {
                    return true;
                }
                if (logicalPlan instanceof VarExpand) {
                    return true;
                }
                if (logicalPlan instanceof OptionalExpand) {
                    return true;
                }
                if (logicalPlan instanceof Selection) {
                    return true;
                }
                if (logicalPlan instanceof UnwindCollection) {
                    return true;
                }
                if (logicalPlan instanceof FindShortestPaths) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexScan) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexSeek) {
                    RangeQueryExpression rangeQueryExpression;
                    Expression expression;
                    bl = true;
                    nodeIndexSeek = (NodeIndexSeek)logicalPlan;
                    QueryExpression<Expression> queryExpression = nodeIndexSeek.valueExpr();
                    if (queryExpression instanceof RangeQueryExpression && (expression = (Expression)(rangeQueryExpression = (RangeQueryExpression)queryExpression).expression()) instanceof PointDistanceSeekRangeWrapper) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (logicalPlan instanceof NodeUniqueIndexSeek) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexContainsScan) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexEndsWithScan) {
                    return true;
                }
                if (!(logicalPlan instanceof MultiNodeIndexSeek)) return false;
                return true;
            }
        };
        return (String)specialCases.applyOrElse((Object)logicalPlan2, (Function1 & Serializable & scala.Serializable)logicalPlan -> MODULE$.classNameFormat((LogicalPlan)logicalPlan));
    }

    private String classNameFormat(LogicalPlan logicalPlan) {
        char head;
        String className = logicalPlan.getClass().getSimpleName();
        char c = head = Character.toLowerCase(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(className)).head()));
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(className)).tail())).$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c), Predef$.MODULE$.StringCanBuildFrom());
    }

    private String par(LogicalPlan logicalPlan) {
        scala.Serializable plansWithContent = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ProcedureCall procedureCall;
                ResolvedCall resolvedCall;
                Object object;
                boolean bl = false;
                NodeIndexSeek nodeIndexSeek = null;
                A1 A1 = x1;
                if (A1 instanceof Aggregation) {
                    Aggregation aggregation = (Aggregation)A1;
                    Map<String, Expression> groupingExpressions = aggregation.groupingExpressions();
                    Map<String, Expression> aggregationExpression = aggregation.aggregationExpressions();
                    object = new java.lang.StringBuilder(12).append("Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(groupingExpressions)).append("), Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(aggregationExpression)).append(")").toString();
                    return (B1)object;
                }
                if (A1 instanceof OrderedAggregation) {
                    OrderedAggregation orderedAggregation = (OrderedAggregation)A1;
                    Map<String, Expression> groupingExpressions = orderedAggregation.groupingExpressions();
                    Map<String, Expression> aggregationExpression = orderedAggregation.aggregationExpressions();
                    Seq<Expression> orderToLeverage = orderedAggregation.orderToLeverage();
                    object = new java.lang.StringBuilder(19).append("Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(groupingExpressions)).append("), Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(aggregationExpression)).append("), Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)orderToLeverage.map((Function1 & Serializable & scala.Serializable)x$5 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$5), Seq$.MODULE$.canBuildFrom())))).append(")").toString();
                    return (B1)object;
                }
                if (A1 instanceof Distinct) {
                    Distinct distinct = (Distinct)A1;
                    Map<String, Expression> groupingExpressions = distinct.groupingExpressions();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(groupingExpressions);
                    return (B1)object;
                }
                if (A1 instanceof OrderedDistinct) {
                    OrderedDistinct orderedDistinct = (OrderedDistinct)A1;
                    Map<String, Expression> groupingExpressions = orderedDistinct.groupingExpressions();
                    Seq<Expression> orderToLeverage = orderedDistinct.orderToLeverage();
                    object = new java.lang.StringBuilder(9).append(" Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)orderToLeverage.map((Function1 & Serializable & scala.Serializable)x$6 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$6), Seq$.MODULE$.canBuildFrom())))).append("), ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(groupingExpressions)).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof Projection) {
                    Projection projection = (Projection)A1;
                    Map<String, Expression> projectExpressions = projection.projectExpressions();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(projectExpressions);
                    return (B1)object;
                }
                if (A1 instanceof UnwindCollection) {
                    UnwindCollection unwindCollection = (UnwindCollection)A1;
                    String variable = unwindCollection.variable();
                    Expression expression = unwindCollection.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs((Map<String, Expression>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)variable), (Object)expression)}))));
                    return (B1)object;
                }
                if (A1 instanceof AllNodesScan) {
                    AllNodesScan allNodesScan = (AllNodesScan)A1;
                    String idName = allNodesScan.idName();
                    Set<String> argumentIds = allNodesScan.argumentIds();
                    String string = idName;
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)argumentIds.toSeq().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
                    return (B1)object;
                }
                if (A1 instanceof Argument) {
                    Argument argument = (Argument)A1;
                    Set<String> argumentIds = argument.argumentIds();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds.toSeq());
                    return (B1)object;
                }
                if (A1 instanceof CacheProperties) {
                    CacheProperties cacheProperties = (CacheProperties)A1;
                    Set<LogicalProperty> properties = cacheProperties.properties();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)properties.toSeq().map((Function1 & Serializable & scala.Serializable)x$8 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply((Expression)x$8), Seq$.MODULE$.canBuildFrom())));
                    return (B1)object;
                }
                if (A1 instanceof Create) {
                    Create create = (Create)A1;
                    Seq<CreateNode> nodes = create.nodes();
                    object = ((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)createNode -> {
                        String string = createNode.idName();
                        return new java.lang.StringBuilder(12).append("createNode(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)((SeqLike)createNode.labels().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())))).append(")").toString();
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                    return (B1)object;
                }
                if (A1 instanceof Expand) {
                    Expand expand = (Expand)A1;
                    String from = expand.from();
                    SemanticDirection dir = expand.dir();
                    String to = expand.to();
                    String relName = expand.relName();
                    Tuple2<String, String> tuple2 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(dir);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    String dirStrA = (String)tuple2._1();
                    String dirStrB = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple23 = tuple22;
                    String dirStrA2 = (String)tuple23._1();
                    String dirStrB2 = (String)tuple23._2();
                    object = new java.lang.StringBuilder(10).append(" \"(").append(from).append(")").append(dirStrA2).append("[").append(relName).append("]").append(dirStrB2).append("(").append(to).append(")\" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof VarExpand) {
                    VarExpand varExpand = (VarExpand)A1;
                    String from = varExpand.from();
                    SemanticDirection dir = varExpand.dir();
                    SemanticDirection pDir = varExpand.projectedDir();
                    Seq<RelTypeName> types = varExpand.types();
                    String to = varExpand.to();
                    String relName = varExpand.relName();
                    VarPatternLength length = varExpand.length();
                    ExpansionMode mode = varExpand.mode();
                    Option<VariablePredicate> nodePredicate = varExpand.nodePredicate();
                    Option<VariablePredicate> relationshipPredicate = varExpand.relationshipPredicate();
                    Tuple2<String, String> tuple2 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(dir);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    String dirStrA = (String)tuple2._1();
                    String dirStrB = (String)tuple2._2();
                    Tuple2 tuple24 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple25 = tuple24;
                    String dirStrA3 = (String)tuple25._1();
                    String dirStrB3 = (String)tuple25._2();
                    String typeStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$relTypeStr(types);
                    String lenStr = new java.lang.StringBuilder(2).append(length.min()).append("..").append(length.max().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                    String modeStr = new java.lang.StringBuilder(15).append(", expandMode = ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(mode)).toString();
                    String pDirStr = new java.lang.StringBuilder(17).append(", projectedDir = ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(pDir)).toString();
                    String nPredStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$variablePredicate(nodePredicate, "nodePredicate");
                    String rPredStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$variablePredicate(relationshipPredicate, "relationshipPredicate");
                    object = new java.lang.StringBuilder(11).append(" \"(").append(from).append(")").append(dirStrA3).append("[").append(relName).append(typeStr).append("*").append(lenStr).append("]").append(dirStrB3).append("(").append(to).append(")\"").append(modeStr).append(pDirStr).append(nPredStr).append(rPredStr).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof FindShortestPaths) {
                    FindShortestPaths findShortestPaths = (FindShortestPaths)A1;
                    ShortestPathPattern shortestPath = findShortestPaths.shortestPath();
                    Seq<Expression> predicates = findShortestPaths.predicates();
                    boolean withFallBack = findShortestPaths.withFallBack();
                    boolean disallowSameNode = findShortestPaths.disallowSameNode();
                    String fbStr = withFallBack ? ", withFallback = true" : "";
                    String dsnStr = !disallowSameNode ? ", disallowSameNode = false" : "";
                    ShortestPathPattern shortestPathPattern = shortestPath;
                    if (shortestPathPattern == null) throw new MatchError((Object)shortestPathPattern);
                    Option maybePathName = shortestPathPattern.name();
                    PatternRelationship patternRelationship = shortestPathPattern.rel();
                    boolean single = shortestPathPattern.single();
                    if (patternRelationship == null) throw new MatchError((Object)shortestPathPattern);
                    String relName = patternRelationship.name();
                    Tuple2 tuple2 = patternRelationship.nodes();
                    SemanticDirection dir = patternRelationship.dir();
                    Seq types = patternRelationship.types();
                    PatternLength length = patternRelationship.length();
                    if (tuple2 == null) throw new MatchError((Object)shortestPathPattern);
                    String from = (String)tuple2._1();
                    String to = (String)tuple2._2();
                    PatternLength patternLength = length;
                    if (!(patternLength instanceof VarPatternLength)) throw new IllegalStateException("Shortest path should have a variable length pattern");
                    VarPatternLength varPatternLength = (VarPatternLength)patternLength;
                    int min = varPatternLength.min();
                    Option max = varPatternLength.max();
                    String string = new java.lang.StringBuilder(2).append(min).append("..").append(max.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                    String lenStr = string;
                    Tuple2<String, String> tuple26 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(dir);
                    if (tuple26 == null) throw new MatchError(tuple26);
                    String dirStrA = (String)tuple26._1();
                    String dirStrB = (String)tuple26._2();
                    Tuple2 tuple27 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple28 = tuple27;
                    String dirStrA4 = (String)tuple28._1();
                    String dirStrB4 = (String)tuple28._2();
                    String typeStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$relTypeStr((Seq<RelTypeName>)types);
                    String pNameStr = (String)maybePathName.map((Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(19).append(", pathName = Some(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations((String)p)).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    String allStr = single ? "" : ", all = true";
                    String predStr = predicates.isEmpty() ? "" : new java.lang.StringBuilder(20).append(", predicates = Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)predicates.map((Function1 & Serializable & scala.Serializable)x$14 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$14), Seq$.MODULE$.canBuildFrom())))).append(")").toString();
                    String string2 = new java.lang.StringBuilder(11).append(" \"(").append(from).append(")").append(dirStrA4).append("[").append(relName).append(typeStr).append("*").append(lenStr).append("]").append(dirStrB4).append("(").append(to).append(")\"").append(pNameStr).append(allStr).append(predStr).append(fbStr).append(dsnStr).append(" ").toString().trim();
                    object = string2;
                    return (B1)object;
                }
                if (A1 instanceof PruningVarExpand) {
                    PruningVarExpand pruningVarExpand = (PruningVarExpand)A1;
                    String from = pruningVarExpand.from();
                    SemanticDirection dir = pruningVarExpand.dir();
                    Seq<RelTypeName> types = pruningVarExpand.types();
                    String to = pruningVarExpand.to();
                    int minLength = pruningVarExpand.minLength();
                    int maxLength = pruningVarExpand.maxLength();
                    Option<VariablePredicate> nodePredicate = pruningVarExpand.nodePredicate();
                    Option<VariablePredicate> relationshipPredicate = pruningVarExpand.relationshipPredicate();
                    Tuple2<String, String> tuple2 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(dir);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    String dirStrA = (String)tuple2._1();
                    String dirStrB = (String)tuple2._2();
                    Tuple2 tuple29 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple210 = tuple29;
                    String dirStrA5 = (String)tuple210._1();
                    String dirStrB5 = (String)tuple210._2();
                    String typeStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$relTypeStr(types);
                    String lenStr = new java.lang.StringBuilder(2).append(minLength).append("..").append(maxLength).toString();
                    String nPredStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$variablePredicate(nodePredicate, "nodePredicate");
                    String rPredStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$variablePredicate(relationshipPredicate, "relationshipPredicate");
                    object = new java.lang.StringBuilder(11).append(" \"(").append(from).append(")").append(dirStrA5).append("[").append(typeStr).append("*").append(lenStr).append("]").append(dirStrB5).append("(").append(to).append(")\"").append(nPredStr).append(rPredStr).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof Limit) {
                    Limit limit = (Limit)A1;
                    Expression count = limit.count();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$integerString(count);
                    return (B1)object;
                }
                if (A1 instanceof Skip) {
                    Skip skip = (Skip)A1;
                    Expression count = skip.count();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$integerString(count);
                    return (B1)object;
                }
                if (A1 instanceof NodeByLabelScan) {
                    NodeByLabelScan nodeByLabelScan = (NodeByLabelScan)A1;
                    String idName = nodeByLabelScan.idName();
                    LabelName label = nodeByLabelScan.label();
                    Set<String> argumentIds = nodeByLabelScan.argumentIds();
                    IndexOrder indexOrder = nodeByLabelScan.indexOrder();
                    Seq args = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, label.name()}))).map((Function1 & Serializable & scala.Serializable)c -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations((String)c), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(indexOrder)})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)argumentIds.map((Function1 & Serializable & scala.Serializable)c -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations((String)c), Set$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    object = args.mkString(", ");
                    return (B1)object;
                }
                if (A1 instanceof Optional) {
                    Optional optional = (Optional)A1;
                    Set<String> protectedSymbols = optional.protectedSymbols();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)protectedSymbols);
                    return (B1)object;
                }
                if (A1 instanceof OptionalExpand) {
                    OptionalExpand optionalExpand = (OptionalExpand)A1;
                    String from = optionalExpand.from();
                    SemanticDirection dir = optionalExpand.dir();
                    String to = optionalExpand.to();
                    String relName = optionalExpand.relName();
                    Option<Expression> predicate = optionalExpand.predicate();
                    Tuple2<String, String> tuple2 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(dir);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    String dirStrA = (String)tuple2._1();
                    String dirStrB = (String)tuple2._2();
                    Tuple2 tuple211 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple212 = tuple211;
                    String dirStrA6 = (String)tuple212._1();
                    String dirStrB6 = (String)tuple212._2();
                    String predStr = (String)predicate.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(10).append(", Some(\"").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(p)).append("\")").toString());
                    object = new java.lang.StringBuilder(9).append(" \"(").append(from).append(")").append(dirStrA6).append("[").append(relName).append("]").append(dirStrB6).append("(").append(to).append(")\"").append(predStr).toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof ProcedureCall && (resolvedCall = (procedureCall = (ProcedureCall)A1).call()) != null) {
                    QualifiedName qualifiedName;
                    ProcedureSignature procedureSignature = resolvedCall.signature();
                    Seq<Expression> callArguments = resolvedCall.callArguments();
                    IndexedSeq<ProcedureResultItem> callResults = resolvedCall.callResults();
                    if (procedureSignature != null && (qualifiedName = procedureSignature.name()) != null) {
                        Seq<String> namespace = qualifiedName.namespace();
                        String name = qualifiedName.name();
                        String yielding = callResults.isEmpty() ? "" : ((TraversableOnce)callResults.map((Function1 & Serializable & scala.Serializable)i -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply((Expression)i.variable()), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" YIELD ", ",", "");
                        object = new java.lang.StringBuilder(7).append(" \"").append(namespace.mkString(".")).append(".").append(name).append("(").append(((TraversableOnce)callArguments.map((Function1 & Serializable & scala.Serializable)x$17 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$17), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").append(yielding).append("\" ").toString().trim();
                        return (B1)object;
                    }
                }
                if (A1 instanceof ProduceResult) {
                    ProduceResult produceResult = (ProduceResult)A1;
                    Seq<String> columns = produceResult.columns();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)columns);
                    return (B1)object;
                }
                if (A1 instanceof ProjectEndpoints) {
                    String string;
                    ProjectEndpoints projectEndpoints = (ProjectEndpoints)A1;
                    String relName = projectEndpoints.rel();
                    String start = projectEndpoints.start();
                    boolean startInScope = projectEndpoints.startInScope();
                    String end = projectEndpoints.end();
                    boolean endInScope = projectEndpoints.endInScope();
                    Option<Seq<RelTypeName>> types = projectEndpoints.types();
                    boolean directed = projectEndpoints.directed();
                    PatternLength length = projectEndpoints.length();
                    Tuple2<String, String> tuple2 = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows((SemanticDirection)(directed ? SemanticDirection.OUTGOING$.MODULE$ : SemanticDirection.BOTH$.MODULE$));
                    if (tuple2 == null) throw new MatchError(tuple2);
                    String dirStrA = (String)tuple2._1();
                    String dirStrB = (String)tuple2._2();
                    Tuple2 tuple213 = new Tuple2((Object)dirStrA, (Object)dirStrB);
                    Tuple2 tuple214 = tuple213;
                    String dirStrA7 = (String)tuple214._1();
                    String dirStrB7 = (String)tuple214._2();
                    String typeStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$relTypeStr((Seq<RelTypeName>)((Seq)types.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())));
                    PatternLength patternLength = length;
                    if (SimplePatternLength$.MODULE$.equals(patternLength)) {
                        string = "";
                    } else {
                        if (!(patternLength instanceof VarPatternLength)) throw new MatchError((Object)patternLength);
                        VarPatternLength varPatternLength = (VarPatternLength)patternLength;
                        int min = varPatternLength.min();
                        Option max = varPatternLength.max();
                        string = new java.lang.StringBuilder(3).append("*").append(min).append("..").append(max.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                    }
                    String lenStr = string;
                    object = new java.lang.StringBuilder(14).append(" \"(").append(start).append(")").append(dirStrA7).append("[").append(relName).append(typeStr).append(lenStr).append("]").append(dirStrB7).append("(").append(end).append(")\", ").append(startInScope).append(", ").append(endInScope).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof ValueHashJoin) {
                    ValueHashJoin valueHashJoin = (ValueHashJoin)A1;
                    Equals join = valueHashJoin.join();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply((Expression)join));
                    return (B1)object;
                }
                if (A1 instanceof NodeHashJoin) {
                    NodeHashJoin nodeHashJoin = (NodeHashJoin)A1;
                    Set<String> nodes = nodeHashJoin.nodes();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)nodes);
                    return (B1)object;
                }
                if (A1 instanceof RightOuterHashJoin) {
                    RightOuterHashJoin rightOuterHashJoin = (RightOuterHashJoin)A1;
                    Set<String> nodes = rightOuterHashJoin.nodes();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)nodes);
                    return (B1)object;
                }
                if (A1 instanceof LeftOuterHashJoin) {
                    LeftOuterHashJoin leftOuterHashJoin = (LeftOuterHashJoin)A1;
                    Set<String> nodes = leftOuterHashJoin.nodes();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)nodes);
                    return (B1)object;
                }
                if (A1 instanceof Sort) {
                    Sort sort = (Sort)A1;
                    Seq<ColumnOrder> sortItems = sort.sortItems();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(sortItems);
                    return (B1)object;
                }
                if (A1 instanceof Top) {
                    Top top = (Top)A1;
                    Seq<ColumnOrder> sortItems = top.sortItems();
                    Expression limit = top.limit();
                    String siStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(sortItems);
                    String lStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$integerString(limit);
                    object = new java.lang.StringBuilder(4).append(" ").append(siStr).append(", ").append(lStr).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof PartialSort) {
                    PartialSort partialSort = (PartialSort)A1;
                    Seq<ColumnOrder> alreadySortedPrefix = partialSort.alreadySortedPrefix();
                    Seq<ColumnOrder> stillToSortSuffix = partialSort.stillToSortSuffix();
                    String asStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(alreadySortedPrefix);
                    String stsStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(stillToSortSuffix);
                    object = new java.lang.StringBuilder(4).append(" ").append(asStr).append(", ").append(stsStr).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof PartialTop) {
                    PartialTop partialTop = (PartialTop)A1;
                    Seq<ColumnOrder> alreadySortedPrefix = partialTop.alreadySortedPrefix();
                    Seq<ColumnOrder> stillToSortSuffix = partialTop.stillToSortSuffix();
                    Expression limit = partialTop.limit();
                    String asStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(alreadySortedPrefix);
                    String stsStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(stillToSortSuffix);
                    String lStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$integerString(limit);
                    object = new java.lang.StringBuilder(6).append(" ").append(asStr).append(", ").append(stsStr).append(", ").append(lStr).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof ErrorPlan) {
                    ErrorPlan errorPlan = (ErrorPlan)A1;
                    Exception exception = errorPlan.exception();
                    object = new java.lang.StringBuilder(6).append("new ").append(exception.getClass().getSimpleName()).append("()").toString();
                    return (B1)object;
                }
                if (A1 instanceof Input) {
                    Input input = (Input)A1;
                    Seq<String> nodes = input.nodes();
                    Seq<String> rels = input.relationships();
                    Seq<String> vars = input.variables();
                    boolean nullable = input.nullable();
                    object = new java.lang.StringBuilder(24).append(" Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)nodes)).append("), Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)rels)).append("), Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)vars)).append("), ").append(nullable).append("  ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof RelationshipCountFromCountStore) {
                    RelationshipCountFromCountStore relationshipCountFromCountStore = (RelationshipCountFromCountStore)A1;
                    String idName = relationshipCountFromCountStore.idName();
                    Option<LabelName> startLabel = relationshipCountFromCountStore.startLabel();
                    Seq<RelTypeName> typeNames = relationshipCountFromCountStore.typeNames();
                    Option<LabelName> endLabel = relationshipCountFromCountStore.endLabel();
                    Set<String> argumentIds = relationshipCountFromCountStore.argumentIds();
                    String args = argumentIds.isEmpty() ? "" : new java.lang.StringBuilder(2).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds.toSeq())).toString();
                    object = new java.lang.StringBuilder(15).append(" \"").append(idName).append("\", ").append(startLabel.map((Function1 & Serializable & scala.Serializable)l -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(l.name()))).append(", Seq(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)typeNames.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), Seq$.MODULE$.canBuildFrom())))).append("), ").append(endLabel.map((Function1 & Serializable & scala.Serializable)l -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(l.name()))).append(args).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof NodeCountFromCountStore) {
                    NodeCountFromCountStore nodeCountFromCountStore = (NodeCountFromCountStore)A1;
                    String idName = nodeCountFromCountStore.idName();
                    List<Option<LabelName>> labelNames = nodeCountFromCountStore.labelNames();
                    Set<String> argumentIds = nodeCountFromCountStore.argumentIds();
                    String args = argumentIds.isEmpty() ? "" : new java.lang.StringBuilder(2).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds.toSeq())).toString();
                    String labelStr = ((TraversableOnce)labelNames.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.map((Function1 & Serializable & scala.Serializable)l -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(l.name())).toString(), List$.MODULE$.canBuildFrom())).mkString(", ");
                    object = new java.lang.StringBuilder(11).append(" \"").append(idName).append("\", Seq(").append(labelStr).append(")").append(args).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof DetachDeleteNode) {
                    DetachDeleteNode detachDeleteNode = (DetachDeleteNode)A1;
                    Expression expression = detachDeleteNode.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression));
                    return (B1)object;
                }
                if (A1 instanceof DeleteRelationship) {
                    DeleteRelationship deleteRelationship = (DeleteRelationship)A1;
                    Expression expression = deleteRelationship.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression));
                    return (B1)object;
                }
                if (A1 instanceof SetProperty) {
                    SetProperty setProperty = (SetProperty)A1;
                    Expression entity = setProperty.entity();
                    PropertyKeyName propertyKey = setProperty.propertyKey();
                    Expression value = setProperty.value();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(entity), propertyKey.name(), LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(value)}))));
                    return (B1)object;
                }
                if (A1 instanceof SetNodeProperty) {
                    SetNodeProperty setNodeProperty = (SetNodeProperty)A1;
                    String idName = setNodeProperty.idName();
                    PropertyKeyName propertyKey = setNodeProperty.propertyKey();
                    Expression value = setNodeProperty.value();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, propertyKey.name(), LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(value)}))));
                    return (B1)object;
                }
                if (A1 instanceof SetRelationshipProperty) {
                    SetRelationshipProperty setRelationshipProperty = (SetRelationshipProperty)A1;
                    String idName = setRelationshipProperty.idName();
                    PropertyKeyName propertyKey = setRelationshipProperty.propertyKey();
                    Expression value = setRelationshipProperty.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, propertyKey.name(), LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(value)}))));
                    return (B1)object;
                }
                if (A1 instanceof SetNodePropertiesFromMap) {
                    SetNodePropertiesFromMap setNodePropertiesFromMap = (SetNodePropertiesFromMap)A1;
                    String idName = setNodePropertiesFromMap.idName();
                    Expression expression = setNodePropertiesFromMap.expression();
                    boolean removeOtherProps = setNodePropertiesFromMap.removeOtherProps();
                    object = new java.lang.StringBuilder(4).append(" ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)}))))).append(", ").append(removeOtherProps).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof SetRelationshipPropertiesFromMap) {
                    SetRelationshipPropertiesFromMap setRelationshipPropertiesFromMap = (SetRelationshipPropertiesFromMap)A1;
                    String idName = setRelationshipPropertiesFromMap.idName();
                    Expression expression = setRelationshipPropertiesFromMap.expression();
                    boolean removeOtherProps = setRelationshipPropertiesFromMap.removeOtherProps();
                    object = new java.lang.StringBuilder(4).append(" ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)}))))).append(", ").append(removeOtherProps).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof SetLabels) {
                    SetLabels setLabels = (SetLabels)A1;
                    String idName = setLabels.idName();
                    Seq<LabelName> labelNames = setLabels.labelNames();
                    String string = idName;
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)((SeqLike)labelNames.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.name(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
                    return (B1)object;
                }
                if (A1 instanceof Selection) {
                    Selection selection = (Selection)A1;
                    Ands ands = selection.predicate();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)ands.exprs().map((Function1 & Serializable & scala.Serializable)x$23 -> LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$23), Seq$.MODULE$.canBuildFrom())));
                    return (B1)object;
                }
                if (A1 instanceof SelectOrSemiApply) {
                    SelectOrSemiApply selectOrSemiApply = (SelectOrSemiApply)A1;
                    Expression predicate = selectOrSemiApply.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(predicate));
                    return (B1)object;
                }
                if (A1 instanceof LetSelectOrSemiApply) {
                    LetSelectOrSemiApply letSelectOrSemiApply = (LetSelectOrSemiApply)A1;
                    String idName = letSelectOrSemiApply.idName();
                    Expression predicate = letSelectOrSemiApply.expr();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(predicate)}))));
                    return (B1)object;
                }
                if (A1 instanceof SelectOrAntiSemiApply) {
                    SelectOrAntiSemiApply selectOrAntiSemiApply = (SelectOrAntiSemiApply)A1;
                    Expression predicate = selectOrAntiSemiApply.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(predicate));
                    return (B1)object;
                }
                if (A1 instanceof LetSelectOrAntiSemiApply) {
                    LetSelectOrAntiSemiApply letSelectOrAntiSemiApply = (LetSelectOrAntiSemiApply)A1;
                    String idName = letSelectOrAntiSemiApply.idName();
                    Expression predicate = letSelectOrAntiSemiApply.expr();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(predicate)}))));
                    return (B1)object;
                }
                if (A1 instanceof NodeByIdSeek) {
                    NodeByIdSeek nodeByIdSeek = (NodeByIdSeek)A1;
                    String idName = nodeByIdSeek.idName();
                    SeekableArgs ids = nodeByIdSeek.nodeIds();
                    Set<String> argumentIds = nodeByIdSeek.argumentIds();
                    String idsString = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$idsStr(ids);
                    object = new java.lang.StringBuilder(11).append(" ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(idName)).append(", Set(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds)).append("), ").append(idsString).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof UndirectedRelationshipByIdSeek) {
                    UndirectedRelationshipByIdSeek undirectedRelationshipByIdSeek = (UndirectedRelationshipByIdSeek)A1;
                    String idName = undirectedRelationshipByIdSeek.idName();
                    SeekableArgs ids = undirectedRelationshipByIdSeek.relIds();
                    String leftNode = undirectedRelationshipByIdSeek.leftNode();
                    String rightNode = undirectedRelationshipByIdSeek.rightNode();
                    Set<String> argumentIds = undirectedRelationshipByIdSeek.argumentIds();
                    String idsString = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$idsStr(ids);
                    object = new java.lang.StringBuilder(11).append(" ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, leftNode, rightNode}))))).append(", Set(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds)).append("), ").append(idsString).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof DirectedRelationshipByIdSeek) {
                    DirectedRelationshipByIdSeek directedRelationshipByIdSeek = (DirectedRelationshipByIdSeek)A1;
                    String idName = directedRelationshipByIdSeek.idName();
                    SeekableArgs ids = directedRelationshipByIdSeek.relIds();
                    String leftNode = directedRelationshipByIdSeek.startNode();
                    String rightNode = directedRelationshipByIdSeek.endNode();
                    Set<String> argumentIds = directedRelationshipByIdSeek.argumentIds();
                    String idsString = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$idsStr(ids);
                    object = new java.lang.StringBuilder(11).append(" ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idName, leftNode, rightNode}))))).append(", Set(").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds)).append("), ").append(idsString).append(" ").toString().trim();
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexScan) {
                    NodeIndexScan nodeIndexScan = (NodeIndexScan)A1;
                    String idName = nodeIndexScan.idName();
                    LabelToken labelToken = nodeIndexScan.label();
                    Seq<IndexedProperty> properties = nodeIndexScan.properties();
                    Set<String> argumentIds = nodeIndexScan.argumentIds();
                    IndexOrder indexOrder = nodeIndexScan.indexOrder();
                    Seq propNames = (Seq)properties.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.propertyKeyToken().name(), Seq$.MODULE$.canBuildFrom());
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(idName, labelToken, properties, argumentIds, indexOrder, false, propNames.mkString(", "));
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexContainsScan) {
                    NodeIndexContainsScan nodeIndexContainsScan = (NodeIndexContainsScan)A1;
                    String idName = nodeIndexContainsScan.idName();
                    LabelToken labelToken = nodeIndexContainsScan.label();
                    IndexedProperty property = nodeIndexContainsScan.property();
                    Expression valueExpr = nodeIndexContainsScan.valueExpr();
                    Set<String> argumentIds = nodeIndexContainsScan.argumentIds();
                    IndexOrder indexOrder = nodeIndexContainsScan.indexOrder();
                    String propName = property.propertyKeyToken().name();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(idName, labelToken, (Seq<IndexedProperty>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexedProperty[]{property}))), argumentIds, indexOrder, false, new java.lang.StringBuilder(10).append(propName).append(" CONTAINS ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(valueExpr)).toString());
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexEndsWithScan) {
                    NodeIndexEndsWithScan nodeIndexEndsWithScan = (NodeIndexEndsWithScan)A1;
                    String idName = nodeIndexEndsWithScan.idName();
                    LabelToken labelToken = nodeIndexEndsWithScan.label();
                    IndexedProperty property = nodeIndexEndsWithScan.property();
                    Expression valueExpr = nodeIndexEndsWithScan.valueExpr();
                    Set<String> argumentIds = nodeIndexEndsWithScan.argumentIds();
                    IndexOrder indexOrder = nodeIndexEndsWithScan.indexOrder();
                    String propName = property.propertyKeyToken().name();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(idName, labelToken, (Seq<IndexedProperty>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexedProperty[]{property}))), argumentIds, indexOrder, false, new java.lang.StringBuilder(11).append(propName).append(" ENDS WITH ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(valueExpr)).toString());
                    return (B1)object;
                }
                if (A1 instanceof NodeIndexSeek) {
                    PointDistanceSeekRangeWrapper pointDistanceSeekRangeWrapper;
                    PointDistanceRange<Expression> pointDistanceRange;
                    RangeQueryExpression rangeQueryExpression;
                    Expression expression;
                    bl = true;
                    nodeIndexSeek = (NodeIndexSeek)A1;
                    String idName = nodeIndexSeek.idName();
                    LabelToken labelToken = nodeIndexSeek.label();
                    Seq<IndexedProperty> properties = nodeIndexSeek.properties();
                    QueryExpression<Expression> queryExpression = nodeIndexSeek.valueExpr();
                    Set<String> argumentIds = nodeIndexSeek.argumentIds();
                    IndexOrder indexOrder = nodeIndexSeek.indexOrder();
                    if (queryExpression instanceof RangeQueryExpression && (expression = (Expression)(rangeQueryExpression = (RangeQueryExpression)queryExpression).expression()) instanceof PointDistanceSeekRangeWrapper && (pointDistanceRange = (pointDistanceSeekRangeWrapper = (PointDistanceSeekRangeWrapper)expression).range()) != null) {
                        Expression expression2 = pointDistanceRange.point();
                        Expression distance = pointDistanceRange.distance();
                        boolean inclusive = pointDistanceRange.inclusive();
                        if (expression2 instanceof FunctionInvocation) {
                            String string;
                            FunctionInvocation functionInvocation = (FunctionInvocation)expression2;
                            FunctionName functionName = functionInvocation.functionName();
                            IndexedSeq args = functionInvocation.args();
                            if (functionName != null && "point".equals(string = functionName.name())) {
                                object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$pointDistanceIndexSeek(idName, labelToken, properties, (Expression)args.head(), distance, argumentIds, indexOrder, inclusive);
                                return (B1)object;
                            }
                        }
                    }
                }
                if (bl) {
                    String idName = nodeIndexSeek.idName();
                    LabelToken labelToken = nodeIndexSeek.label();
                    Seq<IndexedProperty> properties = nodeIndexSeek.properties();
                    QueryExpression<Expression> valueExpr = nodeIndexSeek.valueExpr();
                    Set<String> argumentIds = nodeIndexSeek.argumentIds();
                    IndexOrder indexOrder = nodeIndexSeek.indexOrder();
                    Seq propNames = (Seq)properties.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.propertyKeyToken().name(), Seq$.MODULE$.canBuildFrom());
                    String queryStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$queryExpressionStr(valueExpr, (Seq<String>)propNames);
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(idName, labelToken, properties, argumentIds, indexOrder, false, queryStr);
                    return (B1)object;
                }
                if (A1 instanceof NodeUniqueIndexSeek) {
                    NodeUniqueIndexSeek nodeUniqueIndexSeek = (NodeUniqueIndexSeek)A1;
                    String idName = nodeUniqueIndexSeek.idName();
                    LabelToken labelToken = nodeUniqueIndexSeek.label();
                    Seq<IndexedProperty> properties = nodeUniqueIndexSeek.properties();
                    QueryExpression<Expression> valueExpr = nodeUniqueIndexSeek.valueExpr();
                    Set<String> argumentIds = nodeUniqueIndexSeek.argumentIds();
                    IndexOrder indexOrder = nodeUniqueIndexSeek.indexOrder();
                    Seq propNames = (Seq)properties.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.propertyKeyToken().name(), Seq$.MODULE$.canBuildFrom());
                    String queryStr = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$queryExpressionStr(valueExpr, (Seq<String>)propNames);
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(idName, labelToken, properties, argumentIds, indexOrder, true, queryStr);
                    return (B1)object;
                }
                if (A1 instanceof RollUpApply) {
                    RollUpApply rollUpApply = (RollUpApply)A1;
                    String collectionName = rollUpApply.collectionName();
                    String variableToCollect = rollUpApply.variableToCollect();
                    object = new java.lang.StringBuilder(2).append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(collectionName)).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(variableToCollect)).toString();
                    return (B1)object;
                }
                if (A1 instanceof ConditionalApply) {
                    ConditionalApply conditionalApply = (ConditionalApply)A1;
                    Seq<String> items = conditionalApply.items();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)items);
                    return (B1)object;
                }
                if (A1 instanceof AntiConditionalApply) {
                    AntiConditionalApply antiConditionalApply = (AntiConditionalApply)A1;
                    Seq<String> items = antiConditionalApply.items();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)items);
                    return (B1)object;
                }
                if (A1 instanceof LetSemiApply) {
                    LetSemiApply letSemiApply = (LetSemiApply)A1;
                    String idName = letSemiApply.idName();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(idName);
                    return (B1)object;
                }
                if (A1 instanceof LetAntiSemiApply) {
                    LetAntiSemiApply letAntiSemiApply = (LetAntiSemiApply)A1;
                    String idName = letAntiSemiApply.idName();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(idName);
                    return (B1)object;
                }
                if (A1 instanceof TriadicSelection) {
                    TriadicSelection triadicSelection = (TriadicSelection)A1;
                    boolean positivePredicate = triadicSelection.positivePredicate();
                    String sourceId = triadicSelection.sourceId();
                    String seenId = triadicSelection.seenId();
                    String targetId = triadicSelection.targetId();
                    object = new java.lang.StringBuilder(2).append(positivePredicate).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sourceId, seenId, targetId}))))).toString();
                    return (B1)object;
                }
                if (A1 instanceof TriadicBuild) {
                    TriadicBuild triadicBuild = (TriadicBuild)A1;
                    String sourceId = triadicBuild.sourceId();
                    String seenId = triadicBuild.seenId();
                    Some<Id> triadicSelectionId = triadicBuild.triadicSelectionId();
                    object = new java.lang.StringBuilder(2).append(((Id)triadicSelectionId.value()).x()).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sourceId, seenId}))))).toString();
                    return (B1)object;
                }
                if (A1 instanceof TriadicFilter) {
                    TriadicFilter triadicFilter = (TriadicFilter)A1;
                    boolean positivePredicate = triadicFilter.positivePredicate();
                    String sourceId = triadicFilter.sourceId();
                    String targetId = triadicFilter.targetId();
                    Some<Id> triadicSelectionId = triadicFilter.triadicSelectionId();
                    object = new java.lang.StringBuilder(4).append(((Id)triadicSelectionId.value()).x()).append(", ").append(positivePredicate).append(", ").append(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sourceId, targetId}))))).toString();
                    return (B1)object;
                }
                if (A1 instanceof DeleteNode) {
                    DeleteNode deleteNode = (DeleteNode)A1;
                    Expression expression = deleteNode.expression();
                    object = LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(LogicalPlanToPlanBuilderString$.MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression));
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                QualifiedName qualifiedName;
                ProcedureSignature procedureSignature;
                ProcedureCall procedureCall;
                ResolvedCall resolvedCall;
                boolean bl = false;
                NodeIndexSeek nodeIndexSeek = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Aggregation) {
                    return true;
                }
                if (logicalPlan instanceof OrderedAggregation) {
                    return true;
                }
                if (logicalPlan instanceof Distinct) {
                    return true;
                }
                if (logicalPlan instanceof OrderedDistinct) {
                    return true;
                }
                if (logicalPlan instanceof Projection) {
                    return true;
                }
                if (logicalPlan instanceof UnwindCollection) {
                    return true;
                }
                if (logicalPlan instanceof AllNodesScan) {
                    return true;
                }
                if (logicalPlan instanceof Argument) {
                    return true;
                }
                if (logicalPlan instanceof CacheProperties) {
                    return true;
                }
                if (logicalPlan instanceof Create) {
                    return true;
                }
                if (logicalPlan instanceof Expand) {
                    return true;
                }
                if (logicalPlan instanceof VarExpand) {
                    return true;
                }
                if (logicalPlan instanceof FindShortestPaths) {
                    return true;
                }
                if (logicalPlan instanceof PruningVarExpand) {
                    return true;
                }
                if (logicalPlan instanceof Limit) {
                    return true;
                }
                if (logicalPlan instanceof Skip) {
                    return true;
                }
                if (logicalPlan instanceof NodeByLabelScan) {
                    return true;
                }
                if (logicalPlan instanceof Optional) {
                    return true;
                }
                if (logicalPlan instanceof OptionalExpand) {
                    return true;
                }
                if (logicalPlan instanceof ProcedureCall && (resolvedCall = (procedureCall = (ProcedureCall)logicalPlan).call()) != null && (procedureSignature = resolvedCall.signature()) != null && (qualifiedName = procedureSignature.name()) != null) {
                    return true;
                }
                if (logicalPlan instanceof ProduceResult) {
                    return true;
                }
                if (logicalPlan instanceof ProjectEndpoints) {
                    return true;
                }
                if (logicalPlan instanceof ValueHashJoin) {
                    return true;
                }
                if (logicalPlan instanceof NodeHashJoin) {
                    return true;
                }
                if (logicalPlan instanceof RightOuterHashJoin) {
                    return true;
                }
                if (logicalPlan instanceof LeftOuterHashJoin) {
                    return true;
                }
                if (logicalPlan instanceof Sort) {
                    return true;
                }
                if (logicalPlan instanceof Top) {
                    return true;
                }
                if (logicalPlan instanceof PartialSort) {
                    return true;
                }
                if (logicalPlan instanceof PartialTop) {
                    return true;
                }
                if (logicalPlan instanceof ErrorPlan) {
                    return true;
                }
                if (logicalPlan instanceof Input) {
                    return true;
                }
                if (logicalPlan instanceof RelationshipCountFromCountStore) {
                    return true;
                }
                if (logicalPlan instanceof NodeCountFromCountStore) {
                    return true;
                }
                if (logicalPlan instanceof DetachDeleteNode) {
                    return true;
                }
                if (logicalPlan instanceof DeleteRelationship) {
                    return true;
                }
                if (logicalPlan instanceof SetProperty) {
                    return true;
                }
                if (logicalPlan instanceof SetNodeProperty) {
                    return true;
                }
                if (logicalPlan instanceof SetRelationshipProperty) {
                    return true;
                }
                if (logicalPlan instanceof SetNodePropertiesFromMap) {
                    return true;
                }
                if (logicalPlan instanceof SetRelationshipPropertiesFromMap) {
                    return true;
                }
                if (logicalPlan instanceof SetLabels) {
                    return true;
                }
                if (logicalPlan instanceof Selection) {
                    return true;
                }
                if (logicalPlan instanceof SelectOrSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof LetSelectOrSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof SelectOrAntiSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof LetSelectOrAntiSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof NodeByIdSeek) {
                    return true;
                }
                if (logicalPlan instanceof UndirectedRelationshipByIdSeek) {
                    return true;
                }
                if (logicalPlan instanceof DirectedRelationshipByIdSeek) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexScan) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexContainsScan) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexEndsWithScan) {
                    return true;
                }
                if (logicalPlan instanceof NodeIndexSeek) {
                    String string;
                    FunctionInvocation functionInvocation;
                    FunctionName functionName;
                    Expression expression;
                    PointDistanceSeekRangeWrapper pointDistanceSeekRangeWrapper;
                    PointDistanceRange<Expression> pointDistanceRange;
                    RangeQueryExpression rangeQueryExpression;
                    Expression expression2;
                    bl = true;
                    nodeIndexSeek = (NodeIndexSeek)logicalPlan;
                    QueryExpression<Expression> queryExpression = nodeIndexSeek.valueExpr();
                    if (queryExpression instanceof RangeQueryExpression && (expression2 = (Expression)(rangeQueryExpression = (RangeQueryExpression)queryExpression).expression()) instanceof PointDistanceSeekRangeWrapper && (pointDistanceRange = (pointDistanceSeekRangeWrapper = (PointDistanceSeekRangeWrapper)expression2).range()) != null && (expression = pointDistanceRange.point()) instanceof FunctionInvocation && (functionName = (functionInvocation = (FunctionInvocation)expression).functionName()) != null && "point".equals(string = functionName.name())) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (logicalPlan instanceof NodeUniqueIndexSeek) {
                    return true;
                }
                if (logicalPlan instanceof RollUpApply) {
                    return true;
                }
                if (logicalPlan instanceof ConditionalApply) {
                    return true;
                }
                if (logicalPlan instanceof AntiConditionalApply) {
                    return true;
                }
                if (logicalPlan instanceof LetSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof LetAntiSemiApply) {
                    return true;
                }
                if (logicalPlan instanceof TriadicSelection) {
                    return true;
                }
                if (logicalPlan instanceof TriadicBuild) {
                    return true;
                }
                if (logicalPlan instanceof TriadicFilter) {
                    return true;
                }
                if (!(logicalPlan instanceof DeleteNode)) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.expressions.LogicalProperty ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.ir.CreateNode ), $anonfun$applyOrElse$6(), $anonfun$applyOrElse$7(), $anonfun$applyOrElse$8(java.lang.String ), $anonfun$applyOrElse$9(), $anonfun$applyOrElse$10(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$11(java.lang.String ), $anonfun$applyOrElse$12(java.lang.String ), $anonfun$applyOrElse$13(), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.ast.ProcedureResultItem ), $anonfun$applyOrElse$16(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$17(), $anonfun$applyOrElse$18(), $anonfun$applyOrElse$19(org.neo4j.cypher.internal.expressions.LabelName ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.expressions.RelTypeName ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.expressions.LabelName ), $anonfun$applyOrElse$22(scala.Option ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.expressions.LabelName ), $anonfun$applyOrElse$25(org.neo4j.cypher.internal.expressions.Expression ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.logical.plans.IndexedProperty ), $anonfun$applyOrElse$27(org.neo4j.cypher.internal.logical.plans.IndexedProperty ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.logical.plans.IndexedProperty ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.expressions.LabelName ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.expressions.LabelName )}, serializedLambda);
            }
        };
        scala.Serializable plansWithContent2 = new scala.Serializable((PartialFunction)plansWithContent){
            public static final long serialVersionUID = 0L;
            private final PartialFunction plansWithContent$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                MultiNodeIndexSeek multiNodeIndexSeek;
                Seq<IndexSeekLeafPlan> indexSeekLeafPlans;
                A1 A1 = x2;
                if (A1 instanceof MultiNodeIndexSeek && (indexSeekLeafPlans = (multiNodeIndexSeek = (MultiNodeIndexSeek)A1).nodeIndexSeeks()) != null) {
                    Seq<IndexSeekLeafPlan> seq = indexSeekLeafPlans;
                    object = ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(13).append("_.indexSeek(").append($this.plansWithContent$1.apply(p)).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                MultiNodeIndexSeek multiNodeIndexSeek;
                Seq<IndexSeekLeafPlan> indexSeekLeafPlans;
                LogicalPlan logicalPlan = x2;
                boolean bl = logicalPlan instanceof MultiNodeIndexSeek && (indexSeekLeafPlans = (multiNodeIndexSeek = (MultiNodeIndexSeek)logicalPlan).nodeIndexSeeks()) != null;
                return bl;
            }
            {
                this.plansWithContent$1 = plansWithContent$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlanToPlanBuilderString$$anonfun$3 org.neo4j.cypher.internal.logical.plans.IndexSeekLeafPlan )}, serializedLambda);
            }
        };
        return (String)plansWithContent.orElse((PartialFunction)plansWithContent2).applyOrElse((Object)logicalPlan, (Function1 & Serializable & scala.Serializable)x$27 -> "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$queryExpressionStr(QueryExpression<Expression> valueExpr, Seq<String> propNames) {
        PrefixSeekRangeWrapper prefixSeekRangeWrapper;
        PrefixRange<Expression> prefixRange;
        Expression expression;
        ManyQueryExpression manyQueryExpression;
        Expression expression2;
        boolean bl = false;
        RangeQueryExpression rangeQueryExpression = null;
        QueryExpression<Expression> queryExpression = valueExpr;
        if (queryExpression instanceof SingleQueryExpression) {
            SingleQueryExpression singleQueryExpression = (SingleQueryExpression)queryExpression;
            Expression expression3 = (Expression)singleQueryExpression.expression();
            return new java.lang.StringBuilder(3).append(propNames.head()).append(" = ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression3)).toString();
        }
        if (queryExpression instanceof ManyQueryExpression && (expression2 = (Expression)(manyQueryExpression = (ManyQueryExpression)queryExpression).expression()) instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)expression2;
            Seq expressions = listLiteral.expressions();
            return new java.lang.StringBuilder(3).append(propNames.head()).append(" = ").append(((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$28 -> MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$28), Seq$.MODULE$.canBuildFrom())).mkString(" OR ")).toString();
        }
        if (queryExpression instanceof RangeQueryExpression) {
            bl = true;
            rangeQueryExpression = (RangeQueryExpression)queryExpression;
            Expression expression4 = (Expression)rangeQueryExpression.expression();
            if (expression4 instanceof InequalitySeekRangeWrapper) {
                InequalitySeekRangeWrapper inequalitySeekRangeWrapper = (InequalitySeekRangeWrapper)expression4;
                InequalitySeekRange<Expression> range = inequalitySeekRangeWrapper.range();
                return this.rangeStr(range, (String)propNames.head()).toString();
            }
        }
        if (bl && (expression = (Expression)rangeQueryExpression.expression()) instanceof PrefixSeekRangeWrapper && (prefixRange = (prefixSeekRangeWrapper = (PrefixSeekRangeWrapper)expression).range()) != null) {
            Expression expression5 = prefixRange.prefix();
            return new java.lang.StringBuilder(13).append(propNames.head()).append(" STARTS WITH ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression5)).toString();
        }
        if (!(queryExpression instanceof CompositeQueryExpression)) return "";
        CompositeQueryExpression compositeQueryExpression = (CompositeQueryExpression)queryExpression;
        Seq inner = compositeQueryExpression.inner();
        return ((TraversableOnce)((TraversableLike)inner.zip(propNames, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QueryExpression qe = (QueryExpression)tuple2._1();
            String propName = (String)tuple2._2();
            String string = MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$queryExpressionStr(qe, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{propName}))));
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LogicalPlanToPlanBuilderString.RangeStr rangeStr(InequalitySeekRange<Expression> range, String propName) {
        Bound bound;
        NonEmptyList nonEmptyList;
        Option option;
        Bound bound2;
        NonEmptyList nonEmptyList2;
        Option option2;
        boolean bl = false;
        RangeGreaterThan rangeGreaterThan = null;
        boolean bl2 = false;
        RangeLessThan rangeLessThan = null;
        InequalitySeekRange<Expression> inequalitySeekRange = range;
        if (inequalitySeekRange instanceof RangeGreaterThan) {
            Bound bound3;
            bl = true;
            rangeGreaterThan = (RangeGreaterThan)inequalitySeekRange;
            NonEmptyList nonEmptyList3 = rangeGreaterThan.bounds();
            Option option3 = NonEmptyList$.MODULE$.unapplySeq(nonEmptyList3);
            if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(1) == 0 && (bound3 = (Bound)((SeqLike)option3.get()).apply(0)) instanceof ExclusiveBound) {
                ExclusiveBound exclusiveBound = (ExclusiveBound)bound3;
                Expression expression = (Expression)exclusiveBound.endPoint();
                return new LogicalPlanToPlanBuilderString.RangeStr((Option<Tuple2<String, String>>)None$.MODULE$, propName, (Tuple2<String, String>)new Tuple2((Object)">", (Object)this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)));
            }
        }
        if (bl && !(option2 = NonEmptyList$.MODULE$.unapplySeq(nonEmptyList2 = rangeGreaterThan.bounds())).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && (bound2 = (Bound)((SeqLike)option2.get()).apply(0)) instanceof InclusiveBound) {
            InclusiveBound inclusiveBound = (InclusiveBound)bound2;
            Expression expression = (Expression)inclusiveBound.endPoint();
            return new LogicalPlanToPlanBuilderString.RangeStr((Option<Tuple2<String, String>>)None$.MODULE$, propName, (Tuple2<String, String>)new Tuple2((Object)">=", (Object)this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)));
        }
        if (inequalitySeekRange instanceof RangeLessThan) {
            Bound bound4;
            bl2 = true;
            rangeLessThan = (RangeLessThan)inequalitySeekRange;
            NonEmptyList nonEmptyList4 = rangeLessThan.bounds();
            Option option4 = NonEmptyList$.MODULE$.unapplySeq(nonEmptyList4);
            if (!option4.isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(1) == 0 && (bound4 = (Bound)((SeqLike)option4.get()).apply(0)) instanceof ExclusiveBound) {
                ExclusiveBound exclusiveBound = (ExclusiveBound)bound4;
                Expression expression = (Expression)exclusiveBound.endPoint();
                return new LogicalPlanToPlanBuilderString.RangeStr((Option<Tuple2<String, String>>)None$.MODULE$, propName, (Tuple2<String, String>)new Tuple2((Object)"<", (Object)this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)));
            }
        }
        if (bl2 && !(option = NonEmptyList$.MODULE$.unapplySeq(nonEmptyList = rangeLessThan.bounds())).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && (bound = (Bound)((SeqLike)option.get()).apply(0)) instanceof InclusiveBound) {
            InclusiveBound inclusiveBound = (InclusiveBound)bound;
            Expression expression = (Expression)inclusiveBound.endPoint();
            return new LogicalPlanToPlanBuilderString.RangeStr((Option<Tuple2<String, String>>)None$.MODULE$, propName, (Tuple2<String, String>)new Tuple2((Object)"<=", (Object)this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expression)));
        }
        if (!(inequalitySeekRange instanceof RangeBetween)) throw new MatchError(inequalitySeekRange);
        RangeBetween rangeBetween = (RangeBetween)inequalitySeekRange;
        RangeGreaterThan<Expression> greaterThan = rangeBetween.greaterThan();
        RangeLessThan<Expression> lessThan = rangeBetween.lessThan();
        LogicalPlanToPlanBuilderString.RangeStr gt = this.rangeStr(greaterThan, propName);
        LogicalPlanToPlanBuilderString.RangeStr lt = this.rangeStr(lessThan, propName);
        Tuple2 pre = new Tuple2(gt.post()._2(), (Object)this.switchInequalitySign((String)gt.post()._1()));
        return new LogicalPlanToPlanBuilderString.RangeStr((Option<Tuple2<String, String>>)new Some((Object)pre), propName, lt.post());
    }

    private String switchInequalitySign(String s) {
        char c = this.switchInequalitySign(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head()));
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).tail())).$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c), Predef$.MODULE$.StringCanBuildFrom());
    }

    private char switchInequalitySign(char c) {
        char c2;
        char c3 = c;
        switch (c3) {
            case '>': {
                c2 = '<';
                break;
            }
            case '<': {
                c2 = '>';
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c3));
            }
        }
        return c2;
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$indexOperator(String idName, LabelToken labelToken, Seq<IndexedProperty> properties, Set<String> argumentIds, IndexOrder indexOrder, boolean unique, String parenthesesContent) {
        String indexStr = new java.lang.StringBuilder(3).append(idName).append(":").append(labelToken.name()).append("(").append(parenthesesContent).append(")").toString();
        String indexOrderStr = new java.lang.StringBuilder(15).append(", indexOrder = ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(indexOrder)).toString();
        String argStr = new java.lang.StringBuilder(21).append(", argumentIds = Set(").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds)).append(")").toString();
        String uniqueStr = new java.lang.StringBuilder(11).append(", unique = ").append(unique).toString();
        GetValueFromIndexBehavior getValueBehavior = (GetValueFromIndexBehavior)((TraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.getValueFromIndex(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> {
            block3: {
                block4: {
                    GetValueFromIndexBehavior getValueFromIndexBehavior;
                    GetValueFromIndexBehavior getValueFromIndexBehavior2;
                    block2: {
                        getValueFromIndexBehavior2 = v1;
                        getValueFromIndexBehavior = v2;
                        if (getValueFromIndexBehavior2 != null) break block2;
                        if (getValueFromIndexBehavior == null) break block3;
                        break block4;
                    }
                    if (getValueFromIndexBehavior2.equals(getValueFromIndexBehavior)) break block3;
                }
                throw new UnsupportedOperationException("Index operators with different getValueFromIndex behaviors not supported.");
            }
            return v1;
        });
        String getValueStr = new java.lang.StringBuilder(13).append(", getValue = ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(getValueBehavior)).toString();
        return new java.lang.StringBuilder(4).append(" \"").append(indexStr).append("\"").append(indexOrderStr).append(argStr).append(getValueStr).append(uniqueStr).append(" ").toString().trim();
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$pointDistanceIndexSeek(String idName, LabelToken labelToken, Seq<IndexedProperty> properties, Expression point, Expression distance, Set<String> argumentIds, IndexOrder indexOrder, boolean inclusive) {
        String propName = ((IndexedProperty)properties.head()).propertyKeyToken().name();
        String indexOrderStr = new java.lang.StringBuilder(15).append(", indexOrder = ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(indexOrder)).toString();
        String argStr = new java.lang.StringBuilder(21).append(", argumentIds = Set(").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)argumentIds)).append(")").toString();
        String inclusiveStr = new java.lang.StringBuilder(14).append(", inclusive = ").append(inclusive).toString();
        GetValueFromIndexBehavior getValueBehavior = (GetValueFromIndexBehavior)((TraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.getValueFromIndex(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> {
            block3: {
                block4: {
                    GetValueFromIndexBehavior getValueFromIndexBehavior;
                    GetValueFromIndexBehavior getValueFromIndexBehavior2;
                    block2: {
                        getValueFromIndexBehavior2 = v1;
                        getValueFromIndexBehavior = v2;
                        if (getValueFromIndexBehavior2 != null) break block2;
                        if (getValueFromIndexBehavior == null) break block3;
                        break block4;
                    }
                    if (getValueFromIndexBehavior2.equals(getValueFromIndexBehavior)) break block3;
                }
                throw new UnsupportedOperationException("Index operators with different getValueFromIndex behaviors not supported.");
            }
            return v1;
        });
        String getValueStr = new java.lang.StringBuilder(13).append(", getValue = ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(getValueBehavior)).toString();
        return new java.lang.StringBuilder(18).append(" \"").append(idName).append("\", \"").append(labelToken.name()).append("\", \"").append(propName).append("\", \"").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(point)).append("\", ").append(this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(distance)).append(indexOrderStr).append(argStr).append(getValueStr).append(inclusiveStr).append(" ").toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$idsStr(SeekableArgs ids) {
        void var3_10;
        ManySeekableArgs manySeekableArgs;
        Expression expression;
        String string;
        SeekableArgs seekableArgs = ids;
        if (seekableArgs instanceof SingleSeekableArg) {
            SingleSeekableArg singleSeekableArg = (SingleSeekableArg)seekableArgs;
            Expression expr = singleSeekableArg.expr();
            string = this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expr);
        } else if (seekableArgs instanceof ManySeekableArgs && (expression = (manySeekableArgs = (ManySeekableArgs)seekableArgs).expr()) instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)expression;
            Seq expressions = listLiteral.expressions();
            string = ((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$32 -> MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(x$32), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        } else {
            throw new UnsupportedOperationException(new java.lang.StringBuilder(38).append("Id string cannot be constructed from ").append(ids).append(".").toString());
        }
        String idsStr = string;
        return var3_10;
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$integerString(Expression count) {
        String string;
        Expression expression = count;
        if (expression instanceof SignedDecimalIntegerLiteral) {
            String i;
            SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)expression;
            string = i = signedDecimalIntegerLiteral.stringVal();
        } else {
            string = new java.lang.StringBuilder(5).append("/* ").append(count).append("*/").toString();
        }
        return string;
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$sortItemsStr(Seq<ColumnOrder> sortItems) {
        return ((TraversableOnce)sortItems.map((Function1 & Serializable & scala.Serializable)si -> MODULE$.sortItemStr((ColumnOrder)si), Seq$.MODULE$.canBuildFrom())).mkString("Seq(", ", ", ")");
    }

    private String sortItemStr(ColumnOrder si) {
        return new java.lang.StringBuilder(6).append(" ").append(si.getClass().getSimpleName()).append("(\"").append(si.id()).append("\") ").toString().trim();
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$variablePredicate(Option<VariablePredicate> nodePredicate, String name) {
        return (String)nodePredicate.map((Function1 & Serializable & scala.Serializable)vp -> new java.lang.StringBuilder(23).append(", ").append(name).append(" = Predicate(\"").append(vp.variable().name()).append("\", \"").append(MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(vp.predicate())).append("\") ").toString().trim()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$relTypeStr(Seq<RelTypeName> types) {
        String string;
        Seq<RelTypeName> seq = types;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            string = "";
        } else {
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (!option.isEmpty()) {
                RelTypeName head = (RelTypeName)((Tuple2)option.get())._1();
                Seq tail = (Seq)((Tuple2)option.get())._2();
                string = new java.lang.StringBuilder(1).append(":").append(head.name()).append(((TraversableOnce)tail.map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(1).append("|").append(t.name()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("")).toString();
            } else {
                throw new MatchError(seq);
            }
        }
        return string;
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$projectStrs(Map<String, Expression> map) {
        return this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString((Iterable<String>)((Iterable)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String alias = (String)tuple2._1();
            Expression expr = (Expression)tuple2._2();
            String string = new java.lang.StringBuilder(4).append(MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier().apply(expr)).append(" AS ").append(alias).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())));
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations(String c) {
        return new java.lang.StringBuilder(2).append("\"").append(c).append("\"").toString();
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotationsAndMkString(Iterable<String> strings) {
        return ((TraversableOnce)strings.map((Function1 & Serializable & scala.Serializable)c -> MODULE$.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$wrapInQuotations((String)c), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public String org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$objectName(Object obj) {
        String str = obj.getClass().getSimpleName();
        return str.substring(0, str.length() - 1);
    }

    public Tuple2<String, String> org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$arrows(SemanticDirection dir) {
        Tuple2 tuple2;
        SemanticDirection semanticDirection = dir;
        if (SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection)) {
            tuple2 = new Tuple2((Object)"-", (Object)"->");
        } else if (SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection)) {
            tuple2 = new Tuple2((Object)"<-", (Object)"-");
        } else if (SemanticDirection.BOTH$.MODULE$.equals(semanticDirection)) {
            tuple2 = new Tuple2((Object)"-", (Object)"-");
        } else {
            throw new MatchError((Object)semanticDirection);
        }
        return tuple2;
    }

    private LogicalPlanToPlanBuilderString$() {
        MODULE$ = this;
        Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)x$1 -> x$1.asCanonicalStringVal();
        boolean x$2 = true;
        boolean x$3 = ExpressionStringifier$.MODULE$.apply$default$2();
        boolean x$4 = ExpressionStringifier$.MODULE$.apply$default$3();
        boolean x$5 = ExpressionStringifier$.MODULE$.apply$default$5();
        this.org$neo4j$cypher$internal$logical$plans$LogicalPlanToPlanBuilderString$$expressionStringifier = ExpressionStringifier$.MODULE$.apply((Function1)x$12, x$3, x$4, x$2, x$5);
    }
}

