/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class NameValidator$ {
    public static NameValidator$ MODULE$;
    private final Pattern usernamePattern;
    private final Pattern roleNamePattern;

    static {
        new NameValidator$();
    }

    private Pattern usernamePattern() {
        return this.usernamePattern;
    }

    private Pattern roleNamePattern() {
        return this.roleNamePattern;
    }

    public void assertValidUsername(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided username is empty.");
        }
        if (!this.usernamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("Username '").append(name).append("' contains illegal characters.\n           |Use ascii characters that are not ',', ':' or whitespaces.").toString())).stripMargin());
        }
    }

    public void assertValidRoleName(String name) {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("The provided role name is empty.");
        }
        if (!this.roleNamePattern().matcher(name).matches()) {
            throw new InvalidArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("Role name '").append(name).append("' contains illegal characters.\n           |Use simple ascii characters, numbers and underscores.").toString())).stripMargin());
        }
    }

    private NameValidator$() {
        MODULE$ = this;
        this.usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");
        this.roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");
    }
}

