/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.NoOptions$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.OptionsMap;
import org.neo4j.cypher.internal.ast.OptionsParam;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.expressions.Variable$;
import org.neo4j.cypher.internal.logical.plans.EmptyNodeElementTypeReference$;
import org.neo4j.cypher.internal.logical.plans.GraphElementTypeReferenceForConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeCreateConstraintOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeDropConstraintOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeEntryOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$PropertyTypeOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphTypeCreateConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphTypeDropConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphTypeEntry;
import org.neo4j.cypher.internal.logical.plans.NodeElementType;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceByLabel;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceForRelationshipElementType;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementType;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementTypeReferenceByLabel;
import org.neo4j.cypher.internal.util.InputPosition$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;

public final class GraphType$ {
    public static final GraphType$ MODULE$ = new GraphType$();
    private static final ExpressionStringifier stringifier = ExpressionStringifier$.MODULE$.pretty((Function1 & Serializable)e -> e.asCanonicalStringVal());

    private ExpressionStringifier stringifier() {
        return stringifier;
    }

    public String graphTypeInfo(Set<GraphTypeEntry> elementTypes, Set<GraphTypeCreateConstraint> constraints) {
        if (elementTypes.isEmpty() && constraints.isEmpty()) {
            return "{}";
        }
        List<String> elementTypeStrings = this.getElementTypesStrings(elementTypes);
        List constraintStrings = ((List)constraints.toList().sorted((Ordering)GraphType$GraphTypeCreateConstraintOrdering$.MODULE$)).map((Function1 & Serializable)c -> {
            Object object;
            Tuple2 tuple2;
            String name = (String)c.name().map((Function1 & Serializable)n -> " " + MODULE$.stringifier().apply((Expression)new Variable(n, InputPosition$.MODULE$.NONE(), Variable$.MODULE$.isIsolatedDefault()))).getOrElse((Function0 & Serializable)() -> "");
            GraphElementTypeReferenceForConstraint graphElementTypeReferenceForConstraint = c.reference();
            if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByLabel) {
                NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("(n:" + MODULE$.stringifier().apply((SymbolicName)nodeElementTypeReferenceByLabel.labelName()) + ")"), (Object)"n");
            } else if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByIdentifyingLabel) {
                NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("(n:" + MODULE$.stringifier().apply((SymbolicName)nodeElementTypeReferenceByIdentifyingLabel.labelName()) + " =>)"), (Object)"n");
            } else if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByLabel) {
                RelationshipElementTypeReferenceByLabel relationshipElementTypeReferenceByLabel = (RelationshipElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("()-[r:" + MODULE$.stringifier().apply((SymbolicName)relationshipElementTypeReferenceByLabel.relTypeName()) + "]->()"), (Object)"r");
            } else if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByIdentifyingLabel) {
                RelationshipElementTypeReferenceByIdentifyingLabel relationshipElementTypeReferenceByIdentifyingLabel = (RelationshipElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("()-[r:" + MODULE$.stringifier().apply((SymbolicName)relationshipElementTypeReferenceByIdentifyingLabel.relTypeName()) + " =>]->()"), (Object)"r");
            } else {
                throw new MatchError((Object)graphElementTypeReferenceForConstraint);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String elemType = (String)tuple22._1();
            String variable = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)elemType, (Object)variable);
            String elemType2 = (String)tuple23._1();
            String variable2 = (String)tuple23._2();
            ArraySeq props = c.properties().map((Function1 & Serializable)p -> variable2 + "." + MODULE$.stringifier().apply((SymbolicName)p));
            String propertiesString = props.size() == 1 ? (String)props.head() : props.mkString("(", ", ", ")");
            String assertion = c.constraintType().predicate();
            Options options = c.options();
            if (NoOptions$.MODULE$.equals(options)) {
                object = "";
            } else if (options instanceof OptionsParam) {
                OptionsParam optionsParam = (OptionsParam)options;
                Parameter parameter = optionsParam.parameter();
                object = " OPTIONS " + MODULE$.stringifier().apply((Expression)parameter);
            } else if (options instanceof OptionsMap) {
                OptionsMap optionsMap = (OptionsMap)options;
                Map innerMap = optionsMap.map();
                String mapString = ((IterableOnceOps)innerMap.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String s = (String)tuple2._1();
                        Expression e = (Expression)tuple2._2();
                        return MODULE$.stringifier().apply((SymbolicName)new PropertyKeyName(s, InputPosition$.MODULE$.NONE())) + ": " + MODULE$.stringifier().apply(e);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString("{", ", ", "}");
                object = " OPTIONS " + mapString;
            } else {
                throw new MatchError((Object)options);
            }
            String options2 = object;
            return "CONSTRAINT" + name + " FOR " + elemType2 + " REQUIRE " + propertiesString + " " + assertion + options2;
        });
        return "{ " + ((IterableOnceOps)elementTypeStrings.$plus$plus((IterableOnce)constraintStrings)).mkString(", ") + " }";
    }

    public String graphTypeDropInfo(Set<GraphTypeEntry> elementTypes, Set<GraphTypeDropConstraint> constraints) {
        if (elementTypes.isEmpty() && constraints.isEmpty()) {
            return "{}";
        }
        List<String> elementTypeStrings = this.getElementTypesStrings(elementTypes);
        List constraintStrings = ((List)constraints.toList().sorted((Ordering)GraphType$GraphTypeDropConstraintOrdering$.MODULE$)).map((Function1 & Serializable)c -> "CONSTRAINT " + MODULE$.stringifier().apply((Expression)new Variable(c.name(), InputPosition$.MODULE$.NONE(), Variable$.MODULE$.isIsolatedDefault())));
        return "{ " + ((IterableOnceOps)elementTypeStrings.$plus$plus((IterableOnce)constraintStrings)).mkString(", ") + " }";
    }

    private List<String> getElementTypesStrings(Set<GraphTypeEntry> elementTypes) {
        return ((List)elementTypes.toList().sorted((Ordering)GraphType$GraphTypeEntryOrdering$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            GraphTypeEntry graphTypeEntry = x0$1;
            if (graphTypeEntry instanceof NodeElementType) {
                NodeElementType nodeElementType = (NodeElementType)graphTypeEntry;
                String identifyingLabel = MODULE$.stringifier().apply((SymbolicName)nodeElementType.identifyingLabel());
                List impliedLabels = ((List)nodeElementType.additionalLabels().toList().sortBy((Function1 & Serializable)x$6 -> x$6.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$7 -> MODULE$.stringifier().apply((SymbolicName)x$7));
                String impliedLabelsString = impliedLabels.mkString(":", "&", "");
                List properties = GraphType$.getProperties$1(nodeElementType.propertyTypes());
                String propertiesString = properties.mkString("{", ", ", "}");
                if (impliedLabels.isEmpty() && properties.isEmpty()) {
                    return "(:" + identifyingLabel + " =>)";
                }
                if (impliedLabels.isEmpty()) {
                    return "(:" + identifyingLabel + " => " + propertiesString + ")";
                }
                if (properties.isEmpty()) {
                    return "(:" + identifyingLabel + " => " + impliedLabelsString + ")";
                }
                return "(:" + identifyingLabel + " => " + impliedLabelsString + " " + propertiesString + ")";
            }
            if (graphTypeEntry instanceof RelationshipElementType) {
                RelationshipElementType relationshipElementType = (RelationshipElementType)graphTypeEntry;
                String identifyingLabel = MODULE$.stringifier().apply((SymbolicName)relationshipElementType.identifyingLabel());
                String sourceNode = this.getEndpointRefNode$1(relationshipElementType.sourceNode());
                String targetNode = this.getEndpointRefNode$1(relationshipElementType.targetNode());
                List properties = GraphType$.getProperties$1(relationshipElementType.propertyTypes());
                String propertiesString = properties.mkString("{", ", ", "}");
                if (properties.isEmpty()) {
                    return sourceNode + "-[:" + identifyingLabel + " =>]->" + targetNode;
                }
                return sourceNode + "-[:" + identifyingLabel + " => " + propertiesString + "]->" + targetNode;
            }
            throw new MatchError((Object)graphTypeEntry);
        });
    }

    private static final List getProperties$1(Set propTypes) {
        return ((List)propTypes.toList().sorted((Ordering)GraphType$PropertyTypeOrdering$.MODULE$)).map((Function1 & Serializable)pt -> MODULE$.stringifier().apply((SymbolicName)pt.name()) + " :: " + pt.propertyType().normalizedCypherTypeString());
    }

    private final String getEndpointRefNode$1(NodeElementTypeReferenceForRelationshipElementType node) {
        NodeElementTypeReferenceForRelationshipElementType nodeElementTypeReferenceForRelationshipElementType = node;
        if (EmptyNodeElementTypeReference$.MODULE$.equals(nodeElementTypeReferenceForRelationshipElementType)) {
            return "()";
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByLabel) {
            NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)nodeElementTypeReferenceForRelationshipElementType;
            return "(:" + this.stringifier().apply((SymbolicName)nodeElementTypeReferenceByLabel.labelName()) + ")";
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByIdentifyingLabel) {
            NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)nodeElementTypeReferenceForRelationshipElementType;
            return "(:" + this.stringifier().apply((SymbolicName)nodeElementTypeReferenceByIdentifyingLabel.labelName()) + " =>)";
        }
        throw new MatchError((Object)nodeElementTypeReferenceForRelationshipElementType);
    }

    private GraphType$() {
    }
}

