/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.generator;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.SimpleMetricsFactory$;
import org.neo4j.cypher.internal.compiler.planner.logical.StatisticsBackedCardinalityModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.assumeIndependence.AssumeIndependenceQueryGraphCardinalityModel;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.assumeIndependence.LabelInferenceStrategy;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.IntegerLiteral;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryGraph$;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.logical.generator.CardinalityCalculator;
import org.neo4j.cypher.internal.logical.plans.Aggregation;
import org.neo4j.cypher.internal.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.logical.plans.AntiSemiApply;
import org.neo4j.cypher.internal.logical.plans.Apply;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.Distinct;
import org.neo4j.cypher.internal.logical.plans.Eager;
import org.neo4j.cypher.internal.logical.plans.ExhaustiveLimit;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.Limit;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.logical.plans.NodeCountFromCountStore;
import org.neo4j.cypher.internal.logical.plans.Optional;
import org.neo4j.cypher.internal.logical.plans.ProduceResult;
import org.neo4j.cypher.internal.logical.plans.Projection;
import org.neo4j.cypher.internal.logical.plans.RelationshipCountFromCountStore;
import org.neo4j.cypher.internal.logical.plans.Selection;
import org.neo4j.cypher.internal.logical.plans.SemiApply;
import org.neo4j.cypher.internal.logical.plans.Skip;
import org.neo4j.cypher.internal.logical.plans.Sort;
import org.neo4j.cypher.internal.logical.plans.Top;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.Union;
import org.neo4j.cypher.internal.logical.plans.UnwindCollection;
import org.neo4j.cypher.internal.logical.plans.ValueHashJoin;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.collection.immutable.ListSet;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CardinalityCalculator$ {
    public static final CardinalityCalculator$ MODULE$ = new CardinalityCalculator$();
    private static final CardinalityCalculator<LogicalPlan> SAME_AS_LEFT = (plan, state, x$1, x$2) -> (Cardinality)state.cardinalities().apply(((LogicalPlan)plan.lhs().get()).id());
    private static final CardinalityCalculator<LogicalPlan> LEAF_CARDINALITY = (x$3, state, x$4, x$5) -> state.leafCardinalityMultiplier();
    private static final CardinalityCalculator<ProduceResult> produceResultCardinality = MODULE$.SAME_AS_LEFT();
    private static final CardinalityCalculator<AllNodesScan> allNodesScanCardinality = (x$6, state, planContext, x$7) -> state.leafCardinalityMultiplier().$times(planContext.statistics().nodesAllCardinality());
    private static final CardinalityCalculator<UndirectedRelationshipByIdSeek> undirectedRelationshipByIdSeek = (plan, state, x$8, x$9) -> {
        Cardinality numberOfRels = (Cardinality)plan.relIds().sizeHint().map((Function1 & Serializable)x$10 -> CardinalityCalculator$.$anonfun$undirectedRelationshipByIdSeek$2(BoxesRunTime.unboxToInt((Object)x$10))).getOrElse((Function0 & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY());
        return numberOfRels.$times(new Multiplier(2.0)).$times(state.leafCardinalityMultiplier());
    };
    private static final CardinalityCalculator<DirectedRelationshipByIdSeek> directedRelationshipByIdSeek = (plan, state, x$11, x$12) -> {
        Cardinality numberOfRels = (Cardinality)plan.relIds().sizeHint().map((Function1 & Serializable)x$13 -> CardinalityCalculator$.$anonfun$directedRelationshipByIdSeek$2(BoxesRunTime.unboxToInt((Object)x$13))).getOrElse((Function0 & Serializable)() -> PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY());
        return numberOfRels.$times(state.leafCardinalityMultiplier());
    };
    private static final CardinalityCalculator<NodeByLabelScan> nodeByLabelScanCardinality = (plan, state, planContext, labelsWithIds) -> {
        Some labelId = new Some((Object)new LabelId(BoxesRunTime.unboxToInt((Object)labelsWithIds.apply((Object)plan.label().name()))));
        return state.leafCardinalityMultiplier().$times(planContext.statistics().nodesWithLabelCardinality((Option)labelId));
    };
    private static final CardinalityCalculator<Argument> argumentCardinality = MODULE$.LEAF_CARDINALITY();
    private static final CardinalityCalculator<Eager> eagerCardinality = MODULE$.SAME_AS_LEFT();
    private static final CardinalityCalculator<Expand> expandCardinality = (plan, state, planContext, x$14) -> {
        Expand expand = plan;
        if (expand == null) {
            throw new MatchError((Object)expand);
        }
        LogicalPlan source = expand.source();
        LogicalVariable from = expand.from();
        SemanticDirection dir = expand.dir();
        Seq relTypes = expand.types();
        LogicalVariable to = expand.to();
        LogicalVariable relName = expand.relName();
        Tuple6 tuple6 = new Tuple6((Object)source, (Object)from, (Object)dir, (Object)relTypes, (Object)to, (Object)relName);
        LogicalPlan source2 = (LogicalPlan)tuple6._1();
        LogicalVariable from2 = (LogicalVariable)tuple6._2();
        SemanticDirection dir2 = (SemanticDirection)tuple6._3();
        Seq relTypes2 = (Seq)tuple6._4();
        LogicalVariable to2 = (LogicalVariable)tuple6._5();
        LogicalVariable relName2 = (LogicalVariable)tuple6._6();
        Cardinality inboundCardinality = (Cardinality)state.cardinalities().get(source2.id());
        Set x$1 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogicalVariable[]{from2, to2}));
        Set x$2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{new PatternRelationship(relName2, new Tuple2((Object)from2, (Object)to2), dir2, relTypes2, (PatternLength)SimplePatternLength$.MODULE$)}));
        Set<LogicalVariable> x$3 = state.arguments();
        Set x$4 = QueryGraph$.MODULE$.apply$default$2();
        Selections x$5 = QueryGraph$.MODULE$.apply$default$5();
        IndexedSeq x$6 = QueryGraph$.MODULE$.apply$default$6();
        ListSet x$7 = QueryGraph$.MODULE$.apply$default$7();
        Set x$8 = QueryGraph$.MODULE$.apply$default$8();
        IndexedSeq x$9 = QueryGraph$.MODULE$.apply$default$9();
        Set x$10 = QueryGraph$.MODULE$.apply$default$10();
        QueryGraph qg = QueryGraph$.MODULE$.apply(x$2, x$4, x$1, x$3, x$5, x$6, x$7, x$8, x$9, x$10);
        AssumeIndependenceQueryGraphCardinalityModel qgCardinalityModel = new AssumeIndependenceQueryGraphCardinalityModel(planContext, SimpleMetricsFactory$.MODULE$.newSelectivityCalculator(planContext), (SelectivityCombiner)IndependenceCombiner$.MODULE$, (LabelInferenceStrategy)LabelInferenceStrategy.NoInference$.MODULE$);
        Cardinality expandCardinality = qgCardinalityModel.apply(qg, state.labelInfo(), state.relTypeInfo(), state.semanticTable(), IndexCompatiblePredicatesProviderContext$.MODULE$.default(), null);
        return expandCardinality.$times(inboundCardinality);
    };
    private static final CardinalityCalculator<Skip> skipCardinality = (plan, state, x$16, x$17) -> {
        Expression count;
        LogicalPlan source;
        block3: {
            Skip skip;
            block2: {
                skip = plan;
                if (skip == null) break block2;
                source = skip.source();
                count = skip.count();
                if (count != null) break block3;
            }
            throw new MatchError((Object)skip);
        }
        Expression expression = count;
        Tuple2 tuple2 = new Tuple2((Object)source, (Object)expression);
        LogicalPlan source2 = (LogicalPlan)tuple2._1();
        Expression count2 = (Expression)tuple2._2();
        Cardinality sourceCardinality = (Cardinality)state.cardinalities().get(source2.id());
        return Cardinality$.MODULE$.max(Cardinality$.MODULE$.EMPTY(), sourceCardinality.$plus(new Cardinality((double)(-Predef$.MODULE$.Long2long(MODULE$.toIntegerLiteral(count2).value())))));
    };
    private static final CardinalityCalculator<Limit> limitCardinality = (plan, state, x$19, x$20) -> {
        Expression count;
        LogicalPlan source;
        block3: {
            Limit limit;
            block2: {
                limit = plan;
                if (limit == null) break block2;
                source = limit.source();
                count = limit.count();
                if (count != null) break block3;
            }
            throw new MatchError((Object)limit);
        }
        Expression expression = count;
        Tuple2 tuple2 = new Tuple2((Object)source, (Object)expression);
        LogicalPlan source2 = (LogicalPlan)tuple2._1();
        Expression count2 = (Expression)tuple2._2();
        Cardinality sourceCardinality = (Cardinality)state.cardinalities().get(source2.id());
        return Cardinality$.MODULE$.min(sourceCardinality, new Cardinality((double)Predef$.MODULE$.Long2long(MODULE$.toIntegerLiteral(count2).value())));
    };
    private static final CardinalityCalculator<ExhaustiveLimit> exhaustiveLimitCardinality = (plan, state, x$22, x$23) -> {
        Expression count;
        LogicalPlan source;
        block3: {
            ExhaustiveLimit exhaustiveLimit;
            block2: {
                exhaustiveLimit = plan;
                if (exhaustiveLimit == null) break block2;
                source = exhaustiveLimit.source();
                count = exhaustiveLimit.count();
                if (count != null) break block3;
            }
            throw new MatchError((Object)exhaustiveLimit);
        }
        Expression expression = count;
        Tuple2 tuple2 = new Tuple2((Object)source, (Object)expression);
        LogicalPlan source2 = (LogicalPlan)tuple2._1();
        Expression count2 = (Expression)tuple2._2();
        Cardinality sourceCardinality = (Cardinality)state.cardinalities().get(source2.id());
        return Cardinality$.MODULE$.min(sourceCardinality, new Cardinality((double)Predef$.MODULE$.Long2long(MODULE$.toIntegerLiteral(count2).value())));
    };
    private static final CardinalityCalculator<Projection> projectionCardinality = (plan, state, x$25, x$26) -> (Cardinality)state.cardinalities().get(plan.source().id());
    private static final CardinalityCalculator<Aggregation> aggregationCardinality = (plan, state, x$27, x$28) -> {
        Cardinality in = (Cardinality)state.cardinalities().get(plan.source().id());
        return StatisticsBackedCardinalityModel$.MODULE$.aggregateCardinalityEstimation(in, plan.groupingExpressions());
    };
    private static final CardinalityCalculator<Apply> applyCardinality = (plan, state, x$29, x$30) -> (Cardinality)state.cardinalities().get(plan.right().id());
    private static final CardinalityCalculator<SemiApply> semiApplyCardinality = (plan, state, x$31, x$32) -> {
        Cardinality lhsCardinality = (Cardinality)state.cardinalities().get(plan.left().id());
        return lhsCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY());
    };
    private static final CardinalityCalculator<AntiSemiApply> antiSemiApplyCardinality = (plan, state, x$33, x$34) -> {
        Cardinality lhsCardinality = (Cardinality)state.cardinalities().get(plan.left().id());
        return lhsCardinality.$times(PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY());
    };
    private static final CardinalityCalculator<CartesianProduct> cartesianProductCardinality = (plan, state, x$35, x$36) -> ((Cardinality)state.cardinalities().get(plan.left().id())).$times((Cardinality)state.cardinalities().get(plan.right().id()));
    private static final CardinalityCalculator<Distinct> distinctCardinality = (plan, state, x$37, x$38) -> ((Cardinality)state.cardinalities().get(plan.source().id())).$times(PlannerDefaults$.MODULE$.DEFAULT_DISTINCT_SELECTIVITY());
    private static final CardinalityCalculator<Optional> optionalCardinality = (plan, state, x$39, x$40) -> Cardinality$.MODULE$.max(state.leafCardinalityMultiplier(), (Cardinality)state.cardinalities().get(plan.source().id()));
    private static final CardinalityCalculator<Sort> sortCardinality = MODULE$.SAME_AS_LEFT();
    private static final CardinalityCalculator<Top> topCardinality = (plan, state, x$41, x$42) -> {
        Expression count;
        LogicalPlan source;
        block3: {
            Top top;
            block2: {
                top = plan;
                if (top == null) break block2;
                source = top.source();
                count = top.limit();
                if (count != null) break block3;
            }
            throw new MatchError((Object)top);
        }
        Expression expression = count;
        Tuple2 tuple2 = new Tuple2((Object)source, (Object)expression);
        LogicalPlan source2 = (LogicalPlan)tuple2._1();
        Expression count2 = (Expression)tuple2._2();
        Cardinality sourceCardinality = (Cardinality)state.cardinalities().get(source2.id());
        Cardinality applyLHSCardinality = state.leafCardinalityMultiplier();
        Multiplier limit = new Multiplier((double)Predef$.MODULE$.Long2long(MODULE$.toIntegerLiteral(count2).value()));
        return Cardinality$.MODULE$.min(sourceCardinality, applyLHSCardinality.$times(limit));
    };
    private static final CardinalityCalculator<Selection> selectionCardinality = (plan, state, x$44, x$45) -> ((Cardinality)state.cardinalities().get(plan.source().id())).$times(PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY());
    private static final CardinalityCalculator<UnwindCollection> unwindCollectionCardinality = (plan, state, x$46, x$47) -> ((Cardinality)state.cardinalities().get(plan.source().id())).$times(PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY());
    private static final CardinalityCalculator<NodeCountFromCountStore> nodeCountFromCountStoreCardinality = MODULE$.LEAF_CARDINALITY();
    private static final CardinalityCalculator<RelationshipCountFromCountStore> relationshipCountFromCountStoreCardinality = MODULE$.LEAF_CARDINALITY();
    private static final CardinalityCalculator<ValueHashJoin> valueHashJoinCardinality = (plan, state, x$48, x$49) -> ((Cardinality)state.cardinalities().get(plan.left().id())).$times((Cardinality)state.cardinalities().get(plan.right().id())).$times(PlannerDefaults$.MODULE$.DEFAULT_EQUALITY_SELECTIVITY());
    private static final CardinalityCalculator<Union> unionCardinality = (plan, state, x$50, x$51) -> ((Cardinality)state.cardinalities().get(plan.left().id())).$plus((Cardinality)state.cardinalities().get(plan.right().id()));

    private CardinalityCalculator<LogicalPlan> SAME_AS_LEFT() {
        return SAME_AS_LEFT;
    }

    private CardinalityCalculator<LogicalPlan> LEAF_CARDINALITY() {
        return LEAF_CARDINALITY;
    }

    public CardinalityCalculator<ProduceResult> produceResultCardinality() {
        return produceResultCardinality;
    }

    public CardinalityCalculator<AllNodesScan> allNodesScanCardinality() {
        return allNodesScanCardinality;
    }

    public CardinalityCalculator<UndirectedRelationshipByIdSeek> undirectedRelationshipByIdSeek() {
        return undirectedRelationshipByIdSeek;
    }

    public CardinalityCalculator<DirectedRelationshipByIdSeek> directedRelationshipByIdSeek() {
        return directedRelationshipByIdSeek;
    }

    public CardinalityCalculator<NodeByLabelScan> nodeByLabelScanCardinality() {
        return nodeByLabelScanCardinality;
    }

    public CardinalityCalculator<Argument> argumentCardinality() {
        return argumentCardinality;
    }

    public CardinalityCalculator<Eager> eagerCardinality() {
        return eagerCardinality;
    }

    public CardinalityCalculator<Expand> expandCardinality() {
        return expandCardinality;
    }

    public CardinalityCalculator<Skip> skipCardinality() {
        return skipCardinality;
    }

    public CardinalityCalculator<Limit> limitCardinality() {
        return limitCardinality;
    }

    public CardinalityCalculator<ExhaustiveLimit> exhaustiveLimitCardinality() {
        return exhaustiveLimitCardinality;
    }

    public CardinalityCalculator<Projection> projectionCardinality() {
        return projectionCardinality;
    }

    public CardinalityCalculator<Aggregation> aggregationCardinality() {
        return aggregationCardinality;
    }

    public CardinalityCalculator<Apply> applyCardinality() {
        return applyCardinality;
    }

    public CardinalityCalculator<SemiApply> semiApplyCardinality() {
        return semiApplyCardinality;
    }

    public CardinalityCalculator<AntiSemiApply> antiSemiApplyCardinality() {
        return antiSemiApplyCardinality;
    }

    public CardinalityCalculator<CartesianProduct> cartesianProductCardinality() {
        return cartesianProductCardinality;
    }

    public CardinalityCalculator<Distinct> distinctCardinality() {
        return distinctCardinality;
    }

    public CardinalityCalculator<Optional> optionalCardinality() {
        return optionalCardinality;
    }

    public CardinalityCalculator<Sort> sortCardinality() {
        return sortCardinality;
    }

    public CardinalityCalculator<Top> topCardinality() {
        return topCardinality;
    }

    public CardinalityCalculator<Selection> selectionCardinality() {
        return selectionCardinality;
    }

    public CardinalityCalculator<UnwindCollection> unwindCollectionCardinality() {
        return unwindCollectionCardinality;
    }

    public CardinalityCalculator<NodeCountFromCountStore> nodeCountFromCountStoreCardinality() {
        return nodeCountFromCountStoreCardinality;
    }

    public CardinalityCalculator<RelationshipCountFromCountStore> relationshipCountFromCountStoreCardinality() {
        return relationshipCountFromCountStoreCardinality;
    }

    public CardinalityCalculator<ValueHashJoin> valueHashJoinCardinality() {
        return valueHashJoinCardinality;
    }

    public CardinalityCalculator<Union> unionCardinality() {
        return unionCardinality;
    }

    private IntegerLiteral toIntegerLiteral(Expression count) {
        Expression expression = count;
        if (expression instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)expression;
            return integerLiteral;
        }
        throw Assertions$.MODULE$.fail("Expected IntegerLiteral but got " + expression.getClass(), new Position("CardinalityCalculator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }

    public static final /* synthetic */ Cardinality $anonfun$undirectedRelationshipByIdSeek$2(int x$10) {
        return new Cardinality((double)x$10);
    }

    public static final /* synthetic */ Cardinality $anonfun$directedRelationshipByIdSeek$2(int x$13) {
        return new Cardinality((double)x$13);
    }

    private CardinalityCalculator$() {
    }
}

