/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.builder;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.expressions.AndsReorderable;
import org.neo4j.cypher.internal.expressions.CachedProperty;
import org.neo4j.cypher.internal.expressions.DynamicRelTypeExpression;
import org.neo4j.cypher.internal.expressions.DynamicRelTypeExpression$;
import org.neo4j.cypher.internal.expressions.EntityType;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeExpression;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.UnPositionedVariable$;
import org.neo4j.cypher.internal.ir.CreateNode;
import org.neo4j.cypher.internal.ir.CreatePattern;
import org.neo4j.cypher.internal.ir.CreateRelationship;
import org.neo4j.cypher.internal.ir.DeleteExpression;
import org.neo4j.cypher.internal.ir.RemoveLabelPattern;
import org.neo4j.cypher.internal.ir.SetDynamicPropertyPattern;
import org.neo4j.cypher.internal.ir.SetLabelPattern;
import org.neo4j.cypher.internal.ir.SetMutatingPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertyPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetPropertyPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertyPattern;
import org.neo4j.cypher.internal.logical.builder.AbstractLogicalPlanBuilder;
import org.neo4j.cypher.internal.logical.builder.Parser$;
import org.neo4j.cypher.internal.logical.plans.CoerceToPredicate;
import org.neo4j.cypher.internal.logical.plans.Column;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.collection.immutable.ListSet$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class AbstractLogicalPlanBuilder$ {
    public static final AbstractLogicalPlanBuilder$ MODULE$ = new AbstractLogicalPlanBuilder$();
    private static final InputPosition.Range pos = InputPosition$.MODULE$.NONE();

    public <T, IMPL extends AbstractLogicalPlanBuilder<T, IMPL>> boolean $lessinit$greater$default$2() {
        return true;
    }

    public <T, IMPL extends AbstractLogicalPlanBuilder<T, IMPL>> int $lessinit$greater$default$3() {
        return 0;
    }

    public <T, IMPL extends AbstractLogicalPlanBuilder<T, IMPL>> CypherVersion $lessinit$greater$default$4() {
        return CypherVersion.Legacy.legacyVersion();
    }

    public InputPosition.Range pos() {
        return pos;
    }

    public CreatePattern createPattern(Seq<CreateNode> nodes, Seq<CreateRelationship> relationships) {
        return new CreatePattern((Seq)nodes.$plus$plus(relationships));
    }

    public Seq<CreateNode> createPattern$default$1() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<CreateRelationship> createPattern$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public CreateNode createNode(String node, Seq<String> labels) {
        return this.createNodeFull(node, labels, this.createNodeFull$default$3(), this.createNodeFull$default$4());
    }

    public CreateNode createNodeWithDynamicLabels(String node, Seq<Expression> dynamicLabels) {
        String x$1 = node;
        Seq<Expression> x$2 = dynamicLabels;
        Seq<String> x$3 = this.createNodeFullExpression$default$2();
        Option<Expression> x$4 = this.createNodeFullExpression$default$4();
        return this.createNodeFullExpression(x$1, x$3, x$2, x$4);
    }

    public CreateNode createNodeWithProperties(String node, Seq<String> labels, String properties) {
        String x$1 = node;
        Seq<String> x$2 = labels;
        Some x$3 = new Some((Object)Parser$.MODULE$.Latest().parseExpression(properties));
        Seq<Expression> x$4 = this.createNodeFullExpression$default$3();
        return this.createNodeFullExpression(x$1, x$2, x$4, (Option<Expression>)x$3);
    }

    public CreateNode createNodeWithProperties(String node, Seq<String> labels, MapExpression properties) {
        String x$1 = node;
        Seq<String> x$2 = labels;
        Some x$3 = new Some((Object)properties);
        Seq<Expression> x$4 = this.createNodeFullExpression$default$3();
        return this.createNodeFullExpression(x$1, x$2, x$4, (Option<Expression>)x$3);
    }

    public CreateNode createNodeFull(String node, Seq<String> labels, Seq<String> dynamicLabels, Option<String> properties) {
        return this.createNodeFullExpression(node, labels, (Seq<Expression>)((Seq)dynamicLabels.map((Function1 & Serializable)text -> Parser$.MODULE$.Latest().parseExpression((String)text))), (Option<Expression>)properties.map((Function1 & Serializable)text -> Parser$.MODULE$.Latest().parseExpression((String)text)));
    }

    public Seq<String> createNodeFull$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<String> createNodeFull$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<String> createNodeFull$default$4() {
        return None$.MODULE$;
    }

    public CreateNode createNodeFullExpression(String node, Seq<String> labels, Seq<Expression> dynamicLabels, Option<Expression> properties) {
        return new CreateNode(UnPositionedVariable$.MODULE$.varFor(node), ((IterableOnceOps)labels.map((Function1 & Serializable)x$237 -> new LabelName(x$237, (InputPosition)MODULE$.pos()))).toSet(), dynamicLabels.toSet(), properties);
    }

    public Seq<String> createNodeFullExpression$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<Expression> createNodeFullExpression$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<Expression> createNodeFullExpression$default$4() {
        return None$.MODULE$;
    }

    public CreateRelationship createRelationship(String relationship, String left, String typ, String right, SemanticDirection direction, Option<String> properties) {
        Option props = properties.map((Function1 & Serializable)text -> Parser$.MODULE$.Latest().parseExpression((String)text));
        if (props.exists((Function1 & Serializable)x$238 -> BoxesRunTime.boxToBoolean((boolean)AbstractLogicalPlanBuilder$.$anonfun$createRelationship$2(x$238)))) {
            throw new IllegalArgumentException("Property must be a Map Expression");
        }
        return this.createRelationshipFull(relationship, left, (RelTypeExpression)new RelTypeName(typ, (InputPosition)this.pos()), right, direction, (Option<Expression>)props);
    }

    public SemanticDirection createRelationship$default$5() {
        return SemanticDirection.OUTGOING$.MODULE$;
    }

    public Option<String> createRelationship$default$6() {
        return None$.MODULE$;
    }

    public CreateRelationship createRelationshipWithDynamicType(String relationship, String left, String typeExpr, String right, SemanticDirection direction, Option<String> properties) {
        Expression dynamicType = Parser$.MODULE$.Latest().parseExpression(typeExpr);
        Option props = properties.map((Function1 & Serializable)text -> Parser$.MODULE$.Latest().parseExpression((String)text));
        if (props.exists((Function1 & Serializable)x$239 -> BoxesRunTime.boxToBoolean((boolean)AbstractLogicalPlanBuilder$.$anonfun$createRelationshipWithDynamicType$2(x$239)))) {
            throw new IllegalArgumentException("Property must be a Map Expression");
        }
        return this.createRelationshipFull(relationship, left, (RelTypeExpression)new DynamicRelTypeExpression(dynamicType, DynamicRelTypeExpression$.MODULE$.apply$default$2(), (InputPosition)this.pos()), right, direction, (Option<Expression>)props);
    }

    public SemanticDirection createRelationshipWithDynamicType$default$5() {
        return SemanticDirection.OUTGOING$.MODULE$;
    }

    public Option<String> createRelationshipWithDynamicType$default$6() {
        return None$.MODULE$;
    }

    public CreateRelationship createRelationshipExpression(String relationship, String left, String typ, String right, SemanticDirection direction, Option<MapExpression> properties) {
        return this.createRelationshipFull(relationship, left, (RelTypeExpression)new RelTypeName(typ, (InputPosition)this.pos()), right, direction, properties);
    }

    public SemanticDirection createRelationshipExpression$default$5() {
        return SemanticDirection.OUTGOING$.MODULE$;
    }

    public Option<MapExpression> createRelationshipExpression$default$6() {
        return None$.MODULE$;
    }

    public CreateRelationship createRelationshipFull(String relationship, String left, RelTypeExpression typ, String right, SemanticDirection direction, Option<Expression> properties) {
        return new CreateRelationship(UnPositionedVariable$.MODULE$.varFor(relationship), UnPositionedVariable$.MODULE$.varFor(left), typ, UnPositionedVariable$.MODULE$.varFor(right), direction, properties);
    }

    public SemanticDirection createRelationshipFull$default$5() {
        return SemanticDirection.OUTGOING$.MODULE$;
    }

    public Option<Expression> createRelationshipFull$default$6() {
        return None$.MODULE$;
    }

    public SetMutatingPattern setNodeProperty(String node, String key, String value) {
        return new SetNodePropertyPattern(UnPositionedVariable$.MODULE$.varFor(node), new PropertyKeyName(key, (InputPosition)InputPosition$.MODULE$.NONE()), Parser$.MODULE$.Latest().parseExpression(value));
    }

    public SetMutatingPattern setNodeProperties(String node, Seq<Tuple2<String, String>> items) {
        return new SetNodePropertiesPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)items.map((Function1 & Serializable)i -> new Tuple2((Object)new PropertyKeyName((String)i._1(), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)Parser$.MODULE$.Latest().parseExpression((String)i._2()))));
    }

    public SetMutatingPattern setNodePropertiesFromMap(String node, String map, boolean removeOtherProps) {
        return new SetNodePropertiesFromMapPattern(UnPositionedVariable$.MODULE$.varFor(node), Parser$.MODULE$.Latest().parseExpression(map), removeOtherProps);
    }

    public boolean setNodePropertiesFromMap$default$3() {
        return true;
    }

    public SetMutatingPattern setRelationshipProperty(String relationship, String key, String value) {
        return new SetRelationshipPropertyPattern(UnPositionedVariable$.MODULE$.varFor(relationship), new PropertyKeyName(key, (InputPosition)InputPosition$.MODULE$.NONE()), Parser$.MODULE$.Latest().parseExpression(value));
    }

    public SetMutatingPattern setRelationshipProperties(String rel, Seq<Tuple2<String, String>> items) {
        return new SetRelationshipPropertiesPattern(UnPositionedVariable$.MODULE$.varFor(rel), (Seq)items.map((Function1 & Serializable)i -> new Tuple2((Object)new PropertyKeyName((String)i._1(), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)Parser$.MODULE$.Latest().parseExpression((String)i._2()))));
    }

    public SetMutatingPattern setRelationshipPropertiesFromMap(String node, String map, boolean removeOtherProps) {
        return new SetRelationshipPropertiesFromMapPattern(UnPositionedVariable$.MODULE$.varFor(node), Parser$.MODULE$.Latest().parseExpression(map), removeOtherProps);
    }

    public boolean setRelationshipPropertiesFromMap$default$3() {
        return true;
    }

    public SetMutatingPattern setProperty(String entity, String key, String value) {
        return new SetPropertyPattern(Parser$.MODULE$.Latest().parseExpression(entity), new PropertyKeyName(key, (InputPosition)InputPosition$.MODULE$.NONE()), Parser$.MODULE$.Latest().parseExpression(value));
    }

    public SetMutatingPattern setDynamicProperty(String entity, String key, String value) {
        return new SetDynamicPropertyPattern(Parser$.MODULE$.Latest().parseExpression(entity), Parser$.MODULE$.Latest().parseExpression(key), Parser$.MODULE$.Latest().parseExpression(value));
    }

    public SetMutatingPattern setProperties(String entity, Seq<Tuple2<String, String>> items) {
        return new SetPropertiesPattern(Parser$.MODULE$.Latest().parseExpression(entity), (Seq)items.map((Function1 & Serializable)i -> new Tuple2((Object)new PropertyKeyName((String)i._1(), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)Parser$.MODULE$.Latest().parseExpression((String)i._2()))));
    }

    public SetMutatingPattern setPropertyFromMap(String entity, String map, boolean removeOtherProps) {
        return new SetPropertiesFromMapPattern(Parser$.MODULE$.Latest().parseExpression(entity), Parser$.MODULE$.Latest().parseExpression(map), removeOtherProps);
    }

    public boolean setPropertyFromMap$default$3() {
        return true;
    }

    public SetMutatingPattern setLabel(String node, Seq<String> labels) {
        return new SetLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)labels.map((Function1 & Serializable)l -> new LabelName(l, (InputPosition)InputPosition$.MODULE$.NONE())), (Seq)package$.MODULE$.Seq().empty());
    }

    public SetMutatingPattern setLabel(String node, Seq<String> staticLabels, Seq<String> dynamicLabelExpressions) {
        return new SetLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)staticLabels.map((Function1 & Serializable)l -> new LabelName(l, (InputPosition)InputPosition$.MODULE$.NONE())), (Seq)dynamicLabelExpressions.map((Function1 & Serializable)e -> Parser$.MODULE$.Latest().parseExpression((String)e)));
    }

    public SetMutatingPattern setDynamicLabel(String node, Seq<String> labels) {
        return new SetLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)package$.MODULE$.Seq().empty(), (Seq)labels.map((Function1 & Serializable)l -> Parser$.MODULE$.Latest().parseExpression((String)l)));
    }

    public RemoveLabelPattern removeLabel(String node, Seq<String> labels) {
        return new RemoveLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)labels.map((Function1 & Serializable)l -> new LabelName(l, (InputPosition)InputPosition$.MODULE$.NONE())), (Seq)package$.MODULE$.Seq().empty());
    }

    public SetMutatingPattern removeLabel(String node, Seq<String> staticLabels, Seq<String> dynamicLabelExpressions) {
        return new RemoveLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)staticLabels.map((Function1 & Serializable)l -> new LabelName(l, (InputPosition)InputPosition$.MODULE$.NONE())), (Seq)dynamicLabelExpressions.map((Function1 & Serializable)e -> Parser$.MODULE$.Latest().parseExpression((String)e)));
    }

    public SetMutatingPattern removeDynamicLabel(String node, Seq<String> labels) {
        return new RemoveLabelPattern(UnPositionedVariable$.MODULE$.varFor(node), (Seq)package$.MODULE$.Seq().empty(), (Seq)labels.map((Function1 & Serializable)l -> Parser$.MODULE$.Latest().parseExpression((String)l)));
    }

    public DeleteExpression delete(String entity, boolean forced) {
        return new DeleteExpression(Parser$.MODULE$.Latest().parseExpression(entity), forced);
    }

    public boolean delete$default$2() {
        return false;
    }

    public AndsReorderable andsReorderable(Seq<Object> predicateExpressionsOrStrings) {
        Seq predicates = (Seq)predicateExpressionsOrStrings.map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                return Parser$.MODULE$.Latest().parseExpression(string);
            }
            if (object instanceof Expression) {
                Expression expression = (Expression)object;
                return expression;
            }
            throw new IllegalArgumentException("Expected Expression or String, got [" + object.getClass().getSimpleName() + "] " + object + "}");
        });
        return new AndsReorderable(ListSet$.MODULE$.from((IterableOnce)predicates), (InputPosition)this.pos());
    }

    public Column column(String name, Seq<String> cachedProperties) {
        return new Column(UnPositionedVariable$.MODULE$.varFor(name), ((IterableOnceOps)cachedProperties.map((Function1 & Serializable)cp -> {
            CachedProperty qual$1 = (CachedProperty)Parser$.MODULE$.Latest().parseExpression((String)cp);
            boolean x$1 = false;
            LogicalVariable x$2 = qual$1.copy$default$1();
            LogicalVariable x$3 = qual$1.copy$default$2();
            PropertyKeyName x$4 = qual$1.copy$default$3();
            EntityType x$5 = qual$1.copy$default$4();
            boolean x$6 = qual$1.copy$default$5();
            InputPosition.Range x$7 = MODULE$.pos();
            return qual$1.copy(x$2, x$3, x$4, x$5, x$6, false, (InputPosition)x$7);
        })).toSet());
    }

    public CoerceToPredicate coerceToPredicate(String expression) {
        return new CoerceToPredicate(Parser$.MODULE$.Latest().parseExpression(expression));
    }

    public static final /* synthetic */ boolean $anonfun$createRelationship$2(Expression x$238) {
        return !(x$238 instanceof MapExpression);
    }

    public static final /* synthetic */ boolean $anonfun$createRelationshipWithDynamicType$2(Expression x$239) {
        return !(x$239 instanceof MapExpression);
    }

    private AbstractLogicalPlanBuilder$() {
    }
}

