/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.javacc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.neo4j.cypher.internal.parser.javacc.AbstractCharStream;

public class JavaCharStream
extends AbstractCharStream {
    protected static final int NEXTCHAR_BUF_SIZE = 4096;
    protected char[] nextCharBuf = new char[4096];
    protected int nextCharInd = -1;
    protected Reader inputStream;

    @Override
    protected int streamRead(char[] buffer, int offset, int len) throws IOException {
        return this.inputStream.read(buffer, offset, len);
    }

    @Override
    protected void streamClose() throws IOException {
        this.inputStream.close();
    }

    @Override
    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int i = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (i == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += i;
        }
        catch (IOException ex) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw ex;
        }
    }

    protected char readByte() throws IOException {
        ++this.nextCharInd;
        if (this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    @Override
    public char beginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.tokenBegin = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    protected void adjustBuffSize() {
        if (this.available == this.bufsize) {
            if (this.tokenBegin > 2048) {
                this.bufpos = 0;
                this.available = this.tokenBegin;
            } else {
                this.expandBuff(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < 2048) {
            this.expandBuff(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            ++this.bufpos;
            if (this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos == this.available) {
            this.adjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.readByte();
        if (c == '\\') {
            if (this.isTrackLineColumn()) {
                this.updateLineColumn(c);
            }
            int backSlashCnt = 1;
            while (true) {
                ++this.bufpos;
                if (this.bufpos == this.available) {
                    this.adjustBuffSize();
                }
                try {
                    this.buffer[this.bufpos] = c = this.readByte();
                    if (c != '\\') {
                        if (this.isTrackLineColumn()) {
                            this.updateLineColumn(c);
                        }
                        if (c == 'u' && (backSlashCnt & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.bufsize - 1;
                            break;
                        }
                        this.backup(backSlashCnt);
                        return '\\';
                    }
                }
                catch (IOException e) {
                    if (backSlashCnt > 1) {
                        this.backup(backSlashCnt - 1);
                    }
                    return '\\';
                }
                if (this.isTrackLineColumn()) {
                    this.updateLineColumn(c);
                }
                ++backSlashCnt;
            }
            try {
                while ((c = this.readByte()) == 'u') {
                    ++this.column;
                }
                this.buffer[this.bufpos] = c = (char)(JavaCharStream.hexval(c) << 12 | JavaCharStream.hexval(this.readByte()) << 8 | JavaCharStream.hexval(this.readByte()) << 4 | JavaCharStream.hexval(this.readByte()));
                this.column += 4;
            }
            catch (IOException e) {
                throw new IllegalStateException("Invalid escape character at line " + this.line + " column " + this.column + ".");
            }
            if (backSlashCnt == 1) {
                return c;
            }
            this.backup(backSlashCnt - 1);
            return '\\';
        }
        if (this.isTrackLineColumn()) {
            this.updateLineColumn(c);
        }
        return c;
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        super(startline, startcolumn, buffersize);
        this.inputStream = dstream;
    }

    public JavaCharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public JavaCharStream(Reader dstream) {
        this(dstream, 1, 1, 4096);
    }

    public void reInit(Reader dstream) {
        this.reInit(dstream, 1, 1, 4096);
    }

    public void reInit(Reader dstream, int startline, int startcolumn) {
        this.reInit(dstream, startline, startcolumn, 4096);
    }

    public void reInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.nextCharBuf = new char[4096];
        this.nextCharInd = -1;
        this.inputStream = dstream;
        super.reInit(startline, startcolumn, buffersize);
    }

    public JavaCharStream(InputStream dstream, Charset encoding, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public JavaCharStream(InputStream dstream, Charset encoding, int startline, int startcolumn) {
        this(dstream, encoding, startline, startcolumn, 4096);
    }

    public JavaCharStream(InputStream dstream, Charset encoding) {
        this(dstream, encoding, 1, 1, 4096);
    }

    public void reInit(InputStream dstream, Charset encoding) {
        this.reInit(dstream, encoding, 1, 1, 4096);
    }

    public void reInit(InputStream dstream, Charset encoding, int startline, int startcolumn) {
        this.reInit(dstream, encoding, startline, startcolumn, 4096);
    }

    public void reInit(InputStream dstream, Charset encoding, int startline, int startcolumn, int buffersize) {
        this.reInit(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    @Override
    public void done() {
        this.nextCharBuf = null;
        super.done();
    }
}

