/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.converters;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.AnonymousPatternPart;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.NamedPatternPart;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.NonPrefixedPatternPart;
import org.neo4j.cypher.internal.expressions.ParenthesizedPath;
import org.neo4j.cypher.internal.expressions.PathConcatenation;
import org.neo4j.cypher.internal.expressions.PathFactor;
import org.neo4j.cypher.internal.expressions.PathPatternPart;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.PatternPartWithSelector;
import org.neo4j.cypher.internal.expressions.QuantifiedPath;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.ShortestPathsPatternPart;
import org.neo4j.cypher.internal.expressions.SimplePattern;
import org.neo4j.cypher.internal.expressions.UnPositionedVariable$;
import org.neo4j.cypher.internal.expressions.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.ExhaustiveNodeConnection;
import org.neo4j.cypher.internal.ir.ExhaustivePathPattern;
import org.neo4j.cypher.internal.ir.NodeConnection;
import org.neo4j.cypher.internal.ir.PathPattern;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QuantifiedPathPattern;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.SelectivePathPattern;
import org.neo4j.cypher.internal.ir.ShortestRelationshipPattern;
import org.neo4j.cypher.internal.ir.converters.QuantifiedPathPatternConverters$;
import org.neo4j.cypher.internal.ir.converters.SimplePatternConverters$;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006\u0001\u0002!I!\u0011\u0005\u0006\u0015\u0002!Ia\u0013\u0005\u0006E\u0002!Ia\u0019\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r%!\u0005)biR,'O\\\"p]Z,'\u000f^3sg*\u0011q\u0002E\u0001\u000bG>tg/\u001a:uKJ\u001c(BA\t\u0013\u0003\tI'O\u0003\u0002\u0014)\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0016-\u000511-\u001f9iKJT!a\u0006\r\u0002\u000b9,w\u000e\u000e6\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g\u0003y\tgn\u001c8z[>,8OV1sS\u0006\u0014G.\u001a(b[\u0016<UM\\3sCR|'\u000f\u0005\u0002%O5\tQE\u0003\u0002'%\u0005!Q\u000f^5m\u0013\tASE\u0001\u0010B]>t\u00170\\8vgZ\u000b'/[1cY\u0016t\u0015-\\3HK:,'/\u0019;pe\u00061A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\b\t\u000b\t\u0012\u0001\u0019A\u0012\u0002\u001d\r|gN^3siB\u000bG\u000f^3s]R\u0011\u0001\u0007\u000e\t\u0003cIj\u0011\u0001E\u0005\u0003gA\u0011A\u0002U1uQB\u000bG\u000f^3s]NDQ!N\u0002A\u0002Y\nq\u0001]1ui\u0016\u0014h\u000e\u0005\u00028{9\u0011\u0001hO\u0007\u0002s)\u0011!HE\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002=s\u00059\u0001+\u0019;uKJt\u0017B\u0001 @\u0005!1uN]'bi\u000eD'B\u0001\u001f:\u0003I\u0019wN\u001c<feR\u0004\u0016\r\u001e;fe:\u0004\u0016M\u001d;\u0015\u0005\t+\u0005CA\u0019D\u0013\t!\u0005CA\u0006QCRD\u0007+\u0019;uKJt\u0007\"\u0002$\u0005\u0001\u00049\u0015a\u00039biR,'O\u001c)beR\u0004\"\u0001\u000f%\n\u0005%K$a\u0006)biR,'O\u001c)beR<\u0016\u000e\u001e5TK2,7\r^8s\u0003m\u0019wN\u001c<feR\fen\u001c8z[>,8\u000fU1ui\u0016\u0014h\u000eU1siR!!\tT+^\u0011\u0015iU\u00011\u0001O\u0003!\u0019X\r\\3di>\u0014\bCA(S\u001d\tA\u0004+\u0003\u0002Rs\u0005Y\u0001+\u0019;uKJt\u0007+\u0019:u\u0013\t\u0019FK\u0001\u0005TK2,7\r^8s\u0015\t\t\u0016\bC\u0003W\u000b\u0001\u0007q+\u0001\u0005qCRDg*Y7f!\ri\u0002LW\u0005\u00033z\u0011aa\u00149uS>t\u0007C\u0001\u001d\\\u0013\ta\u0016HA\bM_\u001eL7-\u00197WCJL\u0017M\u00197f\u0011\u0015qV\u00011\u0001`\u0003Q\tgn\u001c8z[>,8\u000fU1ui\u0016\u0014h\u000eU1siB\u0011\u0001\bY\u0005\u0003Cf\u0012A#\u00118p]flw.^:QCR$XM\u001d8QCJ$\u0018!I2p]Z,'\u000f^*i_J$Xm\u001d;QCRD\u0007+\u0019;uKJtW\t\\3nK:$Hc\u00013hYB\u0011\u0011'Z\u0005\u0003MB\u0011AcU3mK\u000e$\u0018N^3QCRD\u0007+\u0019;uKJt\u0007\"\u00025\u0007\u0001\u0004I\u0017A\u00049biR,'O\\#mK6,g\u000e\u001e\t\u0003q)L!a[\u001d\u0003\u001dA\u000bG\u000f^3s]\u0016cW-\\3oi\")QJ\u0002a\u0001[B\u0011aN \b\u0003_rt!\u0001]>\u000f\u0005EThB\u0001:z\u001d\t\u0019\bP\u0004\u0002uo6\tQO\u0003\u0002w5\u00051AH]8pizJ\u0011!G\u0005\u0003/aI!!\u0006\f\n\u0005M!\u0012BA\t\u0013\u0013\ti\b#\u0001\u000bTK2,7\r^5wKB\u000bG\u000f\u001b)biR,'O\\\u0005\u0003'~T!! \t\u0002=\r|gN^3siNCwN\u001d;fgR\u0004\u0016\r\u001e5QCR$XM\u001d8QCJ$Hc\u00023\u0002\u0006\u0005=\u00111\u0004\u0005\b\u0003\u000f9\u0001\u0019AA\u0005\u0003\u0011\u0001\u0018M\u001d;\u0011\u0007a\nY!C\u0002\u0002\u000ee\u0012aCT8o!J,g-\u001b=fIB\u000bG\u000f^3s]B\u000b'\u000f\u001e\u0005\b\u0003#9\u0001\u0019AA\n\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0003\u001e1\u0006U\u0001c\u0001\u001d\u0002\u0018%\u0019\u0011\u0011D\u001d\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003N\u000f\u0001\u0007Q.\u0001\u0016d_:4XM\u001d;V]^\u0014\u0018\r\u001d9fINCwN\u001d;fgR\u0004\u0016\r\u001e5QCR$XM\u001d8FY\u0016lWM\u001c;\u0015\u000f\u0011\f\t#!\n\u00020!1\u00111\u0005\u0005A\u0002%\fq!\u001a7f[\u0016tG\u000fC\u0004\u0002(!\u0001\r!!\u000b\u0002\u0015M,G.Z2uS>t7\u000fE\u00022\u0003WI1!!\f\u0011\u0005)\u0019V\r\\3di&|gn\u001d\u0005\u0006\u001b\"\u0001\r!\\\u0001\u0016G>tg/\u001a:u!\u0006$H/\u001a:o\u000b2,W.\u001a8u)\u0011\t)$!\u0011\u0011\u000bE\n9$a\u000f\n\u0007\u0005e\u0002CA\u000bFq\"\fWo\u001d;jm\u0016\u0004\u0016\r\u001e5QCR$XM\u001d8\u0011\u0007E\ni$C\u0002\u0002@A\u0011\u0001$\u0012=iCV\u001cH/\u001b<f\u001d>$WmQ8o]\u0016\u001cG/[8o\u0011\u0015A\u0017\u00021\u0001j\u0003I\u0019wN\u001c<feR\u0004\u0016\r\u001e5GC\u000e$xN]:\u0015\t\u0005U\u0012q\t\u0005\b\u0003\u0013R\u0001\u0019AA&\u0003\u001d1\u0017m\u0019;peN\u0004b!!\u0014\u0002X\u0005uc\u0002BA(\u0003'r1\u0001^A)\u0013\u0005y\u0012bAA+=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA-\u00037\u0012A\u0001T5ti*\u0019\u0011Q\u000b\u0010\u0011\u0007a\ny&C\u0002\u0002be\u0012!\u0002U1uQ\u001a\u000b7\r^8s\u0003U)hNZ8mIB\u000bG\u000f\u001b$bGR|'o\u001d+bS2$B!a\u001a\u0002\u0000A1\u0011QJA5\u0003[JA!a\u001b\u0002\\\tAA*\u0019>z\u0019&\u001cH\u000fE\u0004\u001e\u0003_\n\u0019(!\u001f\n\u0007\u0005EdD\u0001\u0004UkBdWM\r\t\u0004q\u0005U\u0014bAA<s\tq\u0011+^1oi&4\u0017.\u001a3QCRD\u0007c\u0001\u001d\u0002|%\u0019\u0011QP\u001d\u0003\u001bMKW\u000e\u001d7f!\u0006$H/\u001a:o\u0011\u001d\tIe\u0003a\u0001\u0003\u0017\n\u0001CY;jY\u0012\u0004\u0016\r\u001e5QCR$XM\u001d8\u0015\r\u0005U\u0012QQAE\u0011\u001d\t9\t\u0004a\u0001\u0003s\nA\u0001[3bI\"9\u00111\u0012\u0007A\u0002\u0005\u001d\u0014\u0001\u0002;bS2\u0004")
public class PatternConverters {
    private final AnonymousVariableNameGenerator anonymousVariableNameGenerator;

    public List convertPattern(Pattern.ForMatch pattern) {
        return pattern.patternParts().toList().map((Function1 & Serializable)patternPart -> this.convertPatternPart((PatternPartWithSelector)patternPart));
    }

    private PathPattern convertPatternPart(PatternPartWithSelector patternPart) {
        NonPrefixedPatternPart nonPrefixedPatternPart = patternPart.part();
        if (nonPrefixedPatternPart instanceof NamedPatternPart) {
            NamedPatternPart namedPatternPart = (NamedPatternPart)nonPrefixedPatternPart;
            Variable variable = namedPatternPart.variable();
            AnonymousPatternPart anonymousPatternPart = namedPatternPart.patternPart();
            return this.convertAnonymousPatternPart(patternPart.selector(), (Option<LogicalVariable>)new Some((Object)variable), anonymousPatternPart);
        }
        if (nonPrefixedPatternPart instanceof AnonymousPatternPart) {
            AnonymousPatternPart anonymousPatternPart = (AnonymousPatternPart)nonPrefixedPatternPart;
            return this.convertAnonymousPatternPart(patternPart.selector(), (Option<LogicalVariable>)None$.MODULE$, anonymousPatternPart);
        }
        throw new MatchError((Object)nonPrefixedPatternPart);
    }

    private PathPattern convertAnonymousPatternPart(PatternPart.Selector selector, Option<LogicalVariable> pathName, AnonymousPatternPart anonymousPatternPart) {
        AnonymousPatternPart anonymousPatternPart2 = anonymousPatternPart;
        if (anonymousPatternPart2 instanceof PathPatternPart) {
            PathPatternPart pathPatternPart = (PathPatternPart)anonymousPatternPart2;
            PatternElement element = pathPatternPart.element();
            PatternPart.Selector selector2 = selector;
            if (selector2 instanceof PatternPart.AllPaths) {
                return this.convertPatternElement(element);
            }
            if (selector2 instanceof PatternPart.AnyPath) {
                PatternPart.AnyPath anyPath = (PatternPart.AnyPath)selector2;
                UnsignedDecimalIntegerLiteral count = anyPath.count();
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.Any(Predef$.MODULE$.Long2long(count.value())));
            }
            if (selector2 instanceof PatternPart.AnyShortestPath) {
                PatternPart.AnyShortestPath anyShortestPath = (PatternPart.AnyShortestPath)selector2;
                UnsignedDecimalIntegerLiteral count = anyShortestPath.count();
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.Shortest(Predef$.MODULE$.Long2long(count.value())));
            }
            if (selector2 instanceof PatternPart.AllShortestPaths) {
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.ShortestGroups(1L));
            }
            if (selector2 instanceof PatternPart.ShortestGroups) {
                PatternPart.ShortestGroups shortestGroups = (PatternPart.ShortestGroups)selector2;
                UnsignedDecimalIntegerLiteral count = shortestGroups.count();
                return this.convertShortestPathPatternElement(element, new SelectivePathPattern.Selector.ShortestGroups(Predef$.MODULE$.Long2long(count.value())));
            }
            throw new MatchError((Object)selector2);
        }
        if (anonymousPatternPart2 instanceof ShortestPathsPatternPart) {
            ShortestPathsPatternPart shortestPathsPatternPart = (ShortestPathsPatternPart)anonymousPatternPart2;
            PatternElement element = shortestPathsPatternPart.element();
            boolean single = shortestPathsPatternPart.single();
            PatternElement patternElement = element;
            if (patternElement instanceof RelationshipChain) {
                RelationshipChain relationshipChain = (RelationshipChain)patternElement;
                SimplePattern leftNode = relationshipChain.element();
                RelationshipPattern relationship = relationshipChain.relationship();
                NodePattern rightNode = relationshipChain.rightNode();
                if (leftNode instanceof NodePattern) {
                    NodePattern nodePattern = (NodePattern)leftNode;
                    return new ShortestRelationshipPattern((Option<LogicalVariable>)new Some(pathName.getOrElse((Function0 & Serializable)() -> UnPositionedVariable$.MODULE$.varFor($this.anonymousVariableNameGenerator.nextName()))), SimplePatternConverters$.MODULE$.makePatternRelationship(nodePattern, relationship, rightNode), single, shortestPathsPatternPart);
                }
            }
            throw new IllegalArgumentException(shortestPathsPatternPart.name() + "() must contain a single relationship, it cannot contain a " + patternElement.productPrefix());
        }
        throw new MatchError((Object)anonymousPatternPart2);
    }

    private SelectivePathPattern convertShortestPathPatternElement(PatternElement patternElement, SelectivePathPattern.Selector selector) {
        PatternElement patternElement2 = patternElement;
        if (patternElement2 instanceof ParenthesizedPath) {
            ParenthesizedPath parenthesizedPath = (ParenthesizedPath)patternElement2;
            NonPrefixedPatternPart part = parenthesizedPath.part();
            Option predicate = parenthesizedPath.optionalWhereClause();
            return this.convertShortestPathPatternPart(part, (Option<Expression>)predicate, selector);
        }
        return this.convertUnwrappedShortestPathPatternElement(patternElement2, Selections$.MODULE$.empty(), selector);
    }

    private SelectivePathPattern convertShortestPathPatternPart(NonPrefixedPatternPart part, Option<Expression> predicate, SelectivePathPattern.Selector selector) {
        NonPrefixedPatternPart nonPrefixedPatternPart = part;
        if (nonPrefixedPatternPart instanceof PathPatternPart) {
            PathPatternPart pathPatternPart = (PathPatternPart)nonPrefixedPatternPart;
            PatternElement element = pathPatternPart.element();
            return this.convertUnwrappedShortestPathPatternElement(element, Selections$.MODULE$.from((Iterable<Expression>)Option$.MODULE$.option2Iterable(predicate)), selector);
        }
        if (nonPrefixedPatternPart instanceof ShortestPathsPatternPart) {
            ShortestPathsPatternPart shortestPathsPatternPart = (ShortestPathsPatternPart)nonPrefixedPatternPart;
            throw new IllegalArgumentException(shortestPathsPatternPart.name() + "() is not allowed inside of a parenthesised path pattern");
        }
        if (nonPrefixedPatternPart instanceof NamedPatternPart) {
            throw new IllegalArgumentException("Sub-path assignment is currently not supported");
        }
        throw new MatchError((Object)nonPrefixedPatternPart);
    }

    private SelectivePathPattern convertUnwrappedShortestPathPatternElement(PatternElement element, Selections selections, SelectivePathPattern.Selector selector) {
        ExhaustivePathPattern<ExhaustiveNodeConnection> exhaustivePathPattern = this.convertPatternElement(element);
        if (exhaustivePathPattern instanceof ExhaustivePathPattern.NodeConnections) {
            ExhaustivePathPattern.NodeConnections nodeConnections = (ExhaustivePathPattern.NodeConnections)exhaustivePathPattern;
            return new SelectivePathPattern(nodeConnections, selections, selector);
        }
        if (exhaustivePathPattern instanceof ExhaustivePathPattern.SingleNode) {
            throw new IllegalStateException("Shortest paths over a single node should have been rewritten by FixedLengthShortestToAllRewriter");
        }
        throw new MatchError(exhaustivePathPattern);
    }

    private ExhaustivePathPattern<ExhaustiveNodeConnection> convertPatternElement(PatternElement patternElement) {
        PatternElement patternElement2 = patternElement;
        if (patternElement2 instanceof SimplePattern) {
            SimplePattern simplePattern = (SimplePattern)patternElement2;
            return SimplePatternConverters$.MODULE$.convertSimplePattern(simplePattern);
        }
        if (patternElement2 instanceof PathConcatenation) {
            PathConcatenation pathConcatenation = (PathConcatenation)patternElement2;
            Seq factors = pathConcatenation.factors();
            return this.convertPathFactors((List<PathFactor>)factors.toList());
        }
        if (patternElement2 instanceof QuantifiedPath) {
            throw new IllegalArgumentException("Quantified path patterns must be concatenated with outer node patterns");
        }
        if (patternElement2 instanceof ParenthesizedPath) {
            throw new IllegalArgumentException("Parenthesised path patterns are only supported at the top level with a selective path selector");
        }
        throw new MatchError((Object)patternElement2);
    }

    private ExhaustivePathPattern<ExhaustiveNodeConnection> convertPathFactors(List<PathFactor> factors) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<PathFactor> list = factors;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            PathFactor pattern = (PathFactor)colon2.head();
            List tail = colon2.next$access$1();
            if (pattern instanceof SimplePattern) {
                SimplePattern simplePattern = (SimplePattern)pattern;
                return this.buildPathPattern(simplePattern, this.unfoldPathFactorsTail((List<PathFactor>)tail));
            }
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new IllegalArgumentException("Cannot concatenate an empty list of path factors");
        }
        if (bl) {
            PathFactor other = (PathFactor)colon2.head();
            throw new IllegalArgumentException("Concatenated path factors must start with a simple pattern, not a " + ((Product)other).productPrefix());
        }
        throw new MatchError(list);
    }

    private LazyList<Tuple2<QuantifiedPath, SimplePattern>> unfoldPathFactorsTail(List<PathFactor> factors) {
        return package$.MODULE$.LazyList().unfold(factors, (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = x0$1;
            if (Nil$.MODULE$.equals(list)) {
                return None$.MODULE$;
            }
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                PathFactor quantifiedPath = (PathFactor)colon2.head();
                List tail = colon2.next$access$1();
                if (quantifiedPath instanceof QuantifiedPath) {
                    QuantifiedPath quantifiedPath2 = (QuantifiedPath)quantifiedPath;
                    boolean bl2 = false;
                    .colon.colon colon3 = null;
                    List list2 = tail;
                    if (list2 instanceof .colon.colon) {
                        bl2 = true;
                        colon3 = (.colon.colon)list2;
                        PathFactor simplePattern = (PathFactor)colon3.head();
                        List tail2 = colon3.next$access$1();
                        if (simplePattern instanceof SimplePattern) {
                            SimplePattern simplePattern2 = (SimplePattern)simplePattern;
                            return new Some((Object)new Tuple2((Object)new Tuple2((Object)quantifiedPath2, (Object)simplePattern2), (Object)tail2));
                        }
                    }
                    if (Nil$.MODULE$.equals(list2)) {
                        throw new IllegalArgumentException("A quantified path pattern must be concatenated with a simple path pattern");
                    }
                    if (bl2) {
                        PathFactor other = (PathFactor)colon3.head();
                        throw new IllegalArgumentException("A quantified path pattern must be concatenated with a simple path pattern, not with a " + ((Product)other).productPrefix());
                    }
                    throw new MatchError((Object)list2);
                }
            }
            if (bl) {
                PathFactor other = (PathFactor)colon2.head();
                throw new IllegalArgumentException("A simple path pattern may only be concatenated with a quantified path pattern, not with a " + ((Product)other).productPrefix());
            }
            throw new MatchError((Object)list);
        });
    }

    private ExhaustivePathPattern<ExhaustiveNodeConnection> buildPathPattern(SimplePattern head, LazyList<Tuple2<QuantifiedPath, SimplePattern>> tail) {
        return (ExhaustivePathPattern)tail.foldLeft(SimplePatternConverters$.MODULE$.convertSimplePattern(head), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                ExhaustivePathPattern pathPattern = (ExhaustivePathPattern)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    QuantifiedPath quantifiedPath = (QuantifiedPath)tuple22._1();
                    SimplePattern simplePattern = (SimplePattern)tuple22._2();
                    ExhaustivePathPattern exhaustivePathPattern = pathPattern;
                    if (exhaustivePathPattern instanceof ExhaustivePathPattern.SingleNode) {
                        ExhaustivePathPattern.SingleNode singleNode = (ExhaustivePathPattern.SingleNode)exhaustivePathPattern;
                        LogicalVariable name = singleNode.variable();
                        tuple24 = new Tuple2((Object)name, (Object)Nil$.MODULE$);
                    } else if (exhaustivePathPattern instanceof ExhaustivePathPattern.NodeConnections) {
                        ExhaustivePathPattern.NodeConnections nodeConnections = (ExhaustivePathPattern.NodeConnections)exhaustivePathPattern;
                        NonEmptyList connections = nodeConnections.connections();
                        tuple24 = new Tuple2((Object)((NodeConnection)connections.last()).right(), (Object)connections.toIterable());
                    } else {
                        throw new MatchError((Object)exhaustivePathPattern);
                    }
                    Tuple2 tuple25 = tuple24;
                    if (tuple25 == null) {
                        throw new MatchError((Object)tuple25);
                    }
                    LogicalVariable previousRightMostNode = (LogicalVariable)tuple25._1();
                    Iterable previousConnections = (Iterable)tuple25._2();
                    Tuple2 tuple26 = new Tuple2((Object)previousRightMostNode, (Object)previousConnections);
                    LogicalVariable previousRightMostNode2 = (LogicalVariable)tuple26._1();
                    Iterable previousConnections2 = (Iterable)tuple26._2();
                    ExhaustivePathPattern<PatternRelationship> exhaustivePathPattern2 = SimplePatternConverters$.MODULE$.convertSimplePattern(simplePattern);
                    if (exhaustivePathPattern2 instanceof ExhaustivePathPattern.SingleNode) {
                        ExhaustivePathPattern.SingleNode singleNode = (ExhaustivePathPattern.SingleNode)exhaustivePathPattern2;
                        LogicalVariable name = singleNode.variable();
                        tuple23 = new Tuple2((Object)name, (Object)Nil$.MODULE$);
                    } else if (exhaustivePathPattern2 instanceof ExhaustivePathPattern.NodeConnections) {
                        ExhaustivePathPattern.NodeConnections nodeConnections = (ExhaustivePathPattern.NodeConnections)exhaustivePathPattern2;
                        NonEmptyList relationships2 = nodeConnections.connections();
                        tuple23 = new Tuple2((Object)((PatternRelationship)relationships2.head()).left(), (Object)relationships2.toIterable());
                    } else {
                        throw new MatchError(exhaustivePathPattern2);
                    }
                    Tuple2 tuple27 = tuple23;
                    if (tuple27 == null) {
                        throw new MatchError((Object)tuple27);
                    }
                    LogicalVariable nextLeftMostNode = (LogicalVariable)tuple27._1();
                    Iterable nextConnections = (Iterable)tuple27._2();
                    Tuple2 tuple28 = new Tuple2((Object)nextLeftMostNode, (Object)nextConnections);
                    LogicalVariable nextLeftMostNode2 = (LogicalVariable)tuple28._1();
                    Iterable nextConnections2 = (Iterable)tuple28._2();
                    QuantifiedPathPattern quantifiedPathPattern = QuantifiedPathPatternConverters$.MODULE$.convertQuantifiedPath(previousRightMostNode2, quantifiedPath, nextLeftMostNode2);
                    Iterable iterable = previousConnections2;
                    return new ExhaustivePathPattern.NodeConnections(NonEmptyList$.MODULE$.apply((Object)quantifiedPathPattern, (Seq)Nil$.MODULE$).$plus$plus$colon(iterable).$colon$plus$plus(nextConnections2));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public PatternConverters(AnonymousVariableNameGenerator anonymousVariableNameGenerator) {
        this.anonymousVariableNameGenerator = anonymousVariableNameGenerator;
    }
}

