/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.helpers.overlaps;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.ir.CreatesDynamicNodeLabels$;
import org.neo4j.cypher.internal.ir.CreatesDynamicRelationshipType$;
import org.neo4j.cypher.internal.ir.CreatesKnownPropertyKeys;
import org.neo4j.cypher.internal.ir.CreatesNoPropertyKeys$;
import org.neo4j.cypher.internal.ir.CreatesNodeLabels;
import org.neo4j.cypher.internal.ir.CreatesPropertyKeys;
import org.neo4j.cypher.internal.ir.CreatesRelationshipType;
import org.neo4j.cypher.internal.ir.CreatesStaticNodeLabels;
import org.neo4j.cypher.internal.ir.CreatesStaticRelationshipType;
import org.neo4j.cypher.internal.ir.CreatesUnknownPropertyKeys$;
import org.neo4j.cypher.internal.ir.helpers.overlaps.CreateOverlaps;
import org.neo4j.cypher.internal.ir.helpers.overlaps.CreateOverlaps$EntityPredicates$;
import org.neo4j.cypher.internal.ir.helpers.overlaps.CreateOverlaps$NodeLabelsOverlap$Dynamic$;
import org.neo4j.cypher.internal.ir.helpers.overlaps.CreateOverlaps$PropertiesOverlap$UnknownOverlap$;
import org.neo4j.cypher.internal.ir.helpers.overlaps.CreateOverlaps$RelationshipTypeOverlap$Dynamic$;
import org.neo4j.cypher.internal.ir.helpers.overlaps.Expressions$;
import org.neo4j.cypher.internal.label_expressions.SolvableLabelExpression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CreateOverlaps$ {
    public static final CreateOverlaps$ MODULE$ = new CreateOverlaps$();

    public Option<CreateOverlaps.NodeOverlap> findNodeOverlap(Seq<Expression> predicates, CreatesNodeLabels nodeLabelsToCreate, CreatesPropertyKeys propertiesToCreate) {
        Tuple2<Seq<Expression>, CreateOverlaps.EntityPredicates> tuple2 = this.extractEntityPredicates(predicates);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq unsupportedExpressions = (Seq)tuple2._1();
        CreateOverlaps.EntityPredicates nodePredicates = (CreateOverlaps.EntityPredicates)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)unsupportedExpressions, (Object)nodePredicates);
        Seq unsupportedExpressions2 = (Seq)tuple22._1();
        CreateOverlaps.EntityPredicates nodePredicates2 = (CreateOverlaps.EntityPredicates)tuple22._2();
        return this.findPropertiesOverlap(propertiesToCreate, nodePredicates2.properties()).flatMap((Function1 & Serializable)propertiesOverlap -> {
            CreatesNodeLabels createsNodeLabels = nodeLabelsToCreate;
            if (createsNodeLabels instanceof CreatesStaticNodeLabels) {
                CreatesStaticNodeLabels createsStaticNodeLabels = (CreatesStaticNodeLabels)createsNodeLabels;
                Set<LabelName> staticLabels = createsStaticNodeLabels.labelNames();
                Set labelNames = (Set)staticLabels.map((Function1 & Serializable)x$2 -> x$2.name());
                return Option$.MODULE$.when(nodePredicates2.labelExpressions().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matchesLabels(labelNames))), (Function0 & Serializable)() -> new CreateOverlaps.NodeOverlap((Seq<Expression>)unsupportedExpressions2, (CreateOverlaps.PropertiesOverlap)propertiesOverlap, new CreateOverlaps.NodeLabelsOverlap.Static(staticLabels)));
            }
            if (CreatesDynamicNodeLabels$.MODULE$.equals(createsNodeLabels)) {
                return new Some((Object)new CreateOverlaps.NodeOverlap((Seq<Expression>)unsupportedExpressions2, (CreateOverlaps.PropertiesOverlap)propertiesOverlap, CreateOverlaps$NodeLabelsOverlap$Dynamic$.MODULE$));
            }
            throw new MatchError((Object)createsNodeLabels);
        });
    }

    public Option<CreateOverlaps.RelationshipOverlap> findRelationshipOverlap(Seq<Expression> predicates, CreatesRelationshipType relationshipTypeToCreate, CreatesPropertyKeys propertiesToCreate) {
        Tuple2<Seq<Expression>, CreateOverlaps.EntityPredicates> tuple2 = this.extractEntityPredicates(predicates);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq unsupportedExpressions = (Seq)tuple2._1();
        CreateOverlaps.EntityPredicates relationshipPredicates = (CreateOverlaps.EntityPredicates)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)unsupportedExpressions, (Object)relationshipPredicates);
        Seq unsupportedExpressions2 = (Seq)tuple22._1();
        CreateOverlaps.EntityPredicates relationshipPredicates2 = (CreateOverlaps.EntityPredicates)tuple22._2();
        return this.findPropertiesOverlap(propertiesToCreate, relationshipPredicates2.properties()).flatMap((Function1 & Serializable)propertiesOverlap -> {
            CreatesRelationshipType createsRelationshipType = relationshipTypeToCreate;
            if (createsRelationshipType instanceof CreatesStaticRelationshipType) {
                CreatesStaticRelationshipType createsStaticRelationshipType = (CreatesStaticRelationshipType)createsRelationshipType;
                RelTypeName staticRelationshipType = createsStaticRelationshipType.relationshipTypeName();
                String relationshipTypeName = staticRelationshipType.name();
                return Option$.MODULE$.when(relationshipPredicates2.labelExpressions().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.matchesLabels((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{relationshipTypeName}))))), (Function0 & Serializable)() -> new CreateOverlaps.RelationshipOverlap((Seq<Expression>)unsupportedExpressions2, (CreateOverlaps.PropertiesOverlap)propertiesOverlap, new CreateOverlaps.RelationshipTypeOverlap.Static(staticRelationshipType)));
            }
            if (CreatesDynamicRelationshipType$.MODULE$.equals(createsRelationshipType)) {
                return new Some((Object)new CreateOverlaps.RelationshipOverlap((Seq<Expression>)unsupportedExpressions2, (CreateOverlaps.PropertiesOverlap)propertiesOverlap, CreateOverlaps$RelationshipTypeOverlap$Dynamic$.MODULE$));
            }
            throw new MatchError((Object)createsRelationshipType);
        });
    }

    private Tuple2<Seq<Expression>, CreateOverlaps.EntityPredicates> extractEntityPredicates(Seq<Expression> expressions) {
        Tuple2 tuple2 = ((IterableOps)expressions.flatMap((Function1 & Serializable)expression -> Expressions$.MODULE$.splitExpression((Expression)expression))).partitionMap((Function1 & Serializable)expression -> Expressions$.MODULE$.extractPropertyExpression((Expression)expression).map((Function1 & Serializable)propertyKeyName -> CreateOverlaps$EntityPredicates$.MODULE$.withProperty((PropertyKeyName)propertyKeyName)).orElse((Function0 & Serializable)() -> Expressions$.MODULE$.extractLabelExpression((Expression)expression).map((Function1 & Serializable)labelExpression -> CreateOverlaps$EntityPredicates$.MODULE$.withLabelExpression((SolvableLabelExpression)labelExpression))).toRight((Function0 & Serializable)() -> expression));
        if (tuple2 != null) {
            Seq unprocessedExpressions = (Seq)tuple2._1();
            Seq values = (Seq)tuple2._2();
            return new Tuple2((Object)unprocessedExpressions, (Object)CreateOverlaps$EntityPredicates$.MODULE$.fold((Seq<CreateOverlaps.EntityPredicates>)values));
        }
        throw new MatchError((Object)tuple2);
    }

    private Option<CreateOverlaps.PropertiesOverlap> findPropertiesOverlap(CreatesPropertyKeys propertiesToCreate, Set<PropertyKeyName> propertyKeyNames) {
        CreatesPropertyKeys createsPropertyKeys = propertiesToCreate;
        if (CreatesNoPropertyKeys$.MODULE$.equals(createsPropertyKeys)) {
            if (propertyKeyNames.isEmpty()) {
                return new Some((Object)new CreateOverlaps.PropertiesOverlap.Overlap((Set<PropertyKeyName>)Predef$.MODULE$.Set().empty()));
            }
            return None$.MODULE$;
        }
        if (createsPropertyKeys instanceof CreatesKnownPropertyKeys) {
            CreatesKnownPropertyKeys createsKnownPropertyKeys = (CreatesKnownPropertyKeys)createsPropertyKeys;
            Set<PropertyKeyName> keys = createsKnownPropertyKeys.keys();
            if (propertyKeyNames.subsetOf(keys)) {
                return new Some((Object)new CreateOverlaps.PropertiesOverlap.Overlap(propertyKeyNames));
            }
            return None$.MODULE$;
        }
        if (CreatesUnknownPropertyKeys$.MODULE$.equals(createsPropertyKeys)) {
            return new Some((Object)CreateOverlaps$PropertiesOverlap$UnknownOverlap$.MODULE$);
        }
        throw new MatchError((Object)createsPropertyKeys);
    }

    private CreateOverlaps$() {
    }
}

