/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.CurrentUser$;
import org.neo4j.cypher.internal.ast.ExecutableBy;
import org.neo4j.cypher.internal.ast.User;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowProcFuncCommandHelper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ShowProcFuncCommandHelper$ {
    public static final ShowProcFuncCommandHelper$ MODULE$ = new ShowProcFuncCommandHelper$();

    public Tuple2<Set<String>, Object> getRolesForExecutableByUser(SecurityContext securityContext, SecurityAuthorizationHandler securityHandler, Function0<GraphDatabaseService> systemGraph, Option<ExecutableBy> executableBy, String command) {
        ExecutableBy executableBy2;
        boolean bl = false;
        Some some = null;
        Option<ExecutableBy> option = executableBy;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ExecutableBy executableBy3 = (ExecutableBy)some.value();
            if (CurrentUser$.MODULE$.equals(executableBy3) && securityContext.subject().equals(AuthSubject.AUTH_DISABLED)) {
                return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        if (bl && (executableBy2 = (ExecutableBy)some.value()) instanceof User) {
            User user = (User)executableBy2;
            String name = user.name();
            if (!securityContext.subject().hasUsername(name)) {
                PermissionState allowedShowUser = securityContext.allowsAdminAction(new AdminActionOnResource(PrivilegeAction.SHOW_USER, AdminActionOnResource.DatabaseScope.ALL, Segment.ALL));
                if (!allowedShowUser.allowsAccess()) {
                    PermissionState permissionState = allowedShowUser;
                    PermissionState permissionState2 = PermissionState.EXPLICIT_DENY;
                    String violationMessage = !(permissionState != null ? !permissionState.equals(permissionState2) : permissionState2 != null) ? "Permission denied for " + command + ", requires SHOW USER privilege. Try executing SHOW USER PRIVILEGES to determine the denied privileges. In case of denied privileges, they need to be revoked (See REVOKE) and granted." : "Permission not granted for " + command + ", requires SHOW USER privilege. Try executing SHOW USER PRIVILEGES to determine the missing privileges. In case of missing privileges, they need to be granted (See GRANT).";
                    throw securityHandler.logAndGetAuthorizationException(securityContext, violationMessage);
                }
                Transaction stx = ((GraphDatabaseService)systemGraph.apply()).beginTx();
                ResourceIterator rolesResult = stx.execute("SHOW USERS YIELD user, roles WHERE user = $name RETURN roles", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)}))).asJava()).columnAs("roles");
                Set rolesSet = rolesResult.hasNext() ? CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)rolesResult.next()).asScala().toSet() : Predef$.MODULE$.Set().empty();
                stx.commit();
                return new Tuple2((Object)rolesSet, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (bl) {
            return new Tuple2((Object)CollectionConverters$.MODULE$.SetHasAsScala(securityContext.roles()).asScala().toSet(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError(option);
    }

    public List<scala.collection.immutable.Map<String, String>> getSignatureValues(java.util.List<FieldSignature> fields) {
        return CollectionConverters$.MODULE$.ListHasAsScala(fields).asScala().toList().map((Function1 & Serializable)f -> {
            scala.collection.immutable.Map values = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)f.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)f.neo4jType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)f.toString())}));
            Optional optional = f.defaultValue();
            if (optional.isPresent()) {
                return (scala.collection.immutable.Map)values.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default"), (Object)((DefaultParameterValue)optional.get()).toString())})));
            }
            return values;
        });
    }

    public ListValue fieldDescriptions(List<scala.collection.immutable.Map<String, String>> fields) {
        List fieldMaps = fields.map((Function1 & Serializable)f -> {
            String[] keys = (String[])((Object[])new String[]{"name", "type", "description"});
            AnyValue[] values = (AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)((String)f.apply((Object)"name"))), Values.stringValue((String)((String)f.apply((Object)"type"))), Values.stringValue((String)((String)f.apply((Object)"description")))});
            Option option = f.get((Object)"default");
            if (option.isDefined()) {
                return VirtualValues.map((String[])((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])keys), (Object)"default", ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Object)Values.stringValue((String)((String)option.get())), ClassTag$.MODULE$.apply(AnyValue.class))));
            }
            return VirtualValues.map((String[])keys, (AnyValue[])values);
        });
        return VirtualValues.fromList((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)fieldMaps).asJava());
    }

    public ShowProcFuncCommandHelper.Privileges getPrivileges(GraphDatabaseService systemGraph, String executeSegment) {
        List list;
        Transaction stx = systemGraph.beginTx();
        String execQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action='execute' AND segment STARTS WITH $seg RETURN access, segment, collect(role) as roles";
        Result executePrivilegesRes = stx.execute(execQuery, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seg"), (Object)executeSegment)}))).asJava());
        List executePrivileges = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)executePrivilegesRes).asScala().map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.MapHasAsScala(x$1).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toList();
        String boostQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action STARTS WITH 'execute_boosted' AND segment STARTS WITH $seg RETURN access, segment, collect(role) as roles";
        Result boostedExecutePrivilegesRes = stx.execute(boostQuery, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seg"), (Object)executeSegment)}))).asJava());
        List boostedExecutePrivileges = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)boostedExecutePrivilegesRes).asScala().map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.MapHasAsScala(x$2).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toList();
        if (executeSegment.equals("PROCEDURE")) {
            String adminQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action='execute_admin' RETURN access, collect(role) as roles";
            list = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)stx.execute(adminQuery)).asScala().map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.MapHasAsScala(x$3).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toList();
        } else {
            list = package$.MODULE$.List().empty();
        }
        List adminPrivileges = list;
        String allDbmsQuery = "SHOW ALL PRIVILEGES YIELD * WHERE action IN ['admin', 'dbms_actions'] RETURN access, collect(role) as roles";
        List allDbmsPrivileges = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)stx.execute(allDbmsQuery)).asScala().map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.MapHasAsScala(x$4).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toList();
        stx.commit();
        return new ShowProcFuncCommandHelper.Privileges((List<scala.collection.immutable.Map<String, Object>>)executePrivileges, (List<scala.collection.immutable.Map<String, Object>>)boostedExecutePrivileges, (List<scala.collection.immutable.Map<String, Object>>)allDbmsPrivileges, (List<scala.collection.immutable.Map<String, Object>>)adminPrivileges);
    }

    public Tuple3<Set<String>, Set<String>, Object> roles(String name, boolean isAdmin, ShowProcFuncCommandHelper.Privileges privileges, Set<String> userRoles) {
        Tuple4 tuple4;
        if (isAdmin) {
            Set grantedExecute = (Set)privileges.grantedAdminExecuteRoles().$plus$plus(privileges.grantedBoostedExecuteRoles(name));
            Set deniedBoosted = (Set)privileges.deniedAdminExecuteRoles().$plus$plus(privileges.deniedBoostedExecuteRoles(name));
            Set deniedExecute = (Set)privileges.deniedExecuteRoles(name).$plus$plus((IterableOnce)deniedBoosted);
            v0 = new Tuple4((Object)grantedExecute, (Object)grantedExecute, (Object)deniedExecute, (Object)deniedBoosted);
        } else {
            Set<String> grantedExecute = privileges.grantedExecuteRoles(name);
            Set<String> grantedBoosted = privileges.grantedBoostedExecuteRoles(name);
            Set<String> deniedExecute = privileges.deniedExecuteRoles(name);
            Set<String> deniedBoosted = privileges.deniedBoostedExecuteRoles(name);
            v0 = tuple4 = new Tuple4(grantedExecute, grantedBoosted, deniedExecute, deniedBoosted);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Set grantedExecuteRoles = (Set)tuple4._1();
        Set grantedBoostedRoles = (Set)tuple4._2();
        Set deniedExecuteRoles = (Set)tuple4._3();
        Set deniedBoostedRoles = (Set)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)grantedExecuteRoles, (Object)grantedBoostedRoles, (Object)deniedExecuteRoles, (Object)deniedBoostedRoles);
        Set grantedExecuteRoles2 = (Set)tuple42._1();
        Set grantedBoostedRoles2 = (Set)tuple42._2();
        Set deniedExecuteRoles2 = (Set)tuple42._3();
        Set deniedBoostedRoles2 = (Set)tuple42._4();
        Set allowedBoostedRoles = (Set)grantedBoostedRoles2.$minus$minus((IterableOnce)deniedBoostedRoles2);
        Set allowedExecuteRoles = (Set)((SetOps)grantedExecuteRoles2.$plus$plus((IterableOnce)allowedBoostedRoles)).$minus$minus((IterableOnce)deniedExecuteRoles2);
        boolean allowedExplicit = userRoles.exists((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)grantedExecuteRoles2.contains((Object)r))) && userRoles.forall((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowProcFuncCommandHelper$.$anonfun$roles$2(deniedExecuteRoles2, r)));
        boolean allowedImplicit = userRoles.exists((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)grantedBoostedRoles2.contains((Object)r))) && userRoles.forall((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowProcFuncCommandHelper$.$anonfun$roles$4(deniedBoostedRoles2, deniedExecuteRoles2, r)));
        boolean allowedExecute = allowedExplicit || allowedImplicit;
        return new Tuple3((Object)allowedExecuteRoles, (Object)allowedBoostedRoles, (Object)BoxesRunTime.boxToBoolean((boolean)allowedExecute));
    }

    public Tuple2<ListValue, ListValue> roleValues(Set<String> allowedExecuteRoles, Set<String> allowedBoostedRoles) {
        List allowedExecute = ((List)allowedExecuteRoles.toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1));
        List allowedBoosted = ((List)allowedBoostedRoles.toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1));
        return new Tuple2((Object)VirtualValues.fromList((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)allowedExecute).asJava()), (Object)VirtualValues.fromList((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)allowedBoosted).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$roles$2(Set deniedExecuteRoles$1, String r) {
        return !deniedExecuteRoles$1.contains((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$roles$4(Set deniedBoostedRoles$1, Set deniedExecuteRoles$1, String r) {
        return !deniedBoostedRoles$1.contains((Object)r) && !deniedExecuteRoles$1.contains((Object)r);
    }

    private ShowProcFuncCommandHelper$() {
    }
}

