/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.predicates;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.BuildUp$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Checker;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.NullListChecker$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.SetChecker;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\b\u0011\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)A\b\u0001C\u0001{!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB(\u0001A\u0003%1\tC\u0004Q\u0001\t\u0007I\u0011B)\t\ri\u0003\u0001\u0015!\u0003S\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015A\u0007\u0001\"\u0003j\u0011\u0015Y\u0007\u0001\"\u0011m\u000f\u001d\u0001\b#!A\t\u0002E4qa\u0004\t\u0002\u0002#\u0005!\u000fC\u0003=\u0019\u0011\u00051\u000fC\u0004u\u0019E\u0005I\u0011A;\u0003\u000f\t+\u0018\u000e\u001c3Va*\u0011\u0011CE\u0001\u000baJ,G-[2bi\u0016\u001c(BA\n\u0015\u0003!\u0019w.\\7b]\u0012\u001c(BA\u000b\u0017\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005]A\u0012a\u0002:v]RLW.\u001a\u0006\u00033i\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00037q\taaY=qQ\u0016\u0014(BA\u000f\u001f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0016\u000e\u0003AI!a\u000b\t\u0003\u000f\rCWmY6fe\u0006!A.[:u!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0004wSJ$X/\u00197\u000b\u0005Ib\u0012A\u0002<bYV,7/\u0003\u00025_\tIA*[:u-\u0006dW/Z\u0001\u000e[\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0012AB7f[>\u0014\u00180\u0003\u0002<q\tiQ*Z7pef$&/Y2lKJ\fa\u0001P5oSRtDc\u0001 @\u0001B\u0011\u0011\u0006\u0001\u0005\u0006Y\r\u0001\r!\f\u0005\bk\r\u0001\n\u00111\u00017\u0003!IG/\u001a:bi>\u0014X#A\"\u0011\u0007\u0011K5*D\u0001F\u0015\t1u)\u0001\u0003vi&d'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003\u00196k\u0011!M\u0005\u0003\u001dF\u0012\u0001\"\u00118z-\u0006dW/Z\u0001\nSR,'/\u0019;pe\u0002\n\u0011bY1dQ\u0016$7+\u001a;\u0016\u0003I\u00032a\u0015-L\u001b\u0005!&BA+W\u0003%!(/Y2lC\ndWM\u0003\u0002X9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e#&A\u0006%fCB$&/Y2lS:<WK\\5gS\u0016$7+\u001a;\u0002\u0015\r\f7\r[3e'\u0016$\b%\u0001\u0005d_:$\u0018-\u001b8t)\tif\r\u0005\u0003$=\u0002D\u0013BA0%\u0005\u0019!V\u000f\u001d7feA\u00191%Y2\n\u0005\t$#AB(qi&|g\u000e\u0005\u0002$I&\u0011Q\r\n\u0002\b\u0005>|G.Z1o\u0011\u00159\u0007\u00021\u0001L\u0003\u00151\u0018\r\\;f\u0003Q\u0019\u0007.Z2l\u0003:$')^5mIV\u00038)Y2iKR\u0011QL\u001b\u0005\u0006O&\u0001\raS\u0001\u0006G2|7/\u001a\u000b\u0002[B\u00111E\\\u0005\u0003_\u0012\u0012A!\u00168ji\u00069!)^5mIV\u0003\bCA\u0015\r'\ta!\u0005F\u0001r\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\taO\u000b\u00027o.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{\u0012\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class BuildUp
implements Checker {
    private final Iterator<AnyValue> iterator;
    private final HeapTrackingUnifiedSet<AnyValue> cachedSet;

    public static MemoryTracker $lessinit$greater$default$2() {
        return BuildUp$.MODULE$.$lessinit$greater$default$2();
    }

    public Iterator<AnyValue> iterator() {
        return this.iterator;
    }

    private HeapTrackingUnifiedSet<AnyValue> cachedSet() {
        return this.cachedSet;
    }

    @Override
    public Tuple2<Option<Object>, Checker> contains(AnyValue value) {
        return value == Values.NO_VALUE ? new Tuple2<Option<Object>, Checker>((Object)None$.MODULE$, (Object)this) : (this.cachedSet().contains((Object)value) ? new Tuple2((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)this) : this.checkAndBuildUpCache(value));
    }

    private Tuple2<Option<Object>, Checker> checkAndBuildUpCache(AnyValue value) {
        Tuple2 tuple2;
        Equality foundMatch = Equality.FALSE;
        while (this.iterator().hasNext()) {
            Equality equality = foundMatch;
            Equality equality2 = Equality.TRUE;
            if (!(equality == null ? equality2 != null : !equality.equals(equality2))) break;
            AnyValue nextValue = this.iterator().next();
            if (nextValue == Values.NO_VALUE) {
                foundMatch = Equality.UNDEFINED;
                continue;
            }
            this.cachedSet().add((Object)nextValue);
            Equality areEqual = nextValue.ternaryEquals(value);
            if (areEqual != Equality.UNDEFINED && areEqual != Equality.TRUE) continue;
            foundMatch = areEqual;
        }
        if (this.cachedSet().isEmpty()) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)NullListChecker$.MODULE$);
        } else {
            Equality equality = foundMatch;
            Equality equality3 = Equality.UNDEFINED;
            None$ falseResult = !(equality != null ? !equality.equals(equality3) : equality3 != null) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Checker nextState = this.iterator().hasNext() ? this : new SetChecker((Set<AnyValue>)this.cachedSet(), (Option<Object>)falseResult, (Option<AutoCloseable>)new Some(this.cachedSet()));
            Equality equality4 = foundMatch;
            Equality equality5 = Equality.TRUE;
            None$ result = !(equality4 != null ? !equality4.equals(equality5) : equality5 != null) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : falseResult;
            tuple2 = new Tuple2((Object)result, (Object)nextState);
        }
        return tuple2;
    }

    @Override
    public void close() {
        this.cachedSet().close();
    }

    public BuildUp(ListValue list, MemoryTracker memoryTracker) {
        this.iterator = list.iterator();
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.iterator().hasNext()) {
            throw new AssertionError((Object)"assertion failed");
        }
        this.cachedSet = HeapTrackingCollections.newSet((MemoryTracker)memoryTracker);
    }
}

