/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.util.Comparator;
import org.neo4j.cypher.internal.collection.DefaultComparatorTopTable;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NumericHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TopNPipe$;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.NumberValue;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u0011\"\u0001BB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005O\u0001\tE\t\u0015!\u0003G\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B)\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006a\u0002!\t&\u001d\u0005\n\u0003#\u0001\u0011\u0011!C\u0001\u0003'A\u0011\"a\b\u0001#\u0003%\t!!\t\t\u0013\u0005]\u0002!%A\u0005\u0002\u0005e\u0002\"CA\u001f\u0001E\u0005I\u0011AA \u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[B\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\ti\tAA\u0001\n\u0003\nyiB\u0005\u0002\u0014\u0006\n\t\u0011#\u0001\u0002\u0016\u001aA\u0001%IA\u0001\u0012\u0003\t9\n\u0003\u0004i1\u0011\u0005\u0011q\u0014\u0005\n\u0003\u0013C\u0012\u0011!C#\u0003\u0017C\u0011\"!)\u0019\u0003\u0003%\t)a)\t\u0013\u0005=\u0006$%A\u0005\u0002\u0005E\u0006\"CA^1\u0005\u0005I\u0011QA_\u0011%\ty\rGI\u0001\n\u0003\t\t\u000eC\u0005\u0002Zb\t\t\u0011\"\u0003\u0002\\\nAAk\u001c9O!&\u0004XM\u0003\u0002#G\u0005)\u0001/\u001b9fg*\u0011A%J\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002'O\u00059!/\u001e8uS6,'B\u0001\u0015*\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0016,\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A&L\u0001\u0006]\u0016|GG\u001b\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M!\u0001!M\u001b<!\t\u00114'D\u0001\"\u0013\t!\u0014E\u0001\bQSB,w+\u001b;i'>,(oY3\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0007P\u0005\u0003{]\u0012AbU3sS\u0006d\u0017N_1cY\u0016\faa]8ve\u000e,W#\u0001!\u0011\u0005I\n\u0015B\u0001\"\"\u0005\u0011\u0001\u0016\u000e]3\u0002\u000fM|WO]2fA\u0005y1m\\;oi\u0016C\bO]3tg&|g.F\u0001G!\t9E*D\u0001I\u0015\tI%*A\u0006fqB\u0014Xm]:j_:\u001c(BA&$\u0003!\u0019w.\\7b]\u0012\u001c\u0018BA'I\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0011G>,h\u000e^#yaJ,7o]5p]\u0002\n!bY8na\u0006\u0014\u0018\r^8s+\u0005\t\u0006c\u0001*X36\t1K\u0003\u0002U+\u0006!Q\u000f^5m\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\u0015\r{W\u000e]1sCR|'\u000f\u0005\u0002[76\tQ%\u0003\u0002]K\tY!+Z1eC\ndWMU8x\u0003-\u0019w.\u001c9be\u0006$xN\u001d\u0011\u0002\u0005%$W#\u00011\u0011\u0005\u0005,W\"\u00012\u000b\u0005\r$\u0017aC1uiJL'-\u001e;j_:T!\u0001V\u0014\n\u0005\u0019\u0014'AA%e\u0003\rIG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)lgn\u001c\u000b\u0003W2\u0004\"A\r\u0001\t\u000fyK\u0001\u0013!a\u0001A\")a(\u0003a\u0001\u0001\")A)\u0003a\u0001\r\")q*\u0003a\u0001#\u0006)\u0012N\u001c;fe:\fGn\u0011:fCR,'+Z:vYR\u001cH#\u0002:\u0002\u0004\u0005\u001d\u0001cA:|}:\u0011A/\u001f\b\u0003kbl\u0011A\u001e\u0006\u0003o>\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005i<\u0014a\u00029bG.\fw-Z\u0005\u0003yv\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003u^\u0002\"AW@\n\u0007\u0005\u0005QEA\u0005DsBDWM\u001d*po\"1\u0011Q\u0001\u0006A\u0002I\fQ!\u001b8qkRDq!!\u0003\u000b\u0001\u0004\tY!A\u0003ti\u0006$X\rE\u00023\u0003\u001bI1!a\u0004\"\u0005)\tV/\u001a:z'R\fG/Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002\u0016\u0005e\u00111DA\u000f)\rY\u0017q\u0003\u0005\u0006=.\u0001\r\u0001\u0019\u0005\b}-\u0001\n\u00111\u0001A\u0011\u001d!5\u0002%AA\u0002\u0019CqaT\u0006\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r\"f\u0001!\u0002&-\u0012\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003%)hn\u00195fG.,GMC\u0002\u00022]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)$a\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m\"f\u0001$\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA!U\r\t\u0016QE\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055S+\u0001\u0003mC:<\u0017\u0002BA)\u0003\u0017\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA,!\r1\u0014\u0011L\u0005\u0004\u00037:$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA1\u0003O\u00022ANA2\u0013\r\t)g\u000e\u0002\u0004\u0003:L\b\"CA5#\u0005\u0005\t\u0019AA,\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000e\t\u0007\u0003c\n9(!\u0019\u000e\u0005\u0005M$bAA;o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007q\f\u0019(\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007Y\ny(C\u0002\u0002\u0002^\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002jM\t\t\u00111\u0001\u0002b\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002X\u0005AAo\\*ue&tw\r\u0006\u0002\u0002H\u00051Q-];bYN$B!! \u0002\u0012\"I\u0011\u0011\u000e\f\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\t)>\u0004h\nU5qKB\u0011!\u0007G\n\u00051\u0005e5\bE\u00027\u00037K1!!(8\u0005\u0019\te.\u001f*fMR\u0011\u0011QS\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003K\u000bI+a+\u0002.R\u00191.a*\t\u000fy[\u0002\u0013!a\u0001A\")ah\u0007a\u0001\u0001\")Ai\u0007a\u0001\r\")qj\u0007a\u0001#\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0006\u0005\u00024\u0006U\u0016qWA]U\r\u0001\u0017Q\u0005\u0005\u0006}q\u0001\r\u0001\u0011\u0005\u0006\tr\u0001\rA\u0012\u0005\u0006\u001fr\u0001\r!U\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty,a3\u0011\u000bY\n\t-!2\n\u0007\u0005\rwG\u0001\u0004PaRLwN\u001c\t\u0007m\u0005\u001d\u0007IR)\n\u0007\u0005%wG\u0001\u0004UkBdWm\r\u0005\t\u0003\u001bl\u0012\u0011!a\u0001W\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135)!\t\u0019,a5\u0002V\u0006]\u0007\"\u0002 \u001f\u0001\u0004\u0001\u0005\"\u0002#\u001f\u0001\u00041\u0005\"B(\u001f\u0001\u0004\t\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!8\u0011\t\u0005%\u0013q\\\u0005\u0005\u0003C\fYE\u0001\u0004PE*,7\r\u001e")
public class TopNPipe
extends PipeWithSource
implements Product,
Serializable {
    private final Pipe source;
    private final Expression countExpression;
    private final Comparator<ReadableRow> comparator;
    private final int id;

    public static int $lessinit$greater$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.$lessinit$greater$default$4(pipe, expression, comparator);
    }

    public static Option<Tuple3<Pipe, Expression, Comparator<ReadableRow>>> unapply(TopNPipe topNPipe) {
        return TopNPipe$.MODULE$.unapply(topNPipe);
    }

    public static int apply$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.apply$default$4(pipe, expression, comparator);
    }

    public static TopNPipe apply(Pipe pipe, Expression expression, Comparator<ReadableRow> comparator, int n) {
        return TopNPipe$.MODULE$.apply(pipe, expression, comparator, n);
    }

    public Pipe source() {
        return this.source;
    }

    public Expression countExpression() {
        return this.countExpression;
    }

    public Comparator<ReadableRow> comparator() {
        return this.comparator;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Iterator<CypherRow> internalCreateResults(Iterator<CypherRow> input, QueryState state) {
        NumberValue limitNumber = NumericHelper$.MODULE$.evaluateStaticallyKnownNumber(this.countExpression(), state);
        if (limitNumber instanceof FloatingPointValue) {
            double limit = limitNumber.doubleValue();
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        long limit = limitNumber.longValue();
        if (limit < 0L) {
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        if (limit == 0L || input.isEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        MemoryTracker scopedMemoryTracker = state.memoryTracker().memoryTrackerForOperator(this.id()).getScopedMemoryTracker();
        DefaultComparatorTopTable topTable = new DefaultComparatorTopTable(this.comparator(), limit, scopedMemoryTracker);
        long i = 1L;
        while (input.hasNext()) {
            CypherRow evictedRow;
            CypherRow row = (CypherRow)input.next();
            if (row != (evictedRow = (CypherRow)topTable.addAndGetEvicted((Object)row))) {
                scopedMemoryTracker.allocateHeap(row.estimatedHeapUsage());
                if (evictedRow != null) {
                    scopedMemoryTracker.releaseHeap(evictedRow.estimatedHeapUsage());
                }
            }
            ++i;
        }
        topTable.sort();
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topTable.autoClosingIterator((AutoCloseable)scopedMemoryTracker)).asScala();
    }

    public TopNPipe copy(Pipe source, Expression countExpression, Comparator<ReadableRow> comparator, int id) {
        return new TopNPipe(source, countExpression, comparator, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public Expression copy$default$2() {
        return this.countExpression();
    }

    public Comparator<ReadableRow> copy$default$3() {
        return this.comparator();
    }

    public String productPrefix() {
        return "TopNPipe";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Comparator<ReadableRow> comparator;
        int n = x$1;
        switch (n) {
            case 0: {
                comparator = this.source();
                break;
            }
            case 1: {
                comparator = this.countExpression();
                break;
            }
            case 2: {
                comparator = this.comparator();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return comparator;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopNPipe;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopNPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopNPipe topNPipe = (TopNPipe)x$1;
        Pipe pipe = this.source();
        Pipe pipe2 = topNPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        Expression expression = this.countExpression();
        Expression expression2 = topNPipe.countExpression();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Comparator<ReadableRow> comparator = this.comparator();
        Comparator<ReadableRow> comparator2 = topNPipe.comparator();
        if (comparator == null) {
            if (comparator2 != null) {
                return false;
            }
        } else if (!((Object)comparator).equals(comparator2)) return false;
        if (!topNPipe.canEqual(this)) return false;
        return true;
    }

    public TopNPipe(Pipe source, Expression countExpression, Comparator<ReadableRow> comparator, int id) {
        this.source = source;
        this.countExpression = countExpression;
        this.comparator = comparator;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
    }
}

