/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import org.neo4j.cypher.internal.runtime.interpreted.ExecutionContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Arithmetics;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Divide$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.v3_4.ArithmeticException;
import org.neo4j.cypher.internal.util.v3_4.ArithmeticException$;
import org.neo4j.cypher.internal.util.v3_4.CypherTypeException;
import org.neo4j.cypher.internal.util.v3_4.CypherTypeException$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001N\u0011a\u0001R5wS\u0012,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2p[6\fg\u000eZ:\u000b\u0005\u001dA\u0011aC5oi\u0016\u0014\bO]3uK\u0012T!!\u0003\u0006\u0002\u000fI,h\u000e^5nK*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\u0002D\b\t\u0003+Yi\u0011AA\u0005\u0003/\t\u00111\"\u0011:ji\"lW\r^5dgB\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t9\u0001K]8ek\u000e$\bCA\r \u0013\t\u0001#D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005#\u0001\tU\r\u0011\"\u0001$\u0003\u0005\tW#\u0001\u0013\u0011\u0005U)\u0013B\u0001\u0014\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tQ\u0001\u0011\t\u0012)A\u0005I\u0005\u0011\u0011\r\t\u0005\tU\u0001\u0011)\u001a!C\u0001G\u0005\t!\r\u0003\u0005-\u0001\tE\t\u0015!\u0003%\u0003\t\u0011\u0007\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004CA\u000b\u0001\u0011\u0015\u0011S\u00061\u0001%\u0011\u0015QS\u00061\u0001%\u0011\u0015!\u0004\u0001\"\u00016\u0003\u001dy\u0007/\u001a:b]\u0012,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019\u0019FO]5oO\")q\b\u0001C\u0001k\u0005!a/\u001a:c\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019\u0015j\u0014\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r:\taA^1mk\u0016\u001c\u0018B\u0001%F\u0005!\te.\u001f,bYV,\u0007\"\u0002&A\u0001\u0004Y\u0015aA2uqB\u0011A*T\u0007\u0002\r%\u0011aJ\u0002\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ\u0001\u0015!A\u0002E\u000bQa\u001d;bi\u0016\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0004\u0002\u000bAL\u0007/Z:\n\u0005Y\u001b&AC)vKJL8\u000b^1uK\")\u0001\f\u0001C\u00013\u0006!1-\u00197d)\r\u0019%,\u0019\u0005\u0006E]\u0003\ra\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u0016\u000b\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0003Av\u00131BT;nE\u0016\u0014h+\u00197vK\")!f\u0016a\u00017\")1\r\u0001C\u0001I\u00069!/Z<sSR,GC\u0001\u0013f\u0011\u00151'\r1\u0001h\u0003\u00051\u0007\u0003B\riI\u0011J!!\u001b\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B6\u0001\t\u0003a\u0017aF:z[\n|G\u000eV1cY\u0016$U\r]3oI\u0016t7-[3t+\u0005i\u0007c\u00018tk6\tqN\u0003\u0002qc\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003ej\t!bY8mY\u0016\u001cG/[8o\u0013\t!xNA\u0002TKR\u0004\"A^=\u000f\u0005e9\u0018B\u0001=\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u001f\u0006\u0003qjAQ\u0001 \u0001\u0005\u0002u\fa\u0002\u001e5s_^$\u0016\u0010]3FeJ|'\u000fF\u0003\u007f\u0003\u0007\t9\u0001\u0005\u0002\u001a\u007f&\u0019\u0011\u0011\u0001\u000e\u0003\u000f9{G\u000f[5oO\"1\u0011QA>A\u0002U\fQ!\u0019+za\u0016Da!!\u0003|\u0001\u0004)\u0018!\u00022UsB,\u0007\"CA\u0007\u0001\u0005\u0005I\u0011AA\b\u0003\u0011\u0019w\u000e]=\u0015\u000bA\n\t\"a\u0005\t\u0011\t\nY\u0001%AA\u0002\u0011B\u0001BKA\u0006!\u0003\u0005\r\u0001\n\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c)\u001aA%!\b,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000b\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\r\u0001#\u0003%\t!!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!A\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005S'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0003s\u0001\u0011\u0011!C\u0001\u0003w\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0010\u0011\u0007e\ty$C\u0002\u0002Bi\u00111!\u00138u\u0011%\t)\u0005AA\u0001\n\u0003\t9%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0013q\n\t\u00043\u0005-\u0013bAA'5\t\u0019\u0011I\\=\t\u0015\u0005E\u00131IA\u0001\u0002\u0004\ti$A\u0002yIEB\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0017\u0011\r\u0005m\u0013QLA%\u001b\u0005\t\u0018bAA0c\nA\u0011\n^3sCR|'\u000fC\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\u00055\u0004cA\r\u0002j%\u0019\u00111\u000e\u000e\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011KA1\u0003\u0003\u0005\r!!\u0013\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0002\"CA<\u0001\u0005\u0005I\u0011IA=\u0003\u0019)\u0017/^1mgR!\u0011qMA>\u0011)\t\t&!\u001e\u0002\u0002\u0003\u0007\u0011\u0011J\u0004\n\u0003\u007f\u0012\u0011\u0011!E\u0001\u0003\u0003\u000ba\u0001R5wS\u0012,\u0007cA\u000b\u0002\u0004\u001aA\u0011AAA\u0001\u0012\u0003\t)iE\u0003\u0002\u0004\u0006\u001de\u0004E\u0004\u0002\n\u00065E\u0005\n\u0019\u000e\u0005\u0005-%BA\u0005\u001b\u0013\u0011\ty)a#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004/\u0003\u0007#\t!a%\u0015\u0005\u0005\u0005\u0005BCAL\u0003\u0007\u000b\t\u0011\"\u0012\u0002\u001a\u0006AAo\\*ue&tw\rF\u00017\u0011%\t\u00151QA\u0001\n\u0003\u000bi\nF\u00031\u0003?\u000b\t\u000b\u0003\u0004#\u00037\u0003\r\u0001\n\u0005\u0007U\u0005m\u0005\u0019\u0001\u0013\t\u0015\u0005\u0015\u00161QA\u0001\n\u0003\u000b9+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0016Q\u0017\t\u00063\u0005-\u0016qV\u0005\u0004\u0003[S\"AB(qi&|g\u000eE\u0003\u001a\u0003c#C%C\u0002\u00024j\u0011a\u0001V;qY\u0016\u0014\u0004\"CA\\\u0003G\u000b\t\u00111\u00011\u0003\rAH\u0005\r\u0005\u000b\u0003w\u000b\u0019)!A\u0005\n\u0005u\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a0\u0011\u0007]\n\t-C\u0002\u0002Db\u0012aa\u00142kK\u000e$\b")
public class Divide
extends Arithmetics
implements Product,
Serializable {
    private final Expression a;
    private final Expression b;

    public static Option<Tuple2<Expression, Expression>> unapply(Divide divide) {
        return Divide$.MODULE$.unapply(divide);
    }

    public static Function1<Tuple2<Expression, Expression>, Divide> tupled() {
        return Divide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Divide>> curried() {
        return Divide$.MODULE$.curried();
    }

    public Expression a() {
        return this.a;
    }

    public Expression b() {
        return this.b;
    }

    public String operand() {
        return "/";
    }

    public String verb() {
        return "divide";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnyValue apply(ExecutionContext ctx, QueryState state) {
        IntegralValue integralValue;
        AnyValue l;
        AnyValue bVal;
        AnyValue aVal = this.a().apply(ctx, state);
        Tuple2 tuple2 = new Tuple2((Object)aVal, (Object)(bVal = this.b().apply(ctx, state)));
        if (tuple2 != null && (l = (AnyValue)tuple2._2()) instanceof IntegralValue && (integralValue = (IntegralValue)l).longValue() == 0L) {
            throw new ArithmeticException("/ by zero", ArithmeticException$.MODULE$.$lessinit$greater$default$2());
        }
        if (tuple2 == null) return this.applyWithValues(aVal, bVal);
        AnyValue x = (AnyValue)tuple2._1();
        AnyValue y = (AnyValue)tuple2._2();
        if (!(x instanceof DurationValue)) return this.applyWithValues(aVal, bVal);
        DurationValue durationValue = (DurationValue)x;
        if (!(y instanceof NumberValue)) return this.applyWithValues(aVal, bVal);
        NumberValue numberValue = (NumberValue)y;
        return durationValue.div(numberValue);
    }

    @Override
    public AnyValue calc(NumberValue a, NumberValue b) {
        return a.divideBy(b);
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        return (Expression)f.apply((Object)new Divide(this.a().rewrite(f), this.b().rewrite(f)));
    }

    @Override
    public Set<String> symbolTableDependencies() {
        return (Set)this.a().symbolTableDependencies().$plus$plus(this.b().symbolTableDependencies());
    }

    @Override
    public Nothing$ throwTypeError(String aType, String bType) {
        throw new CypherTypeException(new StringBuilder().append((Object)"Cannot divide `").append((Object)aType).append((Object)"` by `").append((Object)bType).append((Object)"`").toString(), CypherTypeException$.MODULE$.$lessinit$greater$default$2());
    }

    public Divide copy(Expression a, Expression b) {
        return new Divide(a, b);
    }

    public Expression copy$default$1() {
        return this.a();
    }

    public Expression copy$default$2() {
        return this.b();
    }

    public String productPrefix() {
        return "Divide";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.b();
                break;
            }
            case 0: {
                expression = this.a();
            }
        }
        return expression;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Divide;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Divide)) return false;
        boolean bl = true;
        if (!bl) return false;
        Divide divide = (Divide)x$1;
        Expression expression = this.a();
        Expression expression2 = divide.a();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.b();
        Expression expression4 = divide.b();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!divide.canEqual(this)) return false;
        return true;
    }

    public Divide(Expression a, Expression b) {
        this.a = a;
        this.b = b;
        super(a, b);
        Product.class.$init$((Product)this);
    }
}

