/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.evaluator;

import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.EvaluationRuntimeException;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.evaluator.InternalExpressionEvaluator;
import org.neo4j.cypher.internal.evaluator.SimpleInternalExpressionEvaluator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

class SimpleExpressionEvaluator
implements ExpressionEvaluator {
    private InternalExpressionEvaluator evaluator = new SimpleInternalExpressionEvaluator();
    private static final ValueMapper<Object> MAPPER = new ValueMapper.JavaMapper(){

        public Object mapPath(PathValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate paths");
        }

        public Object mapNode(VirtualNodeValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate nodes");
        }

        public Object mapRelationship(VirtualRelationshipValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate relationships");
        }
    };

    SimpleExpressionEvaluator() {
    }

    @Override
    public <T> T evaluate(String expression, Class<T> type) throws EvaluationException {
        if (expression == null) {
            throw new EvaluationException("Cannot evaluate null as an expression ");
        }
        if (type == null) {
            throw new EvaluationException("Cannot evaluate to type null");
        }
        return this.cast(this.map(this.evaluator.evaluate(expression)), type);
    }

    private <T> T cast(Object value, Class<T> type) throws EvaluationException {
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new EvaluationException(String.format("Expected expression of be of type `%s` but it was `%s`", type.getCanonicalName(), value.getClass().getCanonicalName()), e);
        }
    }

    private Object map(AnyValue value) throws EvaluationException {
        try {
            return value.map(MAPPER);
        }
        catch (EvaluationRuntimeException e) {
            throw new EvaluationException(e.getMessage(), e);
        }
    }
}

