/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.evaluator;

import java.util.List;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.EvaluationRuntimeException;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.evaluator.InternalExpressionEvaluator;
import org.neo4j.cypher.internal.evaluator.SimpleInternalExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Option;
import scala.jdk.CollectionConverters;

class SimpleExpressionEvaluator
implements ExpressionEvaluator {
    private final CypherVersion cypherVersion;
    private final InternalExpressionEvaluator evaluator = new SimpleInternalExpressionEvaluator();
    private static final ValueMapper<Object> MAPPER = new ValueMapper.JavaMapper(){

        public Object mapPath(VirtualPathValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate paths");
        }

        public Object mapNode(VirtualNodeValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate nodes");
        }

        public Object mapRelationship(VirtualRelationshipValue value) {
            throw new EvaluationRuntimeException("Unable to evaluate relationships");
        }
    };

    SimpleExpressionEvaluator(CypherVersion cypherVersion) {
        this.cypherVersion = cypherVersion;
    }

    @Override
    public <T> T evaluate(String expression, Class<T> type) throws EvaluationException {
        if (expression == null) {
            throw new EvaluationException("Cannot evaluate null as an expression ");
        }
        if (type == null) {
            throw new EvaluationException("Cannot evaluate to type null");
        }
        return SimpleExpressionEvaluator.cast(SimpleExpressionEvaluator.map(this.parseAndEvaluate(expression)), type);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) throws EvaluationException {
        if (expression == null) {
            throw new EvaluationException("Cannot evaluate null as an expression ");
        }
        return this.evaluator.evaluate(expression, params, CypherRow.empty());
    }

    private static <T> T cast(Object value, Class<T> type) throws EvaluationException {
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new EvaluationException(String.format("Expected expression of be of type `%s` but it was `%s`", type.getCanonicalName(), value.getClass().getCanonicalName()), e);
        }
    }

    private static Object map(AnyValue value) throws EvaluationException {
        try {
            return value.map(MAPPER);
        }
        catch (EvaluationRuntimeException e) {
            throw new EvaluationException(e.getMessage(), e);
        }
    }

    private AnyValue parseAndEvaluate(String expression) throws EvaluationException {
        try {
            List semanticFeatures = List.of();
            Expression parsed = AstParserFactory$.MODULE$.apply(this.cypherVersion).apply(expression, (CypherExceptionFactory)new Neo4jCypherExceptionFactory(expression, Option.empty()), Option.empty(), CollectionConverters.CollectionHasAsScala(semanticFeatures).asScala().toSeq()).expression();
            return this.evaluator.evaluate(parsed, MapValue.EMPTY, CypherRow.empty());
        }
        catch (Exception e) {
            throw new EvaluationException("Failed to evaluate expression %s".formatted(expression), e);
        }
    }
}

