/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.Labels;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.ListLiteral;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.SchemaNamesBridge;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;

@RegisterForReflection(allDeclaredConstructors=true)
final class Neo4j5Pre26LabelsVisitor
implements Visitor {
    private final DefaultVisitor delegate;
    private final AtomicBoolean didDelegate = new AtomicBoolean(false);

    Neo4j5Pre26LabelsVisitor(DefaultVisitor delegate) {
        this.delegate = delegate;
    }

    void render(Object visitable) {
        if (visitable instanceof Parameter) {
            Parameter parameter = (Parameter)visitable;
            this.render(parameter.getValue());
        } else if (visitable instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)visitable;
            listExpression.accept(segment -> {
                if (segment instanceof ListExpression) {
                    return;
                }
                this.render(segment);
            });
        } else if (visitable instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)visitable;
            Iterator iterator = listLiteral.getContent().iterator();
            while (iterator.hasNext()) {
                Literal literal = (Literal)iterator.next();
                this.render(literal);
            }
        } else if (visitable instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)visitable;
            this.renderAsLabel(stringLiteral.getContent().toString());
        } else if (visitable instanceof List) {
            List list = (List)visitable;
            for (Object item : list) {
                if (!(item instanceof String)) continue;
                String string = (String)item;
                this.renderAsLabel(string);
            }
        } else if (visitable instanceof String) {
            String string = (String)visitable;
            this.renderAsLabel(string);
        } else if (visitable instanceof NodeLabel) {
            NodeLabel label = (NodeLabel)visitable;
            this.renderAsLabel(label.getValue());
        } else if (!"org.neo4j.cypherdsl.core.ExpressionList".equals(visitable.getClass().getName())) {
            throw new IllegalArgumentException("Cannot render the given Labels in a Cypher pre 5.26 compatible way");
        }
    }

    private void renderAsLabel(String string) {
        this.delegate.builder.append(":").append(SchemaNamesBridge.sanitize(string, this.delegate.alwaysEscapeNames).orElseThrow());
    }

    @Override
    public void enter(Visitable segment) {
        if (!(segment instanceof Labels)) {
            return;
        }
        Labels labels = (Labels)segment;
        if (labels.getLhs() == null && labels.getRhs() == null && EnumSet.of(Labels.Type.LEAF, Labels.Type.COLON_CONJUNCTION).contains((Object)labels.getType())) {
            for (Labels.Value value : labels.getValue()) {
                this.render(value.visitable());
            }
        } else {
            this.didDelegate.compareAndSet(false, true);
            this.delegate.enter(labels);
        }
    }

    @Override
    public void leave(Visitable segment) {
        if (this.didDelegate.compareAndSet(true, false)) {
            this.delegate.leave((Labels)segment);
        }
    }
}

