/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

class MultiPartElement
implements Visitable {
    private final List<Visitable> precedingClauses;
    private final With with;

    MultiPartElement(List<Visitable> precedingClauses, With with) {
        this.precedingClauses = precedingClauses == null || precedingClauses.isEmpty() ? Collections.emptyList() : new ArrayList<Visitable>(precedingClauses);
        this.with = with;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.precedingClauses.forEach(c -> c.accept(visitor));
        this.with.accept(visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isImporting() {
        if (!this.precedingClauses.isEmpty()) return false;
        if (this.with.getItems().isEmpty()) return false;
        if (!this.with.getItems().stream().allMatch(IdentifiableElement.class::isInstance)) return false;
        return true;
    }

    IdentifiableElement[] getImports() {
        return (IdentifiableElement[])this.with.getItems().stream().map(IdentifiableElement.class::cast).toArray(IdentifiableElement[]::new);
    }
}

