/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractClause;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCallImpl;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="2021.3.0")
public final class Clauses {
    private Clauses() {
    }

    public static Clause match(boolean optional, List<PatternElement> patternElements, Where optionalWhere, List<Hint> optionalHints) {
        return new Match(optional, Pattern.of(patternElements), optionalWhere, optionalHints);
    }

    public static Clause delete(boolean detach, List<Expression> expressions) {
        return new Delete(new ExpressionList(expressions), detach);
    }

    public static Return returning(boolean distinct, List<Expression> expressions, List<SortItem> optionalSortItems, Expression optionalSkip, Expression optionalLimit) {
        DefaultStatementBuilder.OrderBuilder orderBuilder = new DefaultStatementBuilder.OrderBuilder();
        orderBuilder.orderBy(optionalSortItems);
        orderBuilder.skip(optionalSkip);
        orderBuilder.limit(optionalLimit);
        return Return.create(false, distinct, expressions, orderBuilder);
    }

    public static Clause create(List<PatternElement> patternElements) {
        return new Create(Pattern.of(patternElements));
    }

    public static Clause merge(List<PatternElement> patternElements, List<MergeAction> mergeActions) {
        return new Merge(Pattern.of(patternElements), mergeActions != null ? mergeActions : Collections.emptyList());
    }

    public static Clause with(Return returnClause, Where optionalWhere) {
        return new With(returnClause, optionalWhere);
    }

    public static Clause remove(List<Expression> expressions) {
        return new Remove(new ExpressionList(expressions));
    }

    public static Clause set(List<Expression> expressions) {
        return new Set(new ExpressionList(expressions));
    }

    public static Clause unwind(Expression expression, SymbolicName name) {
        return new Unwind(expression, name.getValue());
    }

    public static Clause loadCSV(boolean withHeaders, StringLiteral uri, SymbolicName alias, String fieldTerminator) {
        return new LoadCSV(URI.create(uri.getContent().toString()), withHeaders, alias.getValue()).withFieldTerminator(fieldTerminator);
    }

    public static Clause callClause(List<String> namespace, String name, List<Expression> arguments, List<Expression> resultItems, Where optionalWhere) {
        return ProcedureCallImpl.create(ProcedureName.from(namespace, name), new Arguments(arguments != null ? arguments.toArray(new Expression[0]) : new Expression[]{}), resultItems != null ? YieldItems.yieldAllOf(resultItems.toArray(new Expression[0])) : null, optionalWhere);
    }

    public static Clause callClause(Statement statement) {
        return Subquery.call(statement, new IdentifiableElement[0]);
    }

    public static Clause forEach(SymbolicName v, Expression list, List<Clause> updatingClauses) {
        Assertions.isTrue(updatingClauses.stream().allMatch(UpdatingClause.class::isInstance), "Only updating clauses SET, REMOVE, CREATE, MERGE, DELETE, and FOREACH are allowed as clauses applied inside FOREACH.");
        return new Foreach(v, list, updatingClauses.stream().map(UpdatingClause.class::cast).toList());
    }

    public static Clause orderBy(List<SortItem> sortItems, Expression skip, Expression limit) {
        return new OrderByClause(new Order(sortItems), skip != null ? Skip.create(skip) : null, limit != null ? Limit.create(limit) : null);
    }

    static final class OrderByClause
    extends AbstractClause {
        private final Order order;
        private final Skip skip;
        private final Limit limit;

        OrderByClause(Order order, Skip skip, Limit limit) {
            this.order = order;
            this.skip = skip;
            this.limit = limit;
        }

        @Override
        public void accept(Visitor visitor) {
            this.order.accept(visitor);
            Visitable.visitIfNotNull(this.skip, visitor);
            Visitable.visitIfNotNull(this.limit, visitor);
        }
    }
}

