/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.time.Period;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LiteralBase;

final class PeriodLiteral
extends LiteralBase<Period> {
    private PeriodLiteral(Period content) {
        super(content);
    }

    static Literal<Period> of(Period duration) {
        return new PeriodLiteral(duration);
    }

    @Override
    public Period getContent() {
        return (Period)this.content;
    }

    @Override
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append("duration('P");
        if (((Period)this.content).getYears() != 0) {
            result.append(((Period)this.content).getYears()).append("Y");
        }
        if (((Period)this.content).getMonths() != 0) {
            result.append(((Period)this.content).getMonths()).append("M");
        }
        if (((Period)this.content).getDays() != 0) {
            result.append(((Period)this.content).getDays()).append("D");
        }
        result.append("')");
        return result.toString();
    }
}

