/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Labels;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class HasLabelCondition
implements Condition {
    private final SymbolicName nodeName;
    private final Visitable labels;

    private HasLabelCondition(SymbolicName nodeName, List<NodeLabel> nodeLabels) {
        this.nodeName = nodeName;
        this.labels = new TypedSubtree<NodeLabel>(nodeLabels){

            @Override
            public String separator() {
                return "";
            }
        };
    }

    private HasLabelCondition(SymbolicName nodeName, Labels labels) {
        this.nodeName = nodeName;
        this.labels = labels;
    }

    static HasLabelCondition create(SymbolicName nodeName, String ... labels) {
        Assertions.notNull(nodeName, "A symbolic name for the node is required.");
        Assertions.notNull(labels, "Labels to query are required.");
        Assertions.notEmpty(labels, "At least one label to query is required.");
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>(labels.length);
        for (String label : labels) {
            nodeLabels.add(new NodeLabel(label));
        }
        return new HasLabelCondition(nodeName, nodeLabels);
    }

    static HasLabelCondition create(SymbolicName nodeName, Labels labels) {
        Assertions.notNull(nodeName, "A symbolic name for the node is required.");
        Assertions.notNull(labels, "Labels to query are required.");
        return new HasLabelCondition(nodeName, labels);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.nodeName.accept(visitor);
        this.labels.accept(visitor);
        visitor.leave(this);
    }
}

