/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ImportingWith;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SubqueryExpression;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="2023.0.0")
@Neo4jVersion(minimum="5.6")
public final class CollectExpression
implements SubqueryExpression {
    private final ImportingWith optionalWith;
    private final Statement resultStatement;

    private CollectExpression(ImportingWith optionalWith, Statement resultStatement) {
        this.optionalWith = optionalWith;
        this.resultStatement = resultStatement;
    }

    static CollectExpression collect(Statement resultStatement) {
        return new CollectExpression(new ImportingWith(), resultStatement);
    }

    static CollectExpression collect(With optionalWith, Statement resultStatement) {
        return new CollectExpression(new ImportingWith(optionalWith, null), resultStatement);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.optionalWith.accept(visitor);
        this.resultStatement.accept(visitor);
        visitor.leave(this);
    }
}

