/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.ImportingWith;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SubqueryExpression;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class ExistentialSubquery
implements SubqueryExpression,
Condition {
    private final ImportingWith importingWith;
    private final List<Visitable> fragments;
    private final Where innerWhere;

    ExistentialSubquery(List<PatternElement> fragments, Where innerWhere) {
        this.fragments = List.of(Pattern.of(fragments));
        this.importingWith = new ImportingWith();
        this.innerWhere = innerWhere;
    }

    ExistentialSubquery(Match fragment) {
        this.fragments = List.of(fragment);
        this.importingWith = new ImportingWith();
        this.innerWhere = null;
    }

    ExistentialSubquery(Statement statement, IdentifiableElement ... imports) {
        this.fragments = List.of(statement);
        this.importingWith = ImportingWith.of(imports);
        this.innerWhere = null;
    }

    static ExistentialSubquery exists(Match fragment) {
        return new ExistentialSubquery(fragment);
    }

    static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return new ExistentialSubquery(statement, imports);
    }

    static Condition exists(List<PatternElement> patternElements, Where innerWhere) {
        return new ExistentialSubquery(patternElements, innerWhere);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.importingWith.accept(visitor);
        this.fragments.forEach(v -> v.accept(visitor));
        Visitable.visitIfNotNull(this.innerWhere, visitor);
        visitor.leave(this);
    }
}

