/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Aliased;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SubqueryExpression;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.UnionPart;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.YieldItems;

@API(status=API.Status.INTERNAL, since="2021.3.2")
public final class ScopingStrategy {
    private final Deque<Set<IdentifiableElement>> dequeOfVisitedNamed = new ArrayDeque<Set<IdentifiableElement>>();
    private final Deque<Set<IdentifiableElement>> implicitScope = new ArrayDeque<Set<IdentifiableElement>>();
    private Set<IdentifiableElement> afterStatement = Collections.emptySet();
    private Visitable previous;
    private boolean inOrder = false;
    private boolean inProperty = false;
    private boolean inSubquery = false;
    private boolean inListFunctionPredicate = false;
    private final Deque<Set<String>> currentImports = new ArrayDeque<Set<String>>();
    private final Deque<Set<String>> definedInSubquery = new ArrayDeque<Set<String>>();
    private final List<BiConsumer<Visitable, Collection<IdentifiableElement>>> onScopeEntered = new ArrayList<BiConsumer<Visitable, Collection<IdentifiableElement>>>();
    private final List<BiConsumer<Visitable, Collection<IdentifiableElement>>> onScopeLeft = new ArrayList<BiConsumer<Visitable, Collection<IdentifiableElement>>>();
    private final Deque<Boolean> skipAliasing = new ArrayDeque<Boolean>();

    public static ScopingStrategy create() {
        return new ScopingStrategy();
    }

    public static ScopingStrategy create(List<BiConsumer<Visitable, Collection<IdentifiableElement>>> onScopeEntered, List<BiConsumer<Visitable, Collection<IdentifiableElement>>> onScopeLeft) {
        ScopingStrategy strategy = ScopingStrategy.create();
        strategy.onScopeEntered.addAll(onScopeEntered);
        strategy.onScopeLeft.addAll(onScopeLeft);
        return strategy;
    }

    private ScopingStrategy() {
        this.dequeOfVisitedNamed.push(new LinkedHashSet());
    }

    public void doEnter(Visitable visitable) {
        Set scopeSeed;
        if (visitable instanceof Order) {
            this.inOrder = true;
        }
        if (visitable instanceof Property) {
            this.inProperty = true;
        }
        if (visitable instanceof Subquery) {
            Subquery subquery = (Subquery)visitable;
            With with = subquery.importingWith();
            this.inSubquery = true;
            this.definedInSubquery.push(new LinkedHashSet());
            LinkedHashSet imports = new LinkedHashSet();
            this.currentImports.push(imports);
            if (with != null) {
                with.getItems().stream().filter(IdentifiableElement.class::isInstance).map(IdentifiableElement.class::cast).map(ScopingStrategy::extractIdentifier).filter(Objects::nonNull).forEach(imports::add);
            }
        }
        if (this.isListFunctionPredicate(visitable)) {
            this.inListFunctionPredicate = true;
        }
        if (visitable instanceof MapProjection) {
            this.skipAliasing.push(true);
        } else if (visitable instanceof SubqueryExpression) {
            this.skipAliasing.push(false);
        }
        boolean notify = false;
        Set<Object> set = scopeSeed = this.dequeOfVisitedNamed.isEmpty() ? Collections.emptySet() : this.dequeOfVisitedNamed.peek();
        if (ScopingStrategy.hasLocalScope(visitable)) {
            notify = true;
            this.dequeOfVisitedNamed.push(new LinkedHashSet(scopeSeed));
        }
        if (ScopingStrategy.hasImplicitScope(visitable)) {
            notify = true;
            this.implicitScope.push(new LinkedHashSet(scopeSeed));
        }
        if (notify) {
            scopeSeed.addAll(this.afterStatement);
            LinkedHashSet importsAndScope = new LinkedHashSet();
            Set<String> current = this.currentImports.peek();
            if (current != null) {
                current.stream().map(Cypher::name).forEach(importsAndScope::add);
            }
            importsAndScope.addAll(scopeSeed);
            this.onScopeEntered.forEach(c -> c.accept(visitable, importsAndScope));
        }
    }

    public boolean isSkipAliasing() {
        return Optional.ofNullable(this.skipAliasing.peek()).orElse(false);
    }

    public boolean hasVisitedBefore(Named namedItem) {
        if (!this.hasScope()) {
            return false;
        }
        Set<IdentifiableElement> scope = this.dequeOfVisitedNamed.peek();
        return this.hasVisitedInScope(scope, namedItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isListFunctionPredicate(Visitable visitable) {
        if (!(visitable instanceof FunctionInvocation)) return false;
        FunctionInvocation fi = (FunctionInvocation)visitable;
        if (!Set.of("all", "any", "none", "single").contains(fi.getFunctionName().toLowerCase(Locale.ROOT))) return false;
        return true;
    }

    public void doLeave(Visitable visitable) {
        if (!this.hasScope()) {
            return;
        }
        if (visitable instanceof IdentifiableElement) {
            IdentifiableElement identifiableElement = (IdentifiableElement)((Object)visitable);
            if (!(this.inOrder || this.inProperty && !(visitable instanceof Property))) {
                if (identifiableElement instanceof SymbolicName && this.inListFunctionPredicate) {
                    this.inListFunctionPredicate = false;
                } else {
                    String identifier;
                    this.dequeOfVisitedNamed.peek().add(identifiableElement);
                    if (this.inSubquery && (identifier = ScopingStrategy.extractIdentifier(identifiableElement)) != null) {
                        this.definedInSubquery.peek().add(identifier);
                    }
                }
            }
        }
        if (this.isListFunctionPredicate(visitable)) {
            this.inListFunctionPredicate = false;
        }
        boolean notify = false;
        if (visitable instanceof Statement) {
            this.leaveStatement(visitable);
        } else if (ScopingStrategy.hasLocalScope(visitable)) {
            notify = true;
            Set<IdentifiableElement> lastVisitedNames = this.dequeOfVisitedNamed.pop();
            if (visitable instanceof ExistentialSubquery) {
                this.afterStatement.retainAll(lastVisitedNames);
            }
        } else {
            this.clearPreviouslyVisitedNamed(visitable);
        }
        if (visitable instanceof Order) {
            this.inOrder = false;
        }
        if (visitable instanceof Property) {
            this.inProperty = false;
        }
        if (visitable instanceof Subquery) {
            this.inSubquery = false;
            this.currentImports.pop();
            this.definedInSubquery.pop();
        }
        if (visitable instanceof MapProjection || visitable instanceof SubqueryExpression) {
            this.skipAliasing.pop();
        }
        if (ScopingStrategy.hasImplicitScope(visitable)) {
            notify = true;
            this.implicitScope.pop();
        }
        this.previous = visitable;
        if (notify) {
            HashSet<IdentifiableElement> retainedElements = new HashSet<IdentifiableElement>(this.afterStatement);
            this.onScopeLeft.forEach(c -> c.accept(visitable, retainedElements));
        }
    }

    private static boolean hasImplicitScope(Visitable visitable) {
        return visitable instanceof SubqueryExpression || visitable instanceof Statement.UnionQuery;
    }

    private void leaveStatement(Visitable visitable) {
        Set<IdentifiableElement> lastScope = this.dequeOfVisitedNamed.peek();
        if (this.previous instanceof UnionPart && this.afterStatement != null) {
            lastScope.stream().filter(i -> !(i instanceof Property)).forEach(this.afterStatement::add);
        } else {
            this.afterStatement = !(this.previous instanceof Return) && !(this.previous instanceof YieldItems) ? (Set<Object>)lastScope.stream().filter(i -> !(i instanceof Property)).collect(Collectors.toCollection(LinkedHashSet::new)) : new LinkedHashSet<IdentifiableElement>(lastScope);
        }
        if (visitable instanceof ProcedureCall) {
            return;
        }
        lastScope.retainAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
    }

    private boolean hasScope() {
        return !this.dequeOfVisitedNamed.isEmpty();
    }

    private boolean hasVisitedInScope(Collection<IdentifiableElement> visited, Named needle) {
        return visited.contains(needle) || needle.getSymbolicName().isPresent() && visited.stream().filter(ScopingStrategy.byHasAName()).map(ScopingStrategy::extractIdentifier).filter(Objects::nonNull).anyMatch(this.identifiedBy(needle));
    }

    @NotNull
    private static Predicate<IdentifiableElement> byHasAName() {
        Predicate<IdentifiableElement> hasAName = Named.class::isInstance;
        hasAName = hasAName.or(AliasedExpression.class::isInstance);
        hasAName = hasAName.or(SymbolicName.class::isInstance);
        return hasAName;
    }

    private static String extractIdentifier(IdentifiableElement i) {
        String value;
        if (i instanceof Named) {
            Named named = (Named)i;
            value = named.getSymbolicName().map(SymbolicName::getValue).orElse(null);
        } else if (i instanceof Aliased) {
            Aliased aliased = (Aliased)((Object)i);
            value = aliased.getAlias();
        } else if (i instanceof SymbolicName) {
            SymbolicName symbolicName = (SymbolicName)i;
            value = symbolicName.getValue();
        } else {
            value = null;
        }
        return value;
    }

    @NotNull
    private Predicate<String> identifiedBy(Named needle) {
        return i -> {
            boolean result = i.equals(needle.getRequiredSymbolicName().getValue());
            if (result && this.inSubquery) {
                boolean imported = Optional.ofNullable(this.currentImports.peek()).orElseGet(Set::of).contains(i);
                return imported || this.definedInSubquery.peek().contains(i);
            }
            return result;
        };
    }

    private static boolean hasLocalScope(Visitable visitable) {
        return visitable instanceof PatternComprehension || visitable instanceof Subquery || visitable instanceof SubqueryExpression || visitable instanceof Foreach;
    }

    private void clearPreviouslyVisitedNamed(Visitable visitable) {
        if (visitable instanceof With) {
            With with = (With)visitable;
            this.clearPreviouslyVisitedAfterWith(with);
        } else if (visitable instanceof Return || visitable instanceof YieldItems) {
            this.clearPreviouslyVisitedAfterReturnish(visitable);
        }
    }

    private void clearPreviouslyVisitedAfterWith(With with) {
        HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        if (visitedNamed == null) {
            return;
        }
        with.accept(segment -> {
            if (segment instanceof SymbolicName) {
                SymbolicName symbolicName = (SymbolicName)segment;
                visitedNamed.stream().filter(element -> {
                    if (element instanceof Named) {
                        Named named = (Named)element;
                        return named.getSymbolicName().filter(s -> s.equals(segment)).isPresent();
                    }
                    if (element instanceof Aliased) {
                        Aliased aliased = (Aliased)((Object)element);
                        return aliased.getAlias().equals(symbolicName.getValue());
                    }
                    return element.equals(segment);
                }).forEach(retain::add);
            } else if (segment instanceof Asterisk) {
                retain.addAll(visitedNamed);
            }
        });
        retain.addAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
        visitedNamed.retainAll(retain);
    }

    private void clearPreviouslyVisitedAfterReturnish(Visitable returnish) {
        final HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        returnish.accept(new Visitor(){
            int level = 0;
            Visitable entranceLevel1;

            @Override
            public void enter(Visitable segment) {
                if (this.entranceLevel1 == null && segment instanceof TypedSubtree) {
                    this.entranceLevel1 = segment;
                    return;
                }
                if (this.entranceLevel1 != null) {
                    ++this.level;
                }
                if (this.level == 1 && segment instanceof IdentifiableElement) {
                    IdentifiableElement identifiableElement = (IdentifiableElement)((Object)segment);
                    retain.add(identifiableElement);
                }
            }

            @Override
            public void leave(Visitable segment) {
                if (this.entranceLevel1 != null) {
                    this.level = Math.max(0, this.level - 1);
                    if (segment == this.entranceLevel1) {
                        this.entranceLevel1 = null;
                    }
                }
            }
        });
        retain.addAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
        if (visitedNamed != null) {
            visitedNamed.retainAll(retain);
        }
    }

    public Collection<Expression> getIdentifiables() {
        if (!this.hasScope()) {
            return Collections.emptySet();
        }
        Predicate<IdentifiableElement> allNamedElementsHaveResolvedNames = e -> {
            Named named;
            return !(e instanceof Named) || (named = (Named)e).getSymbolicName().filter(s -> s.getValue() != null).isPresent();
        };
        Set<IdentifiableElement> items = Optional.ofNullable(this.dequeOfVisitedNamed.peek()).filter(scope -> !scope.isEmpty()).orElse(this.afterStatement);
        return items.stream().filter(allNamedElementsHaveResolvedNames).map(IdentifiableElement::asExpression).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public PatternElement lookup(Named node) {
        if (!this.hasScope() || node.getSymbolicName().isEmpty()) {
            return null;
        }
        Set<IdentifiableElement> scope = this.dequeOfVisitedNamed.peek();
        Predicate<String> identifiedBy = this.identifiedBy(node);
        return scope.stream().filter(ScopingStrategy.byHasAName()).filter(PatternElement.class::isInstance).filter(i -> {
            String identifier = ScopingStrategy.extractIdentifier(i);
            return identifier != null && identifiedBy.test(identifier);
        }).map(PatternElement.class::cast).findFirst().orElse(null);
    }

    public Set<SymbolicName> getCurrentImports() {
        return Optional.ofNullable(this.currentImports.peek()).stream().flatMap(v -> v.stream().map(Cypher::name)).collect(Collectors.toSet());
    }
}

