/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.InternalPropertyImpl;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;

@API(status=API.Status.INTERNAL, since="2021.1.0")
abstract class AbstractPropertyContainer
implements PropertyContainer {
    AbstractPropertyContainer() {
    }

    @Override
    @NotNull
    public final Property property(@NotNull String name) {
        return InternalPropertyImpl.create((Named)this, name);
    }

    @Override
    @NotNull
    public final Property property(String ... names) {
        return InternalPropertyImpl.create((Named)this, names);
    }

    @Override
    @NotNull
    public final Property property(@NotNull Expression lookup) {
        return InternalPropertyImpl.create((Named)this, lookup);
    }

    static IllegalStateException noNameException() {
        return new IllegalStateException(Cypher.MESSAGES.getString("assertions.requires-name-for-mutation"));
    }

    @Override
    @NotNull
    public final Operation mutate(Parameter<?> parameter) {
        return Operations.mutate((Expression)this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), parameter);
    }

    @Override
    @NotNull
    public final Operation mutate(MapExpression properties) {
        return Operations.mutate((Expression)this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), properties);
    }

    @Override
    @NotNull
    public final Operation set(Parameter<?> parameter) {
        return Operations.set(this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), parameter);
    }

    @Override
    @NotNull
    public final Operation set(MapExpression properties) {
        return Operations.set(this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), properties);
    }

    @Override
    @NotNull
    public final MapProjection project(List<Object> entries) {
        return this.project(entries.toArray());
    }

    @Override
    @NotNull
    public final MapProjection project(Object ... entries) {
        return this.getRequiredSymbolicName().project(entries);
    }
}

