/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractClause;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.ImportingWith;
import org.neo4j.cypherdsl.core.InTransactions;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.RawLiteral;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class Subquery
extends AbstractClause
implements Clause {
    private final ImportingWith importingWith;
    private final Statement statement;
    private final RawLiteral rawStatement;

    static Subquery raw(String format, Object ... mixedArgs) {
        return new Subquery(RawLiteral.create(format, mixedArgs));
    }

    static Subquery call(Statement statement, IdentifiableElement ... imports) {
        return new Subquery(ImportingWith.of(imports), statement);
    }

    private Subquery(ImportingWith importingWith, Statement statement) {
        this.importingWith = importingWith;
        this.statement = statement;
        this.rawStatement = null;
    }

    private Subquery(RawLiteral rawStatement) {
        this.rawStatement = rawStatement;
        this.importingWith = null;
        this.statement = null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.rawStatement != null) {
            this.rawStatement.accept(visitor);
        } else {
            this.importingWith.accept(visitor);
            this.statement.accept(visitor);
        }
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL)
    InTransactions inTransactionsOf(Integer rows) {
        return new InTransactions(this, rows);
    }

    @API(status=API.Status.INTERNAL)
    public boolean doesReturnOrYield() {
        return this.statement != null && this.statement.doesReturnOrYield();
    }
}

