/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.DefaultStatementContext;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;
import org.neo4j.cypherdsl.core.renderer.GeneralizedRenderer;
import org.neo4j.cypherdsl.core.renderer.PrettyPrintingVisitor;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.cypherdsl.core.renderer.RenderingVisitor;
import org.neo4j.cypherdsl.core.utils.LRUCache;

final class ConfigurableRenderer
implements GeneralizedRenderer,
Renderer {
    private static final Map<Configuration, ConfigurableRenderer> CONFIGURATIONS = new ConcurrentHashMap<Configuration, ConfigurableRenderer>(8);
    private static final int STATEMENT_CACHE_SIZE = 128;
    private final LRUCache<Integer, String> renderedStatementCache = new LRUCache(128);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();
    private final Configuration configuration;

    static ConfigurableRenderer create(Configuration configuration) {
        return CONFIGURATIONS.computeIfAbsent(configuration, ConfigurableRenderer::new);
    }

    ConfigurableRenderer(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String render(Statement statement) {
        return this.render((Visitable)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(Visitable visitable) {
        record RenderingConfig(StatementContext ctx, boolean renderConstantsAsParameters) {
        }
        BiFunction<RenderingConfig, Visitable, String> renderOp = (cfg, v) -> {
            RenderingVisitor renderingVisitor = this.createVisitor(cfg.ctx, cfg.renderConstantsAsParameters);
            v.accept(renderingVisitor);
            return renderingVisitor.getRenderedContent().trim();
        };
        if (visitable instanceof Statement) {
            String renderedContent;
            Statement statement = (Statement)visitable;
            int key = Objects.hash(statement, statement.isRenderConstantsAsParameters());
            try {
                this.read.lock();
                renderedContent = (String)this.renderedStatementCache.get(key);
            }
            finally {
                this.read.unlock();
            }
            if (renderedContent == null) {
                try {
                    this.write.lock();
                    renderedContent = renderOp.apply(new RenderingConfig(statement.getContext(), statement.isRenderConstantsAsParameters()), statement);
                    this.renderedStatementCache.put(key, renderedContent);
                }
                finally {
                    this.write.unlock();
                }
            }
            return renderedContent;
        }
        return renderOp.apply(new RenderingConfig(new DefaultStatementContext(), false), visitable);
    }

    private RenderingVisitor createVisitor(StatementContext statementContext, boolean renderConstantsAsParameters) {
        if (!this.configuration.isPrettyPrint()) {
            return new DefaultVisitor(statementContext, renderConstantsAsParameters, this.configuration);
        }
        return new PrettyPrintingVisitor(statementContext, renderConstantsAsParameters, this.configuration);
    }
}

