/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.LabelExpression;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.NodeBase;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class InternalNodeImpl
extends NodeBase<InternalNodeImpl> {
    InternalNodeImpl() {
    }

    InternalNodeImpl(LabelExpression labelExpression) {
        super(null, null, labelExpression, null);
    }

    InternalNodeImpl(String primaryLabel, String ... additionalLabels) {
        super(primaryLabel, additionalLabels);
    }

    InternalNodeImpl(SymbolicName symbolicName, List<NodeLabel> labels, LabelExpression labelExpression, Properties properties) {
        super(symbolicName, labels, labelExpression, properties);
    }

    InternalNodeImpl(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        super(symbolicName, primaryLabel, properties, additionalLabels);
    }

    @Override
    @NotNull
    public InternalNodeImpl named(SymbolicName newSymbolicName) {
        Assertions.notNull(newSymbolicName, "Symbolic name is required.");
        return new InternalNodeImpl(newSymbolicName, this.labels, this.labelExpression, this.properties);
    }

    @Override
    @NotNull
    public InternalNodeImpl withProperties(MapExpression newProperties) {
        return new InternalNodeImpl((SymbolicName)this.getSymbolicName().orElse(null), this.labels, this.labelExpression, Properties.create(newProperties));
    }
}

