/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.time.Period;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LiteralBase;

final class PeriodLiteral
extends LiteralBase<Period> {
    static Literal<Period> of(Period duration) {
        return new PeriodLiteral(duration);
    }

    private PeriodLiteral(Period content) {
        super(content);
    }

    @Override
    @NotNull
    public String asString() {
        Period content = (Period)super.getContent();
        StringBuilder result = new StringBuilder();
        result.append("duration('P");
        if (content.getYears() != 0) {
            result.append(content.getYears()).append("Y");
        }
        if (content.getMonths() != 0) {
            result.append(content.getMonths()).append("M");
        }
        if (content.getDays() != 0) {
            result.append(content.getDays()).append("D");
        }
        result.append("')");
        return result.toString();
    }
}

