/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ParameterCollectingVisitor;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementCatalog;
import org.neo4j.cypherdsl.core.StatementCatalogBuildingVisitor;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.internal.DefaultStatementContext;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@API(status=API.Status.INTERNAL, since="2021.0.0")
abstract class AbstractStatement
implements Statement {
    private final StatementContext context = new DefaultStatementContext();
    private boolean renderConstantsAsParameters = false;
    private volatile ParameterCollectingVisitor.ParameterInformation parameterInformation;
    private volatile String cypher;
    private volatile StatementCatalog statementCatalog;

    AbstractStatement() {
    }

    @Override
    @NotNull
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public synchronized boolean isRenderConstantsAsParameters() {
        return this.renderConstantsAsParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        AbstractStatement abstractStatement = this;
        synchronized (abstractStatement) {
            this.renderConstantsAsParameters = renderConstantsAsParameters;
            this.cypher = null;
            this.parameterInformation = null;
            this.statementCatalog = null;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getParameters() {
        return this.getParameterInformation().values;
    }

    @NotNull
    public Set<String> getParameterNames() {
        return this.getParameterInformation().names;
    }

    @Override
    @NotNull
    public Collection<Expression> getIdentifiableExpressions() {
        return this.getCatalog().getIdentifiableExpressions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getCypher() {
        String result = this.cypher;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.cypher;
                if (result == null) {
                    result = this.cypher = Renderer.getDefaultRenderer().render(this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterCollectingVisitor.ParameterInformation getParameterInformation() {
        ParameterCollectingVisitor.ParameterInformation result = this.parameterInformation;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.parameterInformation;
                if (result == null) {
                    result = this.parameterInformation = this.collectParameters();
                }
            }
        }
        return result;
    }

    private ParameterCollectingVisitor.ParameterInformation collectParameters() {
        ParameterCollectingVisitor parameterCollectingVisitor = new ParameterCollectingVisitor(this.getContext(), this.isRenderConstantsAsParameters());
        this.accept(parameterCollectingVisitor);
        return parameterCollectingVisitor.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StatementCatalog getCatalog() {
        StatementCatalog result = this.statementCatalog;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.statementCatalog;
                if (result == null) {
                    result = this.statementCatalog = this.getCatalog0();
                }
            }
        }
        return result;
    }

    private StatementCatalog getCatalog0() {
        StatementCatalogBuildingVisitor thing = new StatementCatalogBuildingVisitor(this.getContext(), this.renderConstantsAsParameters);
        this.accept(thing);
        return thing.getResult();
    }
}

