/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.ExposesPatternLengthAccessors;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.RelationshipLength;
import org.neo4j.cypherdsl.core.internal.RelationshipTypes;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface Relationship
extends RelationshipPattern,
PropertyContainer,
ExposesProperties<Relationship>,
ExposesPatternLengthAccessors<Relationship> {
    public Node getLeft();

    @NotNull
    @Contract(pure=true)
    public Details getDetails();

    @NotNull
    @Contract(pure=true)
    public Node getRight();

    @NotNull
    @Contract(pure=true)
    public Relationship named(String var1);

    @NotNull
    @Contract(pure=true)
    public Relationship named(SymbolicName var1);

    @NotNull
    @Contract(pure=true)
    public Relationship inverse();

    @API(status=API.Status.STABLE, since="1.0")
    public static final class Details
    implements Visitable {
        private final Direction direction;
        private volatile SymbolicName symbolicName;
        private final RelationshipTypes types;
        private final RelationshipLength length;
        private final Properties properties;

        static Details create(Direction direction, SymbolicName symbolicName, String ... types) {
            List<String> listOfTypes = Arrays.stream(types).filter(type -> type != null && !type.isEmpty()).toList();
            return Details.create(direction, symbolicName, listOfTypes.isEmpty() ? null : RelationshipTypes.of(types));
        }

        static Details create(Direction direction, SymbolicName symbolicName, RelationshipTypes types) {
            return new Details(direction, symbolicName, types, null, null);
        }

        private Details(Direction direction, SymbolicName symbolicName, RelationshipTypes types, RelationshipLength length, Properties properties) {
            this.direction = Optional.ofNullable(direction).orElse(Direction.UNI);
            this.symbolicName = symbolicName;
            this.types = types;
            this.length = length;
            this.properties = properties;
        }

        public boolean hasContent() {
            return this.symbolicName != null || this.types != null || this.length != null || this.properties != null;
        }

        Details named(SymbolicName newSymbolicName) {
            Assertions.notNull(newSymbolicName, "Symbolic name is required.");
            return new Details(this.direction, newSymbolicName, this.types, this.length, this.properties);
        }

        Details with(Properties newProperties) {
            return new Details(this.direction, this.symbolicName, this.types, this.length, newProperties);
        }

        Details unbounded() {
            return new Details(this.direction, this.symbolicName, this.types, RelationshipLength.unbounded(), this.properties);
        }

        Details inverse() {
            if (this.direction == Direction.UNI) {
                return this;
            }
            return new Details(this.direction == Direction.LTR ? Direction.RTL : Direction.LTR, null, this.types, this.length, this.properties);
        }

        Details min(Integer minimum) {
            if (minimum == null && (this.length == null || this.length.getMinimum() == null)) {
                return this;
            }
            RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> RelationshipLength.of(minimum, l.getMaximum())).orElseGet(() -> RelationshipLength.of(minimum, null));
            return new Details(this.direction, this.symbolicName, this.types, newLength, this.properties);
        }

        Details max(Integer maximum) {
            if (maximum == null && (this.length == null || this.length.getMaximum() == null)) {
                return this;
            }
            RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> RelationshipLength.of(l.getMinimum(), maximum)).orElseGet(() -> RelationshipLength.of(null, maximum));
            return new Details(this.direction, this.symbolicName, this.types, newLength, this.properties);
        }

        @API(status=API.Status.INTERNAL)
        public Direction getDirection() {
            return this.direction;
        }

        Optional<SymbolicName> getSymbolicName() {
            return Optional.ofNullable(this.symbolicName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SymbolicName getRequiredSymbolicName() {
            SymbolicName requiredSymbolicName = this.symbolicName;
            if (requiredSymbolicName == null) {
                Details details = this;
                synchronized (details) {
                    requiredSymbolicName = this.symbolicName;
                    if (requiredSymbolicName == null) {
                        requiredSymbolicName = this.symbolicName = SymbolicName.unresolved();
                    }
                }
            }
            return requiredSymbolicName;
        }

        @API(status=API.Status.INTERNAL)
        public List<String> getTypes() {
            return this.types == null ? List.of() : List.copyOf(this.types.getValues());
        }

        @API(status=API.Status.INTERNAL)
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            Visitable.visitIfNotNull(this.symbolicName, visitor);
            Visitable.visitIfNotNull(this.types, visitor);
            Visitable.visitIfNotNull(this.length, visitor);
            Visitable.visitIfNotNull(this.properties, visitor);
            visitor.leave(this);
        }
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static enum Direction {
        LTR("-", "->"),
        RTL("<-", "-"),
        UNI("-", "-");

        private final String symbolLeft;
        private final String symbolRight;

        private Direction(String symbolLeft, String symbolRight) {
            this.symbolLeft = symbolLeft;
            this.symbolRight = symbolRight;
        }

        @API(status=API.Status.INTERNAL)
        public String getSymbolLeft() {
            return this.symbolLeft;
        }

        @API(status=API.Status.INTERNAL)
        public String getSymbolRight() {
            return this.symbolRight;
        }
    }
}

